/**
 * Audited & minimal JS implementation of hash functions, MACs and KDFs. Check out individual modules.
 * @module
 * @example
```js
import {
  sha256, sha384, sha512, sha224, sha512_224, sha512_256
} from '@noble/hashes/sha2.js';
import {
  sha3_224, sha3_256, sha3_384, sha3_512,
  keccak_224, keccak_256, keccak_384, keccak_512,
  shake128, shake256
} from '@noble/hashes/sha3.js';
import {
  cshake128, cshake256,
  turboshake128, turboshake256,
  kt128, kt256,
  kmac128, kmac256,
  tuplehash256, parallelhash256,
  keccakprg
} from '@noble/hashes/sha3-addons.js';
import { blake3 } from '@noble/hashes/blake3.js';
import { blake2b, blake2s } from '@noble/hashes/blake2.js';
import { hmac } from '@noble/hashes/hmac.js';
import { hkdf } from '@noble/hashes/hkdf.js';
import { pbkdf2, pbkdf2Async } from '@noble/hashes/pbkdf2.js';
import { scrypt, scryptAsync } from '@noble/hashes/scrypt.js';
import { md5, ripemd160, sha1 } from '@noble/hashes/legacy.js';
import * as utils from '@noble/hashes/utils.js';
```
 */
throw new Error('root module cannot be imported: import submodules instead. Check out README');
