#!/usr/bin/env node
import "./init-CuDouDN2.mjs";
import { c as createClient } from "./src-DRRrhVf_.mjs";
import { Command, CommanderError } from "commander";

//#region package.json
var version = "0.93.1";
var bin = { "openapi-ts": "./bin/run.js" };

//#endregion
//#region src/cli/adapter.ts
function cliToConfig(cli) {
	const config = {};
	if (cli.input) config.input = cli.input;
	if (cli.output) config.output = cli.output;
	if (cli.file) config.configFile = cli.file;
	if (cli.dryRun !== void 0) config.dryRun = cli.dryRun;
	const plugins = [];
	if (cli.plugins instanceof Array && cli.plugins.length > 0) plugins.push(...cli.plugins);
	if (cli.client) plugins.push(cli.client);
	if (plugins.length > 0) config.plugins = plugins;
	if (cli.debug || cli.silent || cli.logs || cli.logFile === false) config.logs = {
		...cli.logs && { path: cli.logs },
		...cli.debug && { level: "debug" },
		...cli.silent && { level: "silent" },
		...cli.logFile === false && { file: false }
	};
	if (cli.watch !== void 0) if (typeof cli.watch === "string") config.watch = Number.parseInt(cli.watch, 10);
	else config.watch = cli.watch;
	return config;
}

//#endregion
//#region src/cli/index.ts
const binName = Object.keys(bin)[0];
const program = new Command().name(binName).description("Generate TypeScript code from OpenAPI specifications").version(version);
program.option("-i, --input <path...>", "OpenAPI specification (path, URL, or string)").option("-o, --output <path...>", "Output folder(s)").option("-c, --client <name>", "HTTP client to generate").option("-p, --plugins [names...]", "Plugins to use").option("-f, --file <path>", "Path to config file").option("-d, --debug", "Enable debug logging").option("-s, --silent", "Suppress all output").option("-l, --logs <path>", "Logs folder path").option("--no-log-file", "Disable log file output").option("--dry-run", "Skip writing files").option("-w, --watch [interval]", "Watch for changes").action(async (options) => {
	if (!(await createClient(cliToConfig(options)))[0]?.config.input.some((input) => input.watch?.enabled)) process.exit(0);
});
async function runCli() {
	try {
		await program.parseAsync(process.argv);
	} catch (error) {
		if (error instanceof CommanderError && "code" in error) {
			if (error.code === "commander.optionMissingArgument") console.error(`\nMissing required argument. Run '${binName} --help' for usage.\n`);
			else if (error.code === "commander.unknownOption") console.error(`\nUnknown option. Run '${binName} --help' for available options.\n`);
			process.exit(error.exitCode);
		}
		console.error("Unexpected error:", error);
		process.exit(1);
	}
}

//#endregion
//#region src/run.ts
runCli();

//#endregion
export {  };
//# sourceMappingURL=run.mjs.map