import { n as UserConfig } from "./types-Ba27ofyy.mjs";
import * as _hey_api_codegen_core0 from "@hey-api/codegen-core";
import { AnalysisContext, BindingKind, ExportModule, File, FromRef, ImportModule, Language, Logger, Logger as Logger$1, Node, NodeName, NodeNameSanitizer, NodeRelationship, NodeScope, Ref, Refs, RenderContext, Renderer, Symbol, SymbolMeta } from "@hey-api/codegen-core";
import { Casing, Context, DefinePlugin, DefinePlugin as DefinePlugin$1, FeatureToggle, IR, IR as IR$1, LinguistLanguages, NameTransformer, NamingConfig, NamingOptions, NamingRule, OpenApi, OpenApiMetaObject, OpenApiOperationObject, OpenApiParameterObject, OpenApiRequestBodyObject, OpenApiResponseObject, OpenApiSchemaObject, OpenApiV2_0_XTypes, OpenApiV3_0_XTypes, OpenApiV3_1_XTypes, OperationPath, OperationPathStrategy, OperationStrategy, OperationsStrategy, Plugin, Plugin as Plugin$1, SchemaExtractor, SchemaVisitorContext, SchemaWithType, Walker, defaultPaginationKeywords, definePluginConfig, utils } from "@hey-api/shared";
import ts from "typescript";
import { AnyString, LazyOrAsync, MaybeArray, MaybeFunc } from "@hey-api/types";
import { HttpClient, HttpErrorResponse, HttpHeaders, HttpRequest, HttpResponse } from "@angular/common/http";
import { Injector } from "@angular/core";
import { AxiosError, AxiosInstance, AxiosRequestHeaders, AxiosResponse, AxiosStatic, CreateAxiosDefaults } from "axios";
import { AsyncDataOptions, UseFetchOptions, useAsyncData, useFetch, useLazyAsyncData, useLazyFetch } from "nuxt/app";
import { Ref as Ref$1 } from "vue";
import { FetchOptions, ResponseType, ofetch } from "ofetch";

//#region src/plugins/@angular/common/httpRequests/types.d.ts
interface UserHttpRequestsConfig {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   *
   * @default 'class'
   */
  container?: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', case: 'PascalCase' }
   */
  containerName?: NamingRule;
  /**
   * Whether this feature is enabled.
   *
   * @default true
   */
  enabled?: boolean;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName?: NamingRule;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   *
   * @default 'instance'
   */
  methods?: 'instance';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   *
   * @default 'operationId'
   */
  nesting?: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   *
   * @default /[./]/
   */
  nestingDelimiters?: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName?: NamingRule;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   *
   * @default 'flat'
   */
  strategy?: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   *
   * @default 'default'
   */
  strategyDefaultTag?: string;
}
type HttpRequestsConfig = FeatureToggle & {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   */
  container: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', case: 'PascalCase' }
   */
  containerName: NamingConfig;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName: NamingConfig;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   */
  methods: 'instance';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   */
  nesting: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   */
  nestingDelimiters: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName: NamingConfig;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   */
  strategy: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   */
  strategyDefaultTag: string;
};
//#endregion
//#region src/plugins/@angular/common/httpResources/types.d.ts
interface UserHttpResourcesConfig {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   *
   * @default 'class'
   */
  container?: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', case: 'PascalCase' }
   */
  containerName?: NamingRule;
  /**
   * Whether this feature is enabled.
   *
   * @default true
   */
  enabled?: boolean;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName?: NamingRule;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   *
   * @default 'instance'
   */
  methods?: 'instance';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   *
   * @default 'operationId'
   */
  nesting?: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   *
   * @default /[./]/
   */
  nestingDelimiters?: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName?: NamingRule;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   *
   * @default 'flat'
   */
  strategy?: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   *
   * @default 'default'
   */
  strategyDefaultTag?: string;
}
type HttpResourcesConfig = FeatureToggle & {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   */
  container: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', case: 'PascalCase' }
   */
  containerName: NamingConfig;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName: NamingConfig;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   */
  methods: 'instance';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   */
  nesting: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   */
  nestingDelimiters: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName: NamingConfig;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   */
  strategy: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   */
  strategyDefaultTag: string;
};
//#endregion
//#region src/plugins/@angular/common/types.d.ts
type UserConfig$24 = Plugin$1.Name<'@angular/common'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Options for generating HTTP Request instances.
   *
   * @default 'flat'
   */
  httpRequests?: boolean | OperationsStrategy | UserHttpRequestsConfig;
  /**
   * Options for generating HTTP resource APIs.
   *
   * @default 'flat'
   */
  httpResources?: boolean | OperationsStrategy | UserHttpResourcesConfig;
};
type Config$21 = Plugin$1.Name<'@angular/common'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Options for generating HTTP Request instances.
   */
  httpRequests: HttpRequestsConfig;
  /**
   * Options for generating HTTP resource APIs.
   */
  httpResources: HttpResourcesConfig;
};
type AngularCommonPlugin = DefinePlugin$1<UserConfig$24, Config$21>;
//#endregion
//#region src/ts-dsl/mixins/types.d.ts
type BaseCtor<T extends ts.Node> = abstract new (...args: Array<any>) => TsDsl<T>;
type DropFirst<T extends Array<any>> = T extends [any, ...infer Rest] ? Rest : never;
type MixinCtor<T extends BaseCtor<any>, K$1> = abstract new (...args: Array<any>) => InstanceType<T> & K$1;
//#endregion
//#region src/ts-dsl/mixins/type-args.d.ts
type Arg$1 = NodeName | MaybeTsDsl<TypeTsDsl>;
interface TypeArgsMethods extends Node {
  /** Returns the type arguments as an array of ts.TypeNode nodes. */
  $generics(): ReadonlyArray<ts.TypeNode> | undefined;
  /** Adds a single type argument (e.g. `string` in `Foo<string>`). */
  generic(arg: Arg$1): this;
  /** Adds type arguments (e.g. `Map<string, number>`). */
  generics(...args: ReadonlyArray<Arg$1>): this;
}
//#endregion
//#region src/ts-dsl/mixins/as.d.ts
interface AsMethods extends Node {
  /** Creates an `as` type assertion expression (e.g. `value as Type`). */
  as(...args: DropFirst<Parameters<typeof f.as>>): ReturnType<typeof f.as>;
}
//#endregion
//#region src/ts-dsl/expr/as.d.ts
type AsExpr = NodeName | MaybeTsDsl<ts.Expression>;
type AsType = NodeName | TypeTsDsl;
type AsCtor = (expr: AsExpr, type: AsType) => AsTsDsl;
declare const Mixed$52: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.AsExpression>, ExprMethods>, AsMethods>;
declare class AsTsDsl extends Mixed$52 {
  readonly '~dsl' = "AsTsDsl";
  protected expr: Ref<AsExpr>;
  protected type: Ref<AsType>;
  constructor(expr: AsExpr, type: AsType);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.AsExpression;
}
//#endregion
//#region src/ts-dsl/mixins/optional.d.ts
interface OptionalMethods extends Node {
  _optional?: boolean;
  /** Marks the node as optional when the condition is true. */
  optional(condition?: boolean): this;
  /** Marks the node as required when the condition is true. */
  required(condition?: boolean): this;
}
//#endregion
//#region src/ts-dsl/expr/binary.d.ts
type Expr$3 = NodeName | MaybeTsDsl<ts.Expression>;
type Op$1 = Operator | ts.BinaryOperator;
type Operator = '!=' | '!==' | '&&' | '*' | '+' | '-' | '/' | '<' | '<=' | '=' | '==' | '===' | '>' | '>=' | '??' | '??=' | '||';
declare const Mixed$51: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.BinaryExpression>, ExprMethods>, AsMethods>;
declare class BinaryTsDsl extends Mixed$51 {
  readonly '~dsl' = "BinaryTsDsl";
  protected _base: Ref<Expr$3>;
  protected _expr?: Ref<Expr$3>;
  protected _op?: Op$1;
  constructor(base: Expr$3, op?: Op$1, expr?: Expr$3);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Logical AND — `this && expr` */
  and(expr: Expr$3): this;
  /** Creates an assignment expression (e.g. `this = expr`). */
  assign(expr: Expr$3): this;
  /** Nullish coalescing — `this ?? expr` */
  coalesce(expr: Expr$3): this;
  /** Division — `this / expr` */
  div(expr: Expr$3): this;
  /** Strict equality — `this === expr` */
  eq(expr: Expr$3): this;
  /** Greater than — `this > expr` */
  gt(expr: Expr$3): this;
  /** Greater than or equal — `this >= expr` */
  gte(expr: Expr$3): this;
  /** Loose equality — `this == expr` */
  looseEq(expr: Expr$3): this;
  /** Loose inequality — `this != expr` */
  looseNeq(expr: Expr$3): this;
  /** Less than — `this < expr` */
  lt(expr: Expr$3): this;
  /** Less than or equal — `this <= expr` */
  lte(expr: Expr$3): this;
  /** Subtraction — `this - expr` */
  minus(expr: Expr$3): this;
  /** Strict inequality — `this !== expr` */
  neq(expr: Expr$3): this;
  /** Nullish assignment — `this ??= expr` */
  nullishAssign(expr: Expr$3): this;
  /** Logical OR — `this || expr` */
  or(expr: Expr$3): this;
  /** Addition — `this + expr` */
  plus(expr: Expr$3): this;
  /** Multiplication — `this * expr` */
  times(expr: Expr$3): this;
  toAst(): ts.BinaryExpression;
  $validate(): asserts this is this & {
    _expr: Ref<Expr$3>;
    _op: Op$1;
  };
  private missingRequiredCalls;
  /** Sets the binary operator and right-hand operand for this expression. */
  private opAndExpr;
  private opToToken;
}
//#endregion
//#region src/ts-dsl/mixins/operator.d.ts
type Expr$2 = NodeName | MaybeTsDsl<ts.Expression>;
interface OperatorMethods extends Node {
  /** Logical AND — `this && expr` */
  and(expr: Expr$2): BinaryTsDsl;
  /** Creates an assignment expression (e.g. `this = expr`). */
  assign(expr: Expr$2): BinaryTsDsl;
  /** Nullish coalescing — `this ?? expr` */
  coalesce(expr: Expr$2): BinaryTsDsl;
  /** Division — `this / expr` */
  div(expr: Expr$2): BinaryTsDsl;
  /** Strict equality — `this === expr` */
  eq(expr: Expr$2): BinaryTsDsl;
  /** Greater than — `this > expr` */
  gt(expr: Expr$2): BinaryTsDsl;
  /** Greater than or equal — `this >= expr` */
  gte(expr: Expr$2): BinaryTsDsl;
  /** Loose equality — `this == expr` */
  looseEq(expr: Expr$2): BinaryTsDsl;
  /** Loose inequality — `this != expr` */
  looseNeq(expr: Expr$2): BinaryTsDsl;
  /** Less than — `this < expr` */
  lt(expr: Expr$2): BinaryTsDsl;
  /** Less than or equal — `this <= expr` */
  lte(expr: Expr$2): BinaryTsDsl;
  /** Subtraction — `this - expr` */
  minus(expr: Expr$2): BinaryTsDsl;
  /** Strict inequality — `this !== expr` */
  neq(expr: Expr$2): BinaryTsDsl;
  /** Nullish assignment — `this ??= expr` */
  nullishAssign(expr: Expr$2): BinaryTsDsl;
  /** Logical OR — `this || expr` */
  or(expr: Expr$2): BinaryTsDsl;
  /** Addition — `this + expr` */
  plus(expr: Expr$2): BinaryTsDsl;
  /** Multiplication — `this * expr` */
  times(expr: Expr$2): BinaryTsDsl;
}
//#endregion
//#region src/ts-dsl/expr/attr.d.ts
type AttrLeft = NodeName | MaybeTsDsl<ts.Expression>;
type AttrCtor = (left: AttrLeft, right: NodeName) => AttrTsDsl;
declare const Mixed$50: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.PropertyAccessExpression | ts.ElementAccessExpression>, OptionalMethods>, OperatorMethods>, ExprMethods>, AsMethods>;
declare class AttrTsDsl extends Mixed$50 {
  readonly '~dsl' = "AttrTsDsl";
  protected left: Ref<AttrLeft>;
  constructor(left: AttrLeft, right: NodeName);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.PropertyAccessExpression | ts.ElementAccessExpression;
}
//#endregion
//#region src/ts-dsl/expr/await.d.ts
type AwaitExpr = NodeName | MaybeTsDsl<ts.Expression>;
type AwaitCtor = (expr: AwaitExpr) => AwaitTsDsl;
declare const Mixed$49: MixinCtor<abstract new () => TsDsl<ts.AwaitExpression>, ExprMethods>;
declare class AwaitTsDsl extends Mixed$49 {
  readonly '~dsl' = "AwaitTsDsl";
  protected _awaitExpr: Ref<AwaitExpr>;
  constructor(expr: AwaitExpr);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.AwaitExpression;
}
//#endregion
//#region src/ts-dsl/mixins/args.d.ts
type Arg = NodeName | MaybeTsDsl<ts.Expression>;
interface ArgsMethods extends Node {
  /** Renders the arguments into an array of `Expression`s. */
  $args(): ReadonlyArray<ts.Expression>;
  /** Adds a single expression argument. */
  arg(arg: Arg | undefined): this;
  /** Adds one or more expression arguments. */
  args(...args: ReadonlyArray<Arg | undefined>): this;
}
//#endregion
//#region src/ts-dsl/expr/new.d.ts
type NewArgs = ReadonlyArray<NewExpr | undefined>;
type NewExpr = NodeName | MaybeTsDsl<ts.Expression>;
type NewCtor = (expr: NewExpr, ...args: NewArgs) => NewTsDsl;
declare const Mixed$48: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.NewExpression>, TypeArgsMethods>, ExprMethods>, AsMethods>, ArgsMethods>;
declare class NewTsDsl extends Mixed$48 {
  readonly '~dsl' = "NewTsDsl";
  protected _newExpr: Ref<NewExpr>;
  constructor(expr: NewExpr, ...args: NewArgs);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.NewExpression;
}
//#endregion
//#region src/ts-dsl/expr/typeof.d.ts
type TypeOfExpr = string | MaybeTsDsl<ts.Expression>;
type TypeOfExprCtor = (expr: TypeOfExpr) => TypeOfExprTsDsl;
declare const Mixed$47: MixinCtor<abstract new () => TsDsl<ts.TypeOfExpression>, OperatorMethods>;
declare class TypeOfExprTsDsl extends Mixed$47 {
  readonly '~dsl' = "TypeOfExprTsDsl";
  protected _expr: TypeOfExpr;
  constructor(expr: TypeOfExpr);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.TypeOfExpression;
}
//#endregion
//#region src/ts-dsl/stmt/return.d.ts
type ReturnExpr = NodeName | MaybeTsDsl<ts.Expression>;
type ReturnCtor = (expr?: ReturnExpr) => ReturnTsDsl;
declare const Mixed$46: abstract new () => TsDsl<ts.ReturnStatement>;
declare class ReturnTsDsl extends Mixed$46 {
  readonly '~dsl' = "ReturnTsDsl";
  protected _returnExpr?: Ref<ReturnExpr>;
  constructor(expr?: ReturnExpr);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.ReturnStatement;
}
//#endregion
//#region src/ts-dsl/mixins/type-expr.d.ts
interface TypeExprMethods extends Node {
  /** Creates an indexed-access type (e.g. `Foo<T>[K]`). */
  idx(this: Parameters<typeof f.type.idx>[0], ...args: DropFirst<Parameters<typeof f.type.idx>>): ReturnType<typeof f.type.idx>;
  /** Shorthand: builds `keyof T`. */
  keyof(this: MaybeTsDsl<TypeTsDsl>): ReturnType<typeof f.type.operator>;
  /** Shorthand: builds `readonly T`. */
  readonly(this: MaybeTsDsl<TypeTsDsl>): ReturnType<typeof f.type.operator>;
  /** Create a TypeExpr node representing ReturnType<this>. */
  returnType(this: Parameters<typeof f.type.query>[0], ...args: DropFirst<Parameters<typeof f.type.query>>): ReturnType<typeof f.type.expr>;
  /** Create a TypeOfExpr node representing typeof this. */
  typeofExpr(this: Parameters<typeof f.typeofExpr>[0], ...args: DropFirst<Parameters<typeof f.typeofExpr>>): ReturnType<typeof f.typeofExpr>;
  /** Create a TypeQuery node representing typeof this. */
  typeofType(this: Parameters<typeof f.type.query>[0], ...args: DropFirst<Parameters<typeof f.type.query>>): ReturnType<typeof f.type.query>;
  /** Shorthand: builds `unique T`. */
  unique(this: MaybeTsDsl<TypeTsDsl>): ReturnType<typeof f.type.operator>;
}
//#endregion
//#region src/ts-dsl/type/attr.d.ts
type Base$1 = NodeName | MaybeTsDsl<ts.EntityName>;
type Right = NodeName | ts.Identifier;
declare const Mixed$45: MixinCtor<abstract new () => TsDsl<ts.QualifiedName>, TypeExprMethods>;
declare class TypeAttrTsDsl extends Mixed$45 {
  readonly '~dsl' = "TypeAttrTsDsl";
  scope: NodeScope;
  protected _base?: Ref<Base$1>;
  protected _right: Ref<Right>;
  constructor(base: Base$1 | Ref<Base$1>, right: string | ts.Identifier);
  constructor(right: Right);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  base(base?: Base$1 | Ref<Base$1>): this;
  right(right: Right): this;
  toAst(): ts.QualifiedName;
  $validate(): asserts this is this & {
    _base: Ref<Base$1>;
    _right: Ref<Right>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/expr.d.ts
type TypeExprExpr = NodeName | TypeAttrTsDsl;
type TypeExprFn = (t: TypeExprTsDsl) => void;
type TypeExprCtor = (nameOrFn?: NodeName | TypeExprFn, fn?: TypeExprFn) => TypeExprTsDsl;
declare const Mixed$44: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.TypeReferenceNode>, TypeExprMethods>, TypeArgsMethods>;
declare class TypeExprTsDsl extends Mixed$44 {
  readonly '~dsl' = "TypeExprTsDsl";
  scope: NodeScope;
  protected _exprInput?: Ref<TypeExprExpr>;
  constructor();
  constructor(fn: TypeExprFn);
  constructor(name: NodeName);
  constructor(name: NodeName, fn?: TypeExprFn);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Accesses a nested type (e.g. `Foo.Bar`). */
  attr(right: string | ts.Identifier | TypeAttrTsDsl): this;
  toAst(): ts.TypeReferenceNode;
  $validate(): asserts this is this & {
    _exprInput: Ref<TypeExprExpr>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/idx.d.ts
type Base = string | MaybeTsDsl<ts.TypeNode>;
type Index = string | number | MaybeTsDsl<ts.TypeNode>;
type TypeIdxCtor = (base: Base, index: Index) => TypeIdxTsDsl;
declare const Mixed$43: MixinCtor<abstract new () => TsDsl<ts.IndexedAccessTypeNode>, TypeExprMethods>;
declare class TypeIdxTsDsl extends Mixed$43 {
  readonly '~dsl' = "TypeIdxTsDsl";
  scope: NodeScope;
  protected _base: Base;
  protected _index: Index;
  constructor(base: Base, index: Index);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  base(base: Base): this;
  index(index: Index): this;
  toAst(): ts.IndexedAccessTypeNode;
  $validate(): asserts this is this & {
    _base: Base;
    _index: Index;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/operator.d.ts
type Op = ts.SyntaxKind.KeyOfKeyword | ts.SyntaxKind.ReadonlyKeyword | ts.SyntaxKind.UniqueKeyword;
type Type$2 = string | MaybeTsDsl<ts.TypeNode>;
type TypeOperatorCtor = () => TypeOperatorTsDsl;
declare const Mixed$42: abstract new () => TsDsl<ts.TypeOperatorNode>;
/**
 * Builds a TypeScript `TypeOperatorNode`, such as:
 *
 * - `keyof T`
 * - `readonly U`
 * - `unique V`
 *
 * This DSL provides both a generic `.operator()` API and convenient
 * shorthand methods (`.keyof()`, `.readonly()`, `.unique()`).
 *
 * The node will throw during render if required fields are missing.
 */
declare class TypeOperatorTsDsl extends Mixed$42 {
  readonly '~dsl' = "TypeOperatorTsDsl";
  scope: NodeScope;
  protected _op?: Op;
  protected _type?: Type$2;
  analyze(ctx: AnalysisContext): void;
  /** Shorthand: builds `keyof T`. */
  keyof(type: Type$2): this;
  /** Sets the operator explicitly. */
  operator(op: Op): this;
  /** Shorthand: builds `readonly T`. */
  readonly(type: Type$2): this;
  /** Sets the target type of the operator. */
  type(type: Type$2): this;
  /** Shorthand: builds `unique T`. */
  unique(type: Type$2): this;
  toAst(): ts.TypeOperatorNode;
  /** Throws if required fields are not set. */
  $validate(): asserts this is this & {
    _op: Op;
    _type: Type$2;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/query.d.ts
type TypeQueryExpr = string | MaybeTsDsl<TypeTsDsl | ts.Expression>;
type TypeQueryCtor = (expr: TypeQueryExpr) => TypeQueryTsDsl;
declare const Mixed$41: MixinCtor<abstract new () => TsDsl<ts.TypeQueryNode>, TypeExprMethods>;
declare class TypeQueryTsDsl extends Mixed$41 {
  readonly '~dsl' = "TypeQueryTsDsl";
  scope: NodeScope;
  protected _expr: TypeQueryExpr;
  constructor(expr: TypeQueryExpr);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.TypeQueryNode;
}
//#endregion
//#region src/ts-dsl/utils/factories.d.ts
type Ctor = (...args: Array<any>) => any;
type Factory<T extends Ctor> = {
  (...args: Parameters<T>): ReturnType<T>;
  /** Sets the implementation of this factory. */
  set(fn: T): void;
};
declare const f: {
  /** Factory for creating `as` type assertion expressions (e.g. `value as Type`). */
  as: Factory<AsCtor>;
  /** Factory for creating property access expressions (e.g. `obj.foo`). */
  attr: Factory<AttrCtor>;
  /** Factory for creating await expressions (e.g. `await promise`). */
  await: Factory<AwaitCtor>;
  /** Factory for creating function or method call expressions (e.g. `fn(arg)`). */
  call: Factory<CallCtor>;
  /** Factory for creating new expressions (e.g. `new ClassName()`). */
  new: Factory<NewCtor>;
  /** Factory for creating return statements. */
  return: Factory<ReturnCtor>;
  /** Factories for creating type nodes. */
  type: {
    /** Factory for creating basic type references or type expressions (e.g. Foo or Foo<T>). */
    expr: Factory<TypeExprCtor>;
    /** Factory for creating indexed-access types (e.g. `Foo<T>[K]`). */
    idx: Factory<TypeIdxCtor>;
    /** Factory for creating type operator nodes (e.g. `readonly T`, `keyof T`, `unique T`). */
    operator: Factory<TypeOperatorCtor>;
    /** Factory for creating type query nodes (e.g. `typeof Foo`). */
    query: Factory<TypeQueryCtor>;
  };
  /** Factory for creating `typeof` expressions (e.g. `typeof value`). */
  typeofExpr: Factory<TypeOfExprCtor>;
};
//#endregion
//#region src/ts-dsl/mixins/expr.d.ts
interface ExprMethods extends Node {
  /** Accesses a property on the current expression (e.g. `this.foo`). */
  attr(...args: DropFirst<Parameters<typeof f.attr>>): ReturnType<typeof f.attr>;
  /** Awaits the current expression (e.g. `await expr`). */
  await(): ReturnType<typeof f.await>;
  /** Calls the current expression (e.g. `fn(arg1, arg2)`). */
  call(...args: DropFirst<Parameters<typeof f.call>>): ReturnType<typeof f.call>;
  /** Produces a `return` statement returning the current expression. */
  return(): ReturnType<typeof f.return>;
}
//#endregion
//#region src/ts-dsl/expr/call.d.ts
type CallArgs = ReadonlyArray<CallCallee | undefined>;
type CallCallee = NodeName | MaybeTsDsl<ts.Expression>;
type CallCtor = (callee: CallCallee, ...args: CallArgs) => CallTsDsl;
declare const Mixed$40: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.CallExpression>, TypeArgsMethods>, ExprMethods>, AsMethods>, ArgsMethods>;
declare class CallTsDsl extends Mixed$40 {
  readonly '~dsl' = "CallTsDsl";
  protected _callee: Ref<CallCallee>;
  constructor(callee: CallCallee, ...args: CallArgs);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.CallExpression;
}
//#endregion
//#region src/ts-dsl/utils/context.d.ts
type NodeChain = ReadonlyArray<TsDsl>;
interface AccessOptions {
  /** The access context. */
  context?: 'example';
  /** Enable debug mode. */
  debug?: boolean;
  /** Transform function for each node in the access chain. */
  transform?: (node: TsDsl, index: number, chain: NodeChain) => TsDsl;
}
type AccessResult = ReturnType<typeof $.expr | typeof $.attr | typeof $.call | typeof $.new>;
interface ExampleOptions {
  /** Import kind for the root node. */
  importKind?: BindingKind;
  /** Import name for the root node. */
  importName?: string;
  /** Setup to run before calling the example. */
  importSetup?: MaybeFunc<(ctx: DollarTsDsl & {
    /** The imported expression. */
    node: TsDsl<ts.Expression>;
  }) => TsDsl<ts.Expression>>;
  /** Module to import from. */
  moduleName?: string;
  /** Example request payload. */
  payload?: MaybeFunc<(ctx: DollarTsDsl) => CallArgs | CallArgs[number]>;
  /** Variable name for setup node. */
  setupName?: string;
}
declare class TsDslContext {
  /**
   * Build an expression for accessing the node.
   *
   * @param node - The node or symbol to build access for
   * @param options - Access options
   * @returns Expression for accessing the node
   *
   * @example
   * ```ts
   * ctx.access(node); // → Expression for accessing the node
   * ```
   */
  access<T = AccessResult>(node: TsDsl | Symbol<TsDsl>, options?: AccessOptions): T;
  /**
   * Build an example.
   *
   * @param node - The node to generate an example for
   * @param options - Example options
   * @returns Full example string
   *
   * @example
   * ```ts
   * ctx.example(node, { moduleName: 'my-sdk' }); // → Full example string
   * ```
   */
  example(node: TsDsl, options?: ExampleOptions, astOptions?: Parameters<typeof TypeScriptRenderer.astToString>[0]): string;
}
declare const ctx: TsDslContext;
//#endregion
//#region src/ts-dsl/base.d.ts
declare abstract class TsDsl<T extends ts.Node = ts.Node> implements Node<T> {
  analyze(_: AnalysisContext): void;
  clone(): this;
  exported?: boolean;
  file?: File;
  get name(): Node['name'];
  readonly nameSanitizer?: NodeNameSanitizer;
  language: Language;
  parent?: Node;
  root: boolean;
  scope?: NodeScope;
  structuralChildren?: Map<TsDsl, NodeRelationship>;
  structuralParents?: Map<TsDsl, NodeRelationship>;
  symbol?: Symbol;
  toAst(): T;
  readonly '~brand' = "heyapi.node";
  /** Branding property to identify the DSL class at runtime. */
  abstract readonly '~dsl': AnyString;
  /** Conditionally applies a callback to this builder. */
  $if<T extends TsDsl, V, R extends TsDsl = T>(this: T, value: V, ifTrue: (self: T, v: Exclude<V, false | null | undefined>) => R | void, ifFalse?: (self: T, v: Extract<V, false | null | undefined>) => R | void): R | T;
  $if<T extends TsDsl, V, R extends TsDsl = T>(this: T, value: V, ifTrue: (v: Exclude<V, false | null | undefined>) => R | void, ifFalse?: (v: Extract<V, false | null | undefined>) => R | void): R | T;
  $if<T extends TsDsl, V, R extends TsDsl = T>(this: T, value: V, ifTrue: () => R | void, ifFalse?: () => R | void): R | T;
  /** Access patterns for this node. */
  toAccessNode?(node: this, options: AccessOptions, ctx: {
    /** The full chain. */
    chain: ReadonlyArray<TsDsl>;
    /** Position in the chain (0 = root). */
    index: number;
    /** Is this the leaf node? */
    isLeaf: boolean;
    /** Is this the root node? */
    isRoot: boolean;
    /** Total length of the chain. */
    length: number;
  }): TsDsl | undefined;
  protected $maybeId<T extends string | ts.Expression>(expr: T): T extends string ? ts.Identifier : T;
  protected $name(name: Ref<NodeName>): string;
  protected $node<I>(value: I): NodeOfMaybe<I>;
  protected $type<I>(value: I, args?: ReadonlyArray<ts.TypeNode>): TypeOfMaybe<I>;
  private _name?;
  /** Unwraps nested nodes into raw TypeScript AST. */
  private unwrap;
}
type NodeOfMaybe<I> = undefined extends I ? NodeOf<NonNullable<FromRef<I>>> | undefined : NodeOf<FromRef<I>>;
type NodeOf<I> = I extends ReadonlyArray<infer U> ? ReadonlyArray<U extends TsDsl<infer N> ? N : U> : I extends string ? ts.Expression : I extends TsDsl<infer N> ? N : I extends ts.Node ? I : never;
type MaybeTsDsl<T> = T extends TsDsl<infer U> ? U | TsDsl<U> : T extends ts.Node ? T | TsDsl<T> : never;
declare abstract class TypeTsDsl<T extends ts.LiteralTypeNode | ts.QualifiedName | ts.TypeElement | ts.TypeNode | ts.TypeParameterDeclaration = ts.TypeNode> extends TsDsl<T> {}
type TypeOfMaybe<I> = undefined extends I ? TypeOf<NonNullable<FromRef<I>>> | undefined : TypeOf<FromRef<I>>;
type TypeOf<I> = I extends ReadonlyArray<infer U> ? ReadonlyArray<TypeOf<U>> : I extends string ? ts.TypeNode : I extends boolean ? ts.LiteralTypeNode : I extends TsDsl<infer N> ? N : I extends ts.TypeNode ? I : never;
//#endregion
//#region src/ts-dsl/layout/doc.d.ts
type DocMaybeLazy<T> = ((ctx: TsDslContext) => T) | T;
type DocFn = (d: DocTsDsl) => void;
type DocLines = DocMaybeLazy<MaybeArray<string>>;
declare class DocTsDsl extends TsDsl<ts.Node> {
  readonly '~dsl' = "DocTsDsl";
  protected _lines: Array<DocLines>;
  constructor(lines?: DocLines, fn?: DocFn);
  analyze(ctx: AnalysisContext): void;
  add(lines: DocLines): this;
  apply<T extends ts.Node>(node: T): T;
  toAst(): ts.Node;
}
//#endregion
//#region src/ts-dsl/layout/hint.d.ts
type HintMaybeLazy<T> = ((ctx: TsDslContext) => T) | T;
type HintFn = (d: HintTsDsl) => void;
type HintLines = HintMaybeLazy<MaybeArray<string>>;
declare class HintTsDsl extends TsDsl<ts.Node> {
  readonly '~dsl' = "HintTsDsl";
  protected _lines: Array<HintLines>;
  constructor(lines?: HintLines, fn?: HintFn);
  analyze(ctx: AnalysisContext): void;
  add(lines: HintLines): this;
  apply<T extends ts.Node>(node: T): T;
  toAst(): ts.Node;
}
//#endregion
//#region src/ts-dsl/mixins/do.d.ts
type DoExpr = MaybeTsDsl<ts.Expression | ts.Statement>;
interface DoMethods extends Node {
  /** Renders the collected `.do()` calls into an array of `Statement` nodes. */
  $do(): ReadonlyArray<ts.Statement>;
  _do: Array<DoExpr>;
  /** Adds one or more expressions/statements to the body. */
  do(...items: ReadonlyArray<DoExpr>): this;
}
//#endregion
//#region src/ts-dsl/stmt/if.d.ts
type IfCondition = string | MaybeTsDsl<ts.Expression>;
declare const Mixed$39: MixinCtor<abstract new () => TsDsl<ts.IfStatement>, DoMethods>;
declare class IfTsDsl extends Mixed$39 {
  readonly '~dsl' = "IfTsDsl";
  protected _condition?: IfCondition;
  protected _else?: Array<DoExpr>;
  constructor(condition?: IfCondition);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  condition(condition: IfCondition): this;
  otherwise(...items: Array<DoExpr>): this;
  toAst(): ts.IfStatement;
  $validate(): asserts this is this & {
    _condition: IfCondition;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/utils/lazy.d.ts
type LazyThunk<T extends ts.Node> = (ctx: TsDslContext) => TsDsl<T>;
declare class LazyTsDsl<T extends ts.Node = ts.Node> extends TsDsl<T> {
  readonly '~dsl' = "LazyTsDsl";
  private _thunk;
  constructor(thunk: LazyThunk<T>);
  analyze(ctx: AnalysisContext): void;
  toResult(): TsDsl<T>;
  toAst(): T;
}
//#endregion
//#region src/ts-dsl/expr/literal.d.ts
type LiteralValue = string | number | boolean | bigint | null;
declare const Mixed$38: MixinCtor<abstract new () => TsDsl<ts.BigIntLiteral | ts.BooleanLiteral | ts.NullLiteral | ts.NumericLiteral | ts.PrefixUnaryExpression | ts.StringLiteral>, AsMethods>;
declare class LiteralTsDsl extends Mixed$38 {
  readonly '~dsl' = "LiteralTsDsl";
  protected value: LiteralValue;
  constructor(value: LiteralValue);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.BigIntLiteral | ts.TrueLiteral | ts.FalseLiteral | ts.NullLiteral | ts.NumericLiteral | ts.PrefixUnaryExpression | ts.StringLiteral;
}
//#endregion
//#region src/ts-dsl/layout/note.d.ts
type NoteMaybeLazy<T> = ((ctx: TsDslContext) => T) | T;
type NoteFn = (d: NoteTsDsl) => void;
type NoteLines = NoteMaybeLazy<MaybeArray<string>>;
declare class NoteTsDsl extends TsDsl<ts.Node> {
  readonly '~dsl' = "NoteTsDsl";
  protected _lines: Array<NoteLines>;
  constructor(lines?: NoteLines, fn?: NoteFn);
  analyze(ctx: AnalysisContext): void;
  add(lines: NoteLines): this;
  apply<T extends ts.Node>(node: T): T;
  toAst(): ts.Node;
}
//#endregion
//#region src/ts-dsl/expr/template.d.ts
type TemplatePart = NodeName | MaybeTsDsl<ts.Expression>;
declare const Mixed$37: abstract new () => TsDsl<ts.TemplateExpression | ts.NoSubstitutionTemplateLiteral>;
declare class TemplateTsDsl extends Mixed$37 {
  readonly '~dsl' = "TemplateTsDsl";
  protected parts: Array<Ref<TemplatePart>>;
  constructor(value?: TemplatePart);
  analyze(ctx: AnalysisContext): void;
  add(value: TemplatePart): this;
  toAst(): ts.TemplateExpression | ts.NoSubstitutionTemplateLiteral;
}
//#endregion
//#region src/ts-dsl/type/param.d.ts
type TypeParamExpr = NodeName | boolean | MaybeTsDsl<TypeTsDsl>;
declare const Mixed$36: abstract new () => TsDsl<ts.TypeParameterDeclaration>;
declare class TypeParamTsDsl extends Mixed$36 {
  readonly '~dsl' = "TypeParamTsDsl";
  scope: NodeScope;
  protected constraint?: Ref<TypeParamExpr>;
  protected defaultValue?: Ref<TypeParamExpr>;
  constructor(name?: NodeName, fn?: (name: TypeParamTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  default(value: TypeParamExpr): this;
  extends(constraint: TypeParamExpr): this;
  toAst(): ts.TypeParameterDeclaration;
}
//#endregion
//#region src/ts-dsl/mixins/type-params.d.ts
interface TypeParamsMethods extends Node {
  /** Returns the type parameters as an array of ts.TypeParameterDeclaration nodes. */
  $generics(): ReadonlyArray<ts.TypeParameterDeclaration> | undefined;
  /** Adds a single type parameter (e.g. `T` in `Array<T>`). */
  generic(...args: ConstructorParameters<typeof TypeParamTsDsl>): this;
  /** Adds type parameters (e.g. `Map<string, T>`). */
  generics(...args: ReadonlyArray<NodeName | MaybeTsDsl<TypeParamTsDsl>>): this;
}
//#endregion
//#region src/ts-dsl/mixins/modifiers.d.ts
type Modifiers = {
  /**
   * Checks if the specified modifier is present.
   *
   * @param modifier - The modifier to check.
   * @returns True if the modifier is present, false otherwise.
   */
  hasModifier(modifier: Modifier): boolean;
  modifiers: Array<ts.Modifier>;
};
type Modifier = 'abstract' | 'async' | 'const' | 'declare' | 'default' | 'export' | 'override' | 'private' | 'protected' | 'public' | 'readonly' | 'static';
interface AbstractMethods extends Modifiers {
  /**
   * Adds the `abstract` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  abstract(condition?: boolean): this;
}
interface AsyncMethods extends Modifiers {
  /**
   * Adds the `async` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  async(condition?: boolean): this;
}
interface ConstMethods extends Modifiers {
  /**
   * Adds the `const` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  const(condition?: boolean): this;
}
interface DefaultMethods extends Modifiers {
  /**
   * Adds the `default` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  default(condition?: boolean): this;
}
interface ExportMethods extends Modifiers {
  /**
   * Adds the `export` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  export(condition?: boolean): this;
}
interface PrivateMethods extends Modifiers {
  /**
   * Adds the `private` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  private(condition?: boolean): this;
}
interface ProtectedMethods extends Modifiers {
  /**
   * Adds the `protected` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  protected(condition?: boolean): this;
}
interface PublicMethods extends Modifiers {
  /**
   * Adds the `public` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  public(condition?: boolean): this;
}
interface ReadonlyMethods extends Modifiers {
  /**
   * Adds the `readonly` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  readonly(condition?: boolean): this;
}
interface StaticMethods extends Modifiers {
  /**
   * Adds the `static` keyword modifier if the condition is true.
   *
   * @param condition - Whether to add the modifier (default: true).
   * @returns The target object for chaining.
   */
  static(condition?: boolean): this;
}
//#endregion
//#region src/ts-dsl/mixins/doc.d.ts
interface DocMethods extends Node {
  $docs<T extends ts.Node>(node: T): T;
  doc(lines?: DocLines, fn?: DocFn): this;
}
//#endregion
//#region src/ts-dsl/mixins/decorator.d.ts
interface DecoratorMethods extends Node {
  /** Renders the decorators into an array of `ts.Decorator`s. */
  $decorators(): ReadonlyArray<ts.Decorator>;
  /** Adds a decorator (e.g. `@sealed({ in: 'root' })`). */
  decorator(name: NodeName | MaybeTsDsl<ts.Expression>, ...args: ReadonlyArray<string | MaybeTsDsl<ts.Expression>>): this;
}
//#endregion
//#region src/ts-dsl/mixins/value.d.ts
type ValueExpr = string | MaybeTsDsl<ts.Expression>;
interface ValueMethods extends Node {
  $value(): ts.Expression | undefined;
  /** Sets the initializer expression (e.g. `= expr`). */
  assign(expr: ValueExpr): this;
}
//#endregion
//#region src/ts-dsl/decl/field.d.ts
type FieldType = NodeName | TypeTsDsl;
declare const Mixed$35: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.PropertyDeclaration>, ValueMethods>, StaticMethods>, ReadonlyMethods>, PublicMethods>, ProtectedMethods>, PrivateMethods>, OptionalMethods>, DocMethods>, DecoratorMethods>;
declare class FieldTsDsl extends Mixed$35 {
  readonly '~dsl' = "FieldTsDsl";
  readonly nameSanitizer: (name: string) => string;
  protected _type?: TypeTsDsl;
  constructor(name: NodeName, fn?: (f: FieldTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  /** Sets the field type. */
  type(type: FieldType): this;
  toAst(): ts.PropertyDeclaration;
}
//#endregion
//#region src/ts-dsl/mixins/pattern.d.ts
interface PatternMethods extends Node {
  /** Renders the pattern into a `BindingName`. */
  $pattern(): ts.BindingName | undefined;
  /** Defines an array binding pattern. */
  array(...props: ReadonlyArray<string> | [ReadonlyArray<string>]): this;
  /** Defines an object binding pattern. */
  object(...props: ReadonlyArray<MaybeArray<string> | Record<string, string>>): this;
  /** Adds a spread element (e.g. `...args`, `...options`) to the pattern. */
  spread(name: string): this;
}
//#endregion
//#region src/ts-dsl/decl/param.d.ts
type ParamCtor = (name: NodeName | ((p: ParamTsDsl) => void), fn?: (p: ParamTsDsl) => void) => ParamTsDsl;
declare const Mixed$34: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ParameterDeclaration>, ValueMethods>, PatternMethods>, OptionalMethods>, DecoratorMethods>;
declare class ParamTsDsl extends Mixed$34 {
  readonly '~dsl' = "ParamTsDsl";
  protected _type?: TypeTsDsl;
  constructor(name: NodeName | ((p: ParamTsDsl) => void), fn?: (p: ParamTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the parameter type. */
  type(type: string | TypeTsDsl): this;
  toAst(): ts.ParameterDeclaration;
  $validate(): asserts this;
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/mixins/param.d.ts
interface ParamMethods extends Node {
  /** Renders the parameters into an array of `ParameterDeclaration`s. */
  $params(): ReadonlyArray<ts.ParameterDeclaration>;
  /** Adds a parameter. */
  param(...args: Parameters<ParamCtor>): this;
  /** Adds multiple parameters. */
  params(...params: ReadonlyArray<MaybeTsDsl<ts.ParameterDeclaration>>): this;
}
//#endregion
//#region src/ts-dsl/decl/init.d.ts
declare const Mixed$33: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ConstructorDeclaration>, PublicMethods>, ProtectedMethods>, PrivateMethods>, ParamMethods>, DocMethods>, DoMethods>, DecoratorMethods>;
declare class InitTsDsl extends Mixed$33 {
  readonly '~dsl' = "InitTsDsl";
  constructor(fn?: (i: InitTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.ConstructorDeclaration;
}
//#endregion
//#region src/ts-dsl/mixins/type-returns.d.ts
interface TypeReturnsMethods extends Node {
  /** Returns the return type node. */
  $returns(): ts.TypeNode | undefined;
  /** Sets the return type. */
  returns(type: NodeName | TypeTsDsl): this;
}
//#endregion
//#region src/ts-dsl/decl/method.d.ts
declare const Mixed$32: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.MethodDeclaration>, TypeReturnsMethods>, TypeParamsMethods>, StaticMethods>, PublicMethods>, ProtectedMethods>, PrivateMethods>, ParamMethods>, OptionalMethods>, DocMethods>, DoMethods>, DecoratorMethods>, AsyncMethods>, AbstractMethods>;
declare class MethodTsDsl extends Mixed$32 {
  readonly '~dsl' = "MethodTsDsl";
  readonly nameSanitizer: (name: string) => string;
  constructor(name: NodeName, fn?: (m: MethodTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.MethodDeclaration;
}
//#endregion
//#region src/ts-dsl/decl/class.d.ts
type Body = Array<MaybeTsDsl<ts.ClassElement | ts.Node>>;
declare const Mixed$31: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ClassDeclaration>, TypeParamsMethods>, ExportMethods>, DocMethods>, DefaultMethods>, DecoratorMethods>, AbstractMethods>;
declare class ClassTsDsl extends Mixed$31 {
  readonly '~dsl' = "ClassTsDsl";
  readonly nameSanitizer: (name: string) => string;
  protected baseClass?: Ref<NodeName>;
  protected body: Body;
  constructor(name: NodeName);
  analyze(ctx: AnalysisContext): void;
  /** Returns true if the class has any members. */
  get hasBody(): boolean;
  /** Adds one or more class members (fields, methods, etc.). */
  do(...items: Body): this;
  /** Records a base class to extend from. */
  extends(base?: NodeName): this;
  /** Adds a class field. */
  field(name: NodeName, fn?: (f: FieldTsDsl) => void): this;
  /** Adds a class constructor. */
  init(fn?: InitTsDsl | ((i: InitTsDsl) => void)): this;
  /** Adds a class method. */
  method(name: NodeName, fn?: (m: MethodTsDsl) => void): this;
  /** Inserts an empty line between members for formatting. */
  newline(): this;
  toAst(): ts.ClassDeclaration;
  /** Builds heritage clauses (extends). */
  private _heritage;
}
//#endregion
//#region src/ts-dsl/decl/decorator.d.ts
declare const Mixed$30: MixinCtor<abstract new () => TsDsl<ts.Decorator>, ArgsMethods>;
declare class DecoratorTsDsl extends Mixed$30 {
  readonly '~dsl' = "DecoratorTsDsl";
  readonly nameSanitizer: (name: string) => string;
  constructor(name: NodeName, ...args: ReadonlyArray<string | MaybeTsDsl<ts.Expression>>);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Decorator;
}
//#endregion
//#region src/ts-dsl/decl/member.d.ts
type Value$2 = string | number | MaybeTsDsl<ts.Expression>;
type ValueFn$1 = Value$2 | ((m: EnumMemberTsDsl) => void);
declare const Mixed$29: MixinCtor<abstract new () => TsDsl<ts.EnumMember>, DocMethods>;
declare class EnumMemberTsDsl extends Mixed$29 {
  readonly '~dsl' = "EnumMemberTsDsl";
  private _value?;
  constructor(name: NodeName, value?: ValueFn$1);
  analyze(ctx: AnalysisContext): void;
  /** Sets the enum member value. */
  value(value?: Value$2): this;
  toAst(): ts.EnumMember;
}
//#endregion
//#region src/ts-dsl/decl/enum.d.ts
type Value$1 = string | number | MaybeTsDsl<ts.Expression>;
type ValueFn = Value$1 | ((m: EnumMemberTsDsl) => void);
declare const Mixed$28: MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.EnumDeclaration>, ExportMethods>, DocMethods>, ConstMethods>;
declare class EnumTsDsl extends Mixed$28 {
  readonly '~dsl' = "EnumTsDsl";
  readonly nameSanitizer: (name: string) => string;
  private _members;
  constructor(name: NodeName, fn?: (e: EnumTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  /** Adds an enum member. */
  member(name: string, value?: ValueFn): this;
  /** Adds multiple enum members. */
  members(...members: ReadonlyArray<EnumMemberTsDsl>): this;
  toAst(): ts.EnumDeclaration;
}
//#endregion
//#region src/ts-dsl/decl/func.d.ts
type FuncMode = 'arrow' | 'decl' | 'expr';
declare const Mixed$27: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ArrowFunction>, TypeReturnsMethods>, TypeParamsMethods>, StaticMethods>, PublicMethods>, ProtectedMethods>, PrivateMethods>, ParamMethods>, DocMethods>, DoMethods>, DecoratorMethods>, AsyncMethods>, AsMethods>, AbstractMethods>;
declare class ImplFuncTsDsl<M extends FuncMode = 'arrow'> extends Mixed$27 {
  readonly '~dsl' = "FuncTsDsl";
  readonly nameSanitizer: (name: string) => string;
  protected mode?: FuncMode;
  constructor();
  constructor(fn: (f: ImplFuncTsDsl<'arrow'>) => void);
  constructor(name: NodeName);
  constructor(name: NodeName, fn: (f: ImplFuncTsDsl<'decl'>) => void);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Switches the function to an arrow function form. */
  arrow(): FuncTsDsl<'arrow'>;
  /** Switches the function to a function declaration form. */
  decl(): FuncTsDsl<'decl'>;
  /** Switches the function to a function expression form. */
  expr(): FuncTsDsl<'expr'>;
  toAst(): M extends 'decl' ? ts.FunctionDeclaration : M extends 'expr' ? ts.FunctionExpression : ts.ArrowFunction;
  $validate(): asserts this;
  private missingRequiredCalls;
}
declare const FuncTsDsl: {
  new (): FuncTsDsl<"arrow">;
  new (fn: (f: FuncTsDsl<"arrow">) => void): FuncTsDsl<"arrow">;
  new (name: NodeName): FuncTsDsl<"decl">;
  new (name: NodeName, fn: (f: FuncTsDsl<"decl">) => void): FuncTsDsl<"decl">;
} & typeof ImplFuncTsDsl;
type FuncTsDsl<M extends FuncMode = 'arrow'> = ImplFuncTsDsl<M>;
//#endregion
//#region src/ts-dsl/decl/getter.d.ts
declare const Mixed$26: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.GetAccessorDeclaration>, TypeReturnsMethods>, StaticMethods>, PublicMethods>, ProtectedMethods>, PrivateMethods>, ParamMethods>, DocMethods>, DoMethods>, DecoratorMethods>, AsyncMethods>, AbstractMethods>;
declare class GetterTsDsl extends Mixed$26 {
  readonly '~dsl' = "GetterTsDsl";
  readonly nameSanitizer: (name: string) => string;
  constructor(name: NodeName, fn?: (g: GetterTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.GetAccessorDeclaration;
}
//#endregion
//#region src/ts-dsl/decl/pattern.d.ts
declare const Mixed$25: abstract new () => TsDsl<ts.BindingName>;
/**
 * Builds binding patterns (e.g. `{ foo, bar }`, `[a, b, ...rest]`).
 */
declare class PatternTsDsl extends Mixed$25 {
  readonly '~dsl' = "PatternTsDsl";
  protected pattern?: {
    kind: 'array';
    values: ReadonlyArray<string>;
  } | {
    kind: 'object';
    values: Record<string, string>;
  };
  protected _spread?: string;
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Defines an array pattern (e.g. `[a, b, c]`). */
  array(...props: ReadonlyArray<string> | [ReadonlyArray<string>]): this;
  /** Defines an object pattern (e.g. `{ a, b: alias }`). */
  object(...props: ReadonlyArray<MaybeArray<string> | Record<string, string>>): this;
  /** Adds a spread element (e.g. `...rest`, `...options`, `...args`). */
  spread(name: string): this;
  toAst(): ts.ObjectBindingPattern | ts.ArrayBindingPattern;
  $validate(): asserts this is this & {
    pattern: {
      kind: 'array';
      values: ReadonlyArray<string>;
    } | {
      kind: 'object';
      values: Record<string, string>;
    };
  };
  private missingRequiredCalls;
  private createSpread;
}
//#endregion
//#region src/ts-dsl/decl/setter.d.ts
declare const Mixed$24: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.SetAccessorDeclaration>, StaticMethods>, PublicMethods>, ProtectedMethods>, PrivateMethods>, ParamMethods>, DocMethods>, DoMethods>, DecoratorMethods>, AsyncMethods>, AbstractMethods>;
declare class SetterTsDsl extends Mixed$24 {
  readonly '~dsl' = "SetterTsDsl";
  readonly nameSanitizer: (name: string) => string;
  constructor(name: NodeName, fn?: (s: SetterTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.SetAccessorDeclaration;
}
//#endregion
//#region src/ts-dsl/mixins/layout.d.ts
interface LayoutMethods extends Node {
  /** Computes whether output should be multiline based on layout setting and element count. */
  $multiline(count: number): boolean;
  /** Sets automatic line output with optional threshold (default: 3). */
  auto(threshold?: number): this;
  /** Sets single line output. */
  inline(): this;
  /** Sets multi line output. */
  pretty(): this;
}
//#endregion
//#region src/ts-dsl/expr/array.d.ts
declare const Mixed$23: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ArrayLiteralExpression>, LayoutMethods>, AsMethods>;
declare class ArrayTsDsl extends Mixed$23 {
  readonly '~dsl' = "ArrayTsDsl";
  protected _elements: Array<{
    expr: MaybeTsDsl<ts.Expression>;
    kind: 'element';
  } | {
    expr: MaybeTsDsl<ts.Expression>;
    kind: 'spread';
  }>;
  constructor(...exprs: Array<string | number | boolean | MaybeTsDsl<ts.Expression>>);
  analyze(ctx: AnalysisContext): void;
  /** Adds a single array element. */
  element(expr: string | number | boolean | MaybeTsDsl<ts.Expression>): this;
  /** Adds multiple array elements. */
  elements(...exprs: ReadonlyArray<string | number | boolean | MaybeTsDsl<ts.Expression>>): this;
  /** Adds a spread element (`...expr`). */
  spread(expr: MaybeTsDsl<ts.Expression>): this;
  toAst(): ts.ArrayLiteralExpression;
}
//#endregion
//#region src/ts-dsl/expr/expr.d.ts
type Id = NodeName | MaybeTsDsl<ts.Expression>;
declare const Mixed$22: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.Expression>, TypeExprMethods>, OperatorMethods>, ExprMethods>, AsMethods>;
declare class ExprTsDsl extends Mixed$22 {
  readonly '~dsl' = "ExprTsDsl";
  protected _exprInput: Ref<Id>;
  constructor(id: Id);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Expression;
}
//#endregion
//#region src/ts-dsl/expr/id.d.ts
declare const Mixed$21: abstract new () => TsDsl<ts.Identifier>;
declare class IdTsDsl extends Mixed$21 {
  readonly '~dsl' = "IdTsDsl";
  constructor(name: string);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Identifier;
}
//#endregion
//#region src/ts-dsl/mixins/hint.d.ts
interface HintMethods extends Node {
  $hint<T extends ts.Node>(node: T): T;
  hint(lines?: HintLines, fn?: HintFn): this;
}
//#endregion
//#region src/ts-dsl/expr/prop.d.ts
type Expr$1 = NodeName | MaybeTsDsl<ts.Expression>;
type Stmt$1 = NodeName | MaybeTsDsl<ts.Statement>;
type ObjectPropKind = 'computed' | 'getter' | 'prop' | 'setter' | 'spread';
type Meta = {
  kind: 'computed';
  name: string;
} | {
  kind: 'getter';
  name: string;
} | {
  kind: 'prop';
  name: string;
} | {
  kind: 'setter';
  name: string;
} | {
  kind: 'spread';
  name?: undefined;
};
declare const Mixed$20: MixinCtor<abstract new () => TsDsl<ts.ObjectLiteralElementLike>, DocMethods>;
declare class ObjectPropTsDsl extends Mixed$20 {
  readonly '~dsl' = "ObjectPropTsDsl";
  protected _value?: Ref<Expr$1 | Stmt$1>;
  protected _meta: Meta;
  constructor(meta: Meta);
  get kind(): ObjectPropKind;
  get propName(): string | undefined;
  analyze(ctx: AnalysisContext): void;
  get isValid(): boolean;
  value(value: Expr$1 | Stmt$1 | ((p: ObjectPropTsDsl) => void)): this;
  toAst(): ts.GetAccessorDeclaration | ts.SetAccessorDeclaration | ts.PropertyAssignment | ts.ShorthandPropertyAssignment | ts.SpreadAssignment;
  $validate(): asserts this is this & {
    _value: Expr$1 | Stmt$1;
    kind: ObjectPropKind;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/expr/object.d.ts
type Expr = NodeName | MaybeTsDsl<ts.Expression>;
type Stmt = NodeName | MaybeTsDsl<ts.Statement>;
type ExprFn = Expr | ((p: ObjectPropTsDsl) => void);
type StmtFn = Stmt | ((p: ObjectPropTsDsl) => void);
declare const Mixed$19: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.ObjectLiteralExpression>, LayoutMethods>, HintMethods>, ExprMethods>, AsMethods>;
declare class ObjectTsDsl extends Mixed$19 {
  readonly '~dsl' = "ObjectTsDsl";
  protected _props: Map<string, ObjectPropTsDsl>;
  protected _spreadCounter: number;
  constructor(...props: Array<ObjectPropTsDsl>);
  analyze(ctx: AnalysisContext): void;
  /** Returns composite key for the property. */
  private _propKey;
  /** Adds a computed property (e.g. `{ [expr]: value }`), or removes if null. */
  computed(name: string, expr: ExprFn | null): this;
  /** Adds a getter property (e.g. `{ get foo() { ... } }`), or removes if null. */
  getter(name: string, stmt: StmtFn | null): this;
  /** Returns true if object has at least one property or spread. */
  hasProps(): boolean;
  /** Returns true if object has no properties or spreads. */
  get isEmpty(): boolean;
  /** Adds a property assignment, or removes if null. */
  prop(name: string, expr: ExprFn | null): this;
  /** Adds multiple properties. */
  props(...props: ReadonlyArray<ObjectPropTsDsl>): this;
  /** Adds a setter property (e.g. `{ set foo(v) { ... } }`), or removes if null. */
  setter(name: string, stmt: StmtFn | null): this;
  /** Adds a spread property (e.g. `{ ...options }`). */
  spread(expr: ExprFn): this;
  toAst(): ts.ObjectLiteralExpression;
}
//#endregion
//#region src/ts-dsl/expr/prefix.d.ts
declare const Mixed$18: abstract new () => TsDsl<ts.PrefixUnaryExpression>;
declare class PrefixTsDsl extends Mixed$18 {
  readonly '~dsl' = "PrefixTsDsl";
  protected _expr?: string | MaybeTsDsl<ts.Expression>;
  protected _op?: ts.PrefixUnaryOperator;
  constructor(expr?: string | MaybeTsDsl<ts.Expression>, op?: ts.PrefixUnaryOperator);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the operand (the expression being prefixed). */
  expr(expr: string | MaybeTsDsl<ts.Expression>): this;
  /** Sets the operator to MinusToken for negation (`-`). */
  neg(): this;
  /** Sets the operator to ExclamationToken for logical NOT (`!`). */
  not(): this;
  /** Sets the operator (e.g. `ts.SyntaxKind.ExclamationToken` for `!`). */
  op(op: ts.PrefixUnaryOperator): this;
  toAst(): ts.PrefixUnaryExpression;
  $validate(): asserts this is this & {
    _expr: string | MaybeTsDsl<ts.Expression>;
    _op: ts.PrefixUnaryOperator;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/expr/regexp.d.ts
type RegexFlag = 'g' | 'i' | 'm' | 's' | 'u' | 'y';
type RegexFlags<Avail extends string = RegexFlag> = '' | { [K in Avail]: `${K}${RegexFlags<Exclude<Avail, K>>}` }[Avail];
declare const Mixed$17: abstract new () => TsDsl<ts.RegularExpressionLiteral>;
declare class RegExpTsDsl extends Mixed$17 {
  readonly '~dsl' = "RegExpTsDsl";
  protected pattern: string;
  protected flags?: RegexFlags;
  constructor(pattern: string, flags?: RegexFlags);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.RegularExpressionLiteral;
}
//#endregion
//#region src/ts-dsl/expr/ternary.d.ts
declare const Mixed$16: abstract new () => TsDsl<ts.ConditionalExpression>;
declare class TernaryTsDsl extends Mixed$16 {
  readonly '~dsl' = "TernaryTsDsl";
  protected _condition?: string | MaybeTsDsl<ts.Expression>;
  protected _then?: string | MaybeTsDsl<ts.Expression>;
  protected _else?: string | MaybeTsDsl<ts.Expression>;
  constructor(condition?: string | MaybeTsDsl<ts.Expression>);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  condition(condition: string | MaybeTsDsl<ts.Expression>): this;
  do(expr: string | MaybeTsDsl<ts.Expression>): this;
  otherwise(expr: string | MaybeTsDsl<ts.Expression>): this;
  toAst(): ts.ConditionalExpression;
  $validate(): asserts this is this & {
    _condition: string | MaybeTsDsl<ts.Expression>;
    _else: string | MaybeTsDsl<ts.Expression>;
    _then: string | MaybeTsDsl<ts.Expression>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/layout/newline.d.ts
declare class NewlineTsDsl extends TsDsl<ts.Identifier> {
  readonly '~dsl' = "NewlineTsDsl";
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Identifier;
}
//#endregion
//#region src/ts-dsl/stmt/block.d.ts
declare const Mixed$15: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.Block>, LayoutMethods>, DoMethods>;
declare class BlockTsDsl extends Mixed$15 {
  readonly '~dsl' = "BlockTsDsl";
  constructor(...items: Array<DoExpr>);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Block;
}
//#endregion
//#region src/ts-dsl/stmt/stmt.d.ts
declare const Mixed$14: abstract new () => TsDsl<ts.Statement>;
declare class StmtTsDsl extends Mixed$14 {
  readonly '~dsl' = "StmtTsDsl";
  protected _inner: ts.Expression | ts.Statement | TsDsl<any>;
  constructor(inner: ts.Expression | ts.Statement | TsDsl<any>);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.Statement;
}
//#endregion
//#region src/ts-dsl/stmt/throw.d.ts
declare const Mixed$13: abstract new () => TsDsl<ts.ThrowStatement>;
declare class ThrowTsDsl extends Mixed$13 {
  readonly '~dsl' = "ThrowTsDsl";
  protected error: string | MaybeTsDsl<ts.Expression>;
  protected msg?: string | MaybeTsDsl<ts.Expression>;
  protected useNew: boolean;
  constructor(error: string | MaybeTsDsl<ts.Expression>, useNew?: boolean);
  analyze(ctx: AnalysisContext): void;
  message(value: string | MaybeTsDsl<ts.Expression>): this;
  toAst(): ts.ThrowStatement;
}
//#endregion
//#region src/ts-dsl/stmt/try.d.ts
declare const Mixed$12: abstract new () => TsDsl<ts.TryStatement>;
declare class TryTsDsl extends Mixed$12 {
  readonly '~dsl' = "TryTsDsl";
  protected _catch?: Array<DoExpr>;
  protected _catchArg?: NodeName;
  protected _finally?: Array<DoExpr>;
  protected _try?: Array<DoExpr>;
  constructor(...tryBlock: Array<DoExpr>);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  catch(...items: Array<DoExpr>): this;
  catchArg(arg: NodeName): this;
  finally(...items: Array<DoExpr>): this;
  try(...items: Array<DoExpr>): this;
  toAst(): ts.TryStatement;
  $validate(): asserts this is this & {
    _try: Array<DoExpr>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/stmt/var.d.ts
declare const Mixed$11: MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.VariableStatement>, ValueMethods>, PatternMethods>, HintMethods>, ExportMethods>, DocMethods>, DefaultMethods>;
declare class VarTsDsl extends Mixed$11 {
  readonly '~dsl' = "VarTsDsl";
  readonly nameSanitizer: (name: string) => string;
  protected kind: ts.NodeFlags;
  protected _type?: TypeTsDsl;
  constructor(name?: NodeName);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  const(): this;
  let(): this;
  /** Sets the variable type. */
  type(type: string | TypeTsDsl): this;
  var(): this;
  toAst(): ts.VariableStatement;
  $validate(): asserts this;
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/token.d.ts
declare class TokenTsDsl<K$1 extends ts.SyntaxKind = never> extends TsDsl<ts.Token<K$1>> {
  readonly '~dsl' = "TokenTsDsl";
  protected _kind?: K$1;
  /** Sets the token kind */
  kind(kind: K$1): this;
  /** Creates `-` */
  minus(): TokenTsDsl<ts.SyntaxKind.MinusToken>;
  /** Creates `?` (optional) */
  optional(): TokenTsDsl<ts.SyntaxKind.QuestionToken>;
  /** Creates `+` */
  plus(): TokenTsDsl<ts.SyntaxKind.PlusToken>;
  /** Creates `?.` (optional chaining token) */
  questionDot(): TokenTsDsl<ts.SyntaxKind.QuestionDotToken>;
  /** Creates `readonly` */
  readonly(): TokenTsDsl<ts.SyntaxKind.ReadonlyKeyword>;
  /** Creates `...` (spread / rest) */
  spread(): TokenTsDsl<ts.SyntaxKind.DotDotDotToken>;
  toAst(): ts.Token<K$1>;
  $validate(): asserts this is this & {
    _kind: K$1;
  };
  private missingRequiredCalls;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
}
//#endregion
//#region src/ts-dsl/type/alias.d.ts
type Value = MaybeTsDsl<ts.TypeNode>;
declare const Mixed$10: MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.TypeAliasDeclaration>, TypeParamsMethods>, ExportMethods>, DocMethods>;
declare class TypeAliasTsDsl extends Mixed$10 {
  readonly '~dsl' = "TypeAliasTsDsl";
  readonly nameSanitizer: (name: string) => string;
  scope: NodeScope;
  protected value?: Value;
  constructor(name: NodeName, fn?: (t: TypeAliasTsDsl) => void);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the type expression on the right-hand side of `= ...`. */
  type(node: Value): this;
  toAst(): ts.TypeAliasDeclaration;
  $validate(): asserts this is this & {
    value: Value;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/and.d.ts
type Type$1 = NodeName | ts.TypeNode | TypeTsDsl;
declare const Mixed$9: abstract new () => TsDsl<ts.IntersectionTypeNode>;
declare class TypeAndTsDsl extends Mixed$9 {
  readonly '~dsl' = "TypeAndTsDsl";
  scope: NodeScope;
  protected _types: Array<Ref<Type$1>>;
  constructor(...nodes: Array<Type$1>);
  analyze(ctx: AnalysisContext): void;
  types(...nodes: Array<Type$1>): this;
  toAst(): ts.IntersectionTypeNode;
}
//#endregion
//#region src/ts-dsl/type/func.d.ts
declare const Mixed$8: MixinCtor<MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.FunctionTypeNode>, TypeReturnsMethods>, TypeParamsMethods>, ParamMethods>, DocMethods>;
declare class TypeFuncTsDsl extends Mixed$8 {
  readonly '~dsl' = "TypeFuncTsDsl";
  scope: NodeScope;
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  toAst(): ts.FunctionTypeNode;
  $validate(): asserts this;
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/literal.d.ts
declare const Mixed$7: abstract new () => TsDsl<ts.LiteralTypeNode>;
declare class TypeLiteralTsDsl extends Mixed$7 {
  readonly '~dsl' = "TypeLiteralTsDsl";
  scope: NodeScope;
  protected value: string | number | boolean | null;
  constructor(value: string | number | boolean | null);
  analyze(ctx: AnalysisContext): void;
  toAst(): ts.LiteralTypeNode;
}
//#endregion
//#region src/ts-dsl/type/mapped.d.ts
declare const Mixed$6: abstract new () => TsDsl<ts.MappedTypeNode>;
declare class TypeMappedTsDsl extends Mixed$6 {
  readonly '~dsl' = "TypeMappedTsDsl";
  scope: NodeScope;
  protected questionToken?: TokenTsDsl<ts.SyntaxKind.QuestionToken | ts.SyntaxKind.PlusToken | ts.SyntaxKind.MinusToken>;
  protected readonlyToken?: TokenTsDsl<ts.SyntaxKind.ReadonlyKeyword | ts.SyntaxKind.MinusToken | ts.SyntaxKind.PlusToken>;
  protected _key?: string | MaybeTsDsl<ts.TypeNode>;
  protected _type?: string | MaybeTsDsl<ts.TypeNode>;
  constructor(name?: NodeName);
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the key constraint: `[K in Constraint]` */
  key(type: string | MaybeTsDsl<ts.TypeNode>): this;
  /** Removes `readonly` from the mapped members (`[K in X]-readonly`). */
  mutable(): this;
  /** Makes `[K in X]?:` optional. */
  optional(): this;
  /** Makes `[K in X]` readonly */
  readonly(): this;
  /** Removes `?` from the mapped members (`[K in X]-?:`). */
  required(): this;
  /** Sets the mapped value type: `[K in X]: ValueType` */
  type(type: string | MaybeTsDsl<ts.TypeNode>): this;
  toAst(): ts.MappedTypeNode;
  $validate(): asserts this is this & {
    _key: string | MaybeTsDsl<ts.TypeNode>;
    _type: string | MaybeTsDsl<ts.TypeNode>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/idx-sig.d.ts
type TypeIdxSigType = string | MaybeTsDsl<ts.TypeNode>;
type TypeIdxSigKind = 'idxSig';
declare const Mixed$5: MixinCtor<MixinCtor<abstract new () => TsDsl<ts.IndexSignatureDeclaration>, ReadonlyMethods>, DocMethods>;
declare class TypeIdxSigTsDsl extends Mixed$5 {
  readonly '~dsl' = "TypeIdxSigTsDsl";
  scope: NodeScope;
  protected _key?: TypeIdxSigType;
  protected _type?: TypeIdxSigType;
  constructor(name: NodeName, fn?: (i: TypeIdxSigTsDsl) => void);
  /** Element kind. */
  get kind(): TypeIdxSigKind;
  /** Index signature parameter name. */
  get propName(): string;
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the key type: `[name: T]` */
  key(type: TypeIdxSigType): this;
  /** Sets the property type. */
  type(type: TypeIdxSigType): this;
  toAst(): ts.IndexSignatureDeclaration;
  $validate(): asserts this is this & {
    _key: TypeIdxSigType;
    _type: TypeIdxSigType;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/prop.d.ts
type TypePropType = NodeName | MaybeTsDsl<ts.TypeNode>;
type TypePropKind = 'prop';
declare const Mixed$4: MixinCtor<MixinCtor<MixinCtor<abstract new () => TsDsl<ts.TypeElement>, ReadonlyMethods>, OptionalMethods>, DocMethods>;
declare class TypePropTsDsl extends Mixed$4 {
  readonly '~dsl' = "TypePropTsDsl";
  scope: NodeScope;
  protected _type?: Ref<TypePropType>;
  constructor(name: NodeName, fn: (p: TypePropTsDsl) => void);
  /** Element kind. */
  get kind(): TypePropKind;
  /** Property name. */
  get propName(): string;
  analyze(ctx: AnalysisContext): void;
  /** Returns true when all required builder calls are present. */
  get isValid(): boolean;
  /** Sets the property type. */
  type(type: TypePropType): this;
  toAst(): ts.PropertySignature;
  $validate(): asserts this is this & {
    _type: Ref<TypePropType>;
  };
  private missingRequiredCalls;
}
//#endregion
//#region src/ts-dsl/type/object.d.ts
declare const Mixed$3: abstract new () => TsDsl<ts.TypeNode>;
declare class TypeObjectTsDsl extends Mixed$3 {
  readonly '~dsl' = "TypeObjectTsDsl";
  scope: NodeScope;
  protected _props: Map<string, TypePropTsDsl | TypeIdxSigTsDsl>;
  analyze(ctx: AnalysisContext): void;
  /** Returns true if object has at least one property or index signature. */
  hasProps(): boolean;
  /** Adds an index signature to the object type, or removes if fn is null. */
  idxSig(name: string, fn: ((i: TypeIdxSigTsDsl) => void) | null): this;
  /** Returns true if object has no properties or index signatures. */
  get isEmpty(): boolean;
  /** Adds a property signature, or removes if fn is null. */
  prop(name: string, fn: ((p: TypePropTsDsl) => void) | null): this;
  /** Adds multiple properties/index signatures. */
  props(...members: ReadonlyArray<TypePropTsDsl | TypeIdxSigTsDsl>): this;
  toAst(): ts.TypeLiteralNode;
}
//#endregion
//#region src/ts-dsl/type/or.d.ts
type Type = NodeName | ts.TypeNode | TypeTsDsl;
declare const Mixed$2: abstract new () => TsDsl<ts.UnionTypeNode>;
declare class TypeOrTsDsl extends Mixed$2 {
  readonly '~dsl' = "TypeOrTsDsl";
  scope: NodeScope;
  protected _types: Array<Ref<Type>>;
  constructor(...nodes: Array<Type>);
  analyze(ctx: AnalysisContext): void;
  types(...nodes: Array<Type>): this;
  toAst(): ts.UnionTypeNode;
}
//#endregion
//#region src/ts-dsl/type/template.d.ts
declare const Mixed$1: abstract new () => TsDsl<ts.TemplateLiteralTypeNode>;
declare class TypeTemplateTsDsl extends Mixed$1 {
  readonly '~dsl' = "TypeTemplateTsDsl";
  scope: NodeScope;
  protected parts: Array<string | MaybeTsDsl<ts.TypeNode>>;
  constructor(value?: string | MaybeTsDsl<ts.TypeNode>);
  analyze(ctx: AnalysisContext): void;
  /** Adds a raw string segment or embedded type expression. */
  add(part: string | MaybeTsDsl<ts.TypeNode>): this;
  toAst(): ts.TemplateLiteralTypeNode;
}
//#endregion
//#region src/ts-dsl/type/tuple.d.ts
declare const Mixed: abstract new () => TsDsl<ts.TupleTypeNode>;
declare class TypeTupleTsDsl extends Mixed {
  readonly '~dsl' = "TypeTupleTsDsl";
  scope: NodeScope;
  protected _elements: Array<string | ts.TypeNode | TypeTsDsl>;
  constructor(...nodes: Array<string | ts.TypeNode | TypeTsDsl>);
  analyze(ctx: AnalysisContext): void;
  elements(...types: Array<string | ts.TypeNode | TypeTsDsl>): this;
  toAst(): ts.TupleTypeNode;
}
//#endregion
//#region src/ts-dsl/utils/keywords.d.ts
declare const keywords: {
  browserGlobals: string[];
  javaScriptGlobals: string[];
  javaScriptKeywords: string[];
  nodeGlobals: string[];
  typeScriptKeywords: string[];
};
//#endregion
//#region src/ts-dsl/utils/regexp.d.ts
declare const regexp: {
  /**
   * Matches characters from the start as long as they're not allowed.
   */
  illegalStartCharacters: RegExp;
  /**
   * Matches string if it contains only digits and optionally decimal point or
   * leading minus sign.
   */
  number: RegExp;
  /**
   * Javascript identifier regexp pattern retrieved from
   * {@link} https://developer.mozilla.org/docs/Web/JavaScript/Reference/Lexical_grammar#identifiers
   */
  typeScriptIdentifier: RegExp;
};
//#endregion
//#region src/ts-dsl/utils/render-utils.d.ts
type ModuleExport = Omit<ExportModule, 'from'> & {
  /** Module specifier for re-exports, e.g. `./foo`. */
  modulePath: string;
};
type ModuleImport = Omit<ImportModule, 'from'> & {
  /** Module specifier for imports, e.g. `./foo`. */
  modulePath: string;
};
//#endregion
//#region src/ts-dsl/utils/render.d.ts
type Exports = ReadonlyArray<ReadonlyArray<ModuleExport>>;
type ExportsOptions = {
  preferExportAll?: boolean;
};
type Header = MaybeArray<string> | null | undefined;
type Imports = ReadonlyArray<ReadonlyArray<ModuleImport>>;
declare class TypeScriptRenderer implements Renderer {
  /**
   * Function to generate a file header.
   *
   * @private
   */
  private _header?;
  /**
   * Whether `export * from 'module'` should be used when possible instead of named exports.
   *
   * @private
   */
  private _preferExportAll;
  /**
   * Controls whether imports/exports include a file extension (e.g., '.ts' or '.js').
   *
   * @private
   */
  private _preferFileExtension;
  /**
   * Optional function to transform module specifiers.
   *
   * @private
   */
  private _resolveModuleName?;
  constructor(args?: {
    header?: MaybeFunc<(ctx: RenderContext<TsDsl>) => Header>;
    preferExportAll?: boolean;
    preferFileExtension?: string;
    resolveModuleName?: (moduleName: string) => string | undefined;
  });
  render(ctx: RenderContext<TsDsl>): string;
  supports(ctx: RenderContext): boolean;
  static astToString(args: {
    exports?: Exports;
    exportsOptions?: ExportsOptions;
    header?: Header;
    imports?: Imports;
    nodes?: ReadonlyArray<TsDsl>;
    /**
     * Whether to include a trailing newline at the end of the file.
     *
     * @default true
     */
    trailingNewline?: boolean;
  }): string;
  static toExportAst(group: ModuleExport, options?: ExportsOptions): ts.ExportDeclaration;
  static toImportAst(group: ModuleImport): ts.ImportDeclaration;
  private getExports;
  private getImports;
}
//#endregion
//#region src/ts-dsl/utils/reserved.d.ts
type List = ReadonlyArray<string>;
declare class ReservedList {
  private _array;
  private _set;
  constructor(values: List);
  get '~values'(): Set<string>;
  /**
   * Updates the reserved list with new values.
   *
   * @param values New reserved values or a function that receives the previous
   * reserved values and returns the new ones.
   */
  set(values: List | ((prev: List) => List)): void;
}
/**
 * Reserved names for identifiers. These names will not be used
 * for variables, functions, classes, or other identifiers in generated code.
 */
declare const reserved: {
  /**
   * Reserved names for runtime identifiers. These names will not be used
   * for variables, functions, classes, or other runtime identifiers in
   * generated code.
   */
  runtime: ReservedList;
  /**
   * Reserved names for type identifiers. These names will not be used
   * for type or interface identifiers in generated code.
   */
  type: ReservedList;
};
//#endregion
//#region src/ts-dsl/index.d.ts
declare const $: ((id: ts.Expression | TsDsl<ts.Expression> | _hey_api_codegen_core0.NodeName) => ExprTsDsl) & {
  /** Creates an array literal expression (e.g. `[1, 2, 3]`). */
  array: (...args: ConstructorParameters<typeof ArrayTsDsl>) => ArrayTsDsl;
  /** Creates an `as` type assertion expression (e.g. `value as Type`). */
  as: (expr: AsExpr, type: AsType) => AsTsDsl;
  /** Creates a property access expression (e.g. `obj.foo`). */
  attr: (left: AttrLeft, right: _hey_api_codegen_core0.NodeName) => AttrTsDsl;
  /** Creates an await expression (e.g. `await promise`). */
  await: (expr: AwaitExpr) => AwaitTsDsl;
  /** Creates a binary expression (e.g. `a + b`). */
  binary: (base: ts.Expression | TsDsl<ts.Expression> | _hey_api_codegen_core0.NodeName, op?: (("!=" | "!==" | "&&" | "*" | "+" | "-" | "/" | "<" | "<=" | "=" | "==" | "===" | ">" | ">=" | "??" | "??=" | "||") | ts.BinaryOperator) | undefined, expr?: (ts.Expression | TsDsl<ts.Expression> | _hey_api_codegen_core0.NodeName) | undefined) => BinaryTsDsl;
  /** Creates a statement block (`{ ... }`). */
  block: (...args: ConstructorParameters<typeof BlockTsDsl>) => BlockTsDsl;
  /** Creates a function or method call expression (e.g. `fn(arg)`). */
  call: (callee: CallCallee, ...args: (CallCallee | undefined)[]) => CallTsDsl;
  /** Creates a class declaration or expression. */
  class: (name: _hey_api_codegen_core0.NodeName) => ClassTsDsl;
  /** Creates a constant variable declaration (`const`). */
  const: (name?: _hey_api_codegen_core0.NodeName | undefined) => VarTsDsl;
  /** Creates a decorator expression (e.g. `@decorator`). */
  decorator: (name: _hey_api_codegen_core0.NodeName, ...args: (string | ts.Expression | TsDsl<ts.Expression>)[]) => DecoratorTsDsl;
  /** Creates a JSDoc documentation block. */
  doc: (lines?: DocLines | undefined, fn?: DocFn | undefined) => DocTsDsl;
  /** Creates an enum declaration. */
  enum: (name: _hey_api_codegen_core0.NodeName, fn?: ((e: EnumTsDsl) => void) | undefined) => EnumTsDsl;
  /** Creates a general expression node. */
  expr: (id: ts.Expression | TsDsl<ts.Expression> | _hey_api_codegen_core0.NodeName) => ExprTsDsl;
  /** Creates a field declaration in a class or object. */
  field: (name: _hey_api_codegen_core0.NodeName, fn?: ((f: FieldTsDsl) => void) | undefined) => FieldTsDsl;
  /** Converts a runtime value into a corresponding expression node. */
  fromValue: (input: unknown, options?: {
    layout?: "pretty";
  } | undefined) => TsDsl<ts.Expression>;
  /** Creates a function expression or declaration. */
  func: {
    (): FuncTsDsl<"arrow">;
    (fn: (f: FuncTsDsl<"arrow">) => void): FuncTsDsl<"arrow">;
    (name: string): FuncTsDsl<"decl">;
    (name: string, fn: (f: FuncTsDsl<"decl">) => void): FuncTsDsl<"decl">;
    (name?: string, fn?: (f: FuncTsDsl<"decl">) => void): FuncTsDsl<"arrow"> | FuncTsDsl<"decl">;
  };
  /** Creates a getter method declaration. */
  getter: (name: _hey_api_codegen_core0.NodeName, fn?: ((g: GetterTsDsl) => void) | undefined) => GetterTsDsl;
  /** Creates a single-line comment (//). */
  hint: (lines?: HintLines | undefined, fn?: HintFn | undefined) => HintTsDsl;
  /** Creates an identifier (e.g. `foo`). */
  id: (name: string) => IdTsDsl;
  /** Creates an if statement. */
  if: (condition?: IfCondition | undefined) => IfTsDsl;
  /** Creates an initialization block or statement. */
  init: (fn?: ((i: InitTsDsl) => void) | undefined) => InitTsDsl;
  /** Creates a lazy, context-aware node with deferred evaluation. */
  lazy: <T extends ts.Node>(thunk: LazyThunk<T>) => LazyTsDsl<T>;
  /** Creates a let variable declaration (`let`). */
  let: (name?: _hey_api_codegen_core0.NodeName | undefined) => VarTsDsl;
  /** Creates a literal value (e.g. string, number, boolean). */
  literal: (value: LiteralValue) => LiteralTsDsl;
  /** Creates an enum member declaration. */
  member: (name: _hey_api_codegen_core0.NodeName, value?: ((string | number | ts.Expression | TsDsl<ts.Expression>) | ((m: EnumMemberTsDsl) => void)) | undefined) => EnumMemberTsDsl;
  /** Creates a method declaration inside a class or object. */
  method: (name: _hey_api_codegen_core0.NodeName, fn?: ((m: MethodTsDsl) => void) | undefined) => MethodTsDsl;
  /** Creates a negation expression (`-x`). */
  neg: (expr?: string | ts.Expression | TsDsl<ts.Expression> | undefined, op?: ts.PrefixUnaryOperator | undefined) => PrefixTsDsl;
  /** Creates a new expression (e.g. `new ClassName()`). */
  new: (expr: NewExpr, ...args: (NewExpr | undefined)[]) => NewTsDsl;
  /** Creates a newline (for formatting purposes). */
  newline: () => NewlineTsDsl;
  /** Creates a logical NOT expression (`!x`). */
  not: (expr?: string | ts.Expression | TsDsl<ts.Expression> | undefined, op?: ts.PrefixUnaryOperator | undefined) => PrefixTsDsl;
  /** Creates a block comment (/* ... *\/). */
  note: (lines?: NoteLines | undefined, fn?: NoteFn | undefined) => NoteTsDsl;
  /** Creates an object literal expression. */
  object: (...args: ConstructorParameters<typeof ObjectTsDsl>) => ObjectTsDsl;
  /** Creates a parameter declaration for functions or methods. */
  param: (name: _hey_api_codegen_core0.NodeName | ((p: ParamTsDsl) => void), fn?: ((p: ParamTsDsl) => void) | undefined) => ParamTsDsl;
  /** Creates a pattern for destructuring or matching. */
  pattern: () => PatternTsDsl;
  /** Creates a prefix unary expression (e.g. `-x`, `!x`, `~x`). */
  prefix: (expr?: string | ts.Expression | TsDsl<ts.Expression> | undefined, op?: ts.PrefixUnaryOperator | undefined) => PrefixTsDsl;
  /** Creates an object literal property (e.g. `{ foo: bar }`). */
  prop: (meta: {
    kind: "computed";
    name: string;
  } | {
    kind: "getter";
    name: string;
  } | {
    kind: "prop";
    name: string;
  } | {
    kind: "setter";
    name: string;
  } | {
    kind: "spread";
    name?: undefined;
  }) => ObjectPropTsDsl;
  /** Creates a regular expression literal (e.g. `/foo/gi`). */
  regexp: (pattern: string, flags?: ("" | "g" | "i" | "m" | "s" | "u" | "y" | "uy" | "yu" | "su" | "sy" | "suy" | "syu" | "ys" | "us" | "usy" | "uys" | "ysu" | "yus" | "ms" | "mu" | "my" | "muy" | "myu" | "msu" | "msy" | "msuy" | "msyu" | "mys" | "mus" | "musy" | "muys" | "mysu" | "myus" | "ym" | "um" | "umy" | "uym" | "ymu" | "yum" | "sm" | "smu" | "smy" | "smuy" | "smyu" | "sym" | "sum" | "sumy" | "suym" | "symu" | "syum" | "yms" | "ysm" | "ums" | "umsy" | "umys" | "usm" | "usmy" | "usym" | "uyms" | "uysm" | "ymsu" | "ymus" | "ysmu" | "ysum" | "yums" | "yusm" | "im" | "is" | "iu" | "iy" | "iuy" | "iyu" | "isu" | "isy" | "isuy" | "isyu" | "iys" | "ius" | "iusy" | "iuys" | "iysu" | "iyus" | "ims" | "imu" | "imy" | "imuy" | "imyu" | "imsu" | "imsy" | "imsuy" | "imsyu" | "imys" | "imus" | "imusy" | "imuys" | "imysu" | "imyus" | "iym" | "ium" | "iumy" | "iuym" | "iymu" | "iyum" | "ism" | "ismu" | "ismy" | "ismuy" | "ismyu" | "isym" | "isum" | "isumy" | "isuym" | "isymu" | "isyum" | "iyms" | "iysm" | "iums" | "iumsy" | "iumys" | "iusm" | "iusmy" | "iusym" | "iuyms" | "iuysm" | "iymsu" | "iymus" | "iysmu" | "iysum" | "iyums" | "iyusm" | "yi" | "ui" | "uiy" | "uyi" | "yiu" | "yui" | "si" | "siu" | "siy" | "siuy" | "siyu" | "syi" | "sui" | "suiy" | "suyi" | "syiu" | "syui" | "yis" | "ysi" | "uis" | "uisy" | "uiys" | "usi" | "usiy" | "usyi" | "uyis" | "uysi" | "yisu" | "yius" | "ysiu" | "ysui" | "yuis" | "yusi" | "mi" | "mis" | "miu" | "miy" | "miuy" | "miyu" | "misu" | "misy" | "misuy" | "misyu" | "miys" | "mius" | "miusy" | "miuys" | "miysu" | "miyus" | "myi" | "mui" | "muiy" | "muyi" | "myiu" | "myui" | "msi" | "msiu" | "msiy" | "msiuy" | "msiyu" | "msyi" | "msui" | "msuiy" | "msuyi" | "msyiu" | "msyui" | "myis" | "mysi" | "muis" | "muisy" | "muiys" | "musi" | "musiy" | "musyi" | "muyis" | "muysi" | "myisu" | "myius" | "mysiu" | "mysui" | "myuis" | "myusi" | "yim" | "ymi" | "uim" | "uimy" | "uiym" | "umi" | "umiy" | "umyi" | "uyim" | "uymi" | "yimu" | "yium" | "ymiu" | "ymui" | "yuim" | "yumi" | "sim" | "simu" | "simy" | "simuy" | "simyu" | "siym" | "sium" | "siumy" | "siuym" | "siymu" | "siyum" | "smi" | "smiu" | "smiy" | "smiuy" | "smiyu" | "smyi" | "smui" | "smuiy" | "smuyi" | "smyiu" | "smyui" | "syim" | "symi" | "suim" | "suimy" | "suiym" | "sumi" | "sumiy" | "sumyi" | "suyim" | "suymi" | "syimu" | "syium" | "symiu" | "symui" | "syuim" | "syumi" | "yims" | "yism" | "ymis" | "ymsi" | "ysim" | "ysmi" | "uims" | "uimsy" | "uimys" | "uism" | "uismy" | "uisym" | "uiyms" | "uiysm" | "umis" | "umisy" | "umiys" | "umsi" | "umsiy" | "umsyi" | "umyis" | "umysi" | "usim" | "usimy" | "usiym" | "usmi" | "usmiy" | "usmyi" | "usyim" | "usymi" | "uyims" | "uyism" | "uymis" | "uymsi" | "uysim" | "uysmi" | "yimsu" | "yimus" | "yismu" | "yisum" | "yiums" | "yiusm" | "ymisu" | "ymius" | "ymsiu" | "ymsui" | "ymuis" | "ymusi" | "ysimu" | "ysium" | "ysmiu" | "ysmui" | "ysuim" | "ysumi" | "yuims" | "yuism" | "yumis" | "yumsi" | "yusim" | "yusmi" | "gi" | "gm" | "gs" | "gu" | "gy" | "guy" | "gyu" | "gsu" | "gsy" | "gsuy" | "gsyu" | "gys" | "gus" | "gusy" | "guys" | "gysu" | "gyus" | "gms" | "gmu" | "gmy" | "gmuy" | "gmyu" | "gmsu" | "gmsy" | "gmsuy" | "gmsyu" | "gmys" | "gmus" | "gmusy" | "gmuys" | "gmysu" | "gmyus" | "gym" | "gum" | "gumy" | "guym" | "gymu" | "gyum" | "gsm" | "gsmu" | "gsmy" | "gsmuy" | "gsmyu" | "gsym" | "gsum" | "gsumy" | "gsuym" | "gsymu" | "gsyum" | "gyms" | "gysm" | "gums" | "gumsy" | "gumys" | "gusm" | "gusmy" | "gusym" | "guyms" | "guysm" | "gymsu" | "gymus" | "gysmu" | "gysum" | "gyums" | "gyusm" | "gim" | "gis" | "giu" | "giy" | "giuy" | "giyu" | "gisu" | "gisy" | "gisuy" | "gisyu" | "giys" | "gius" | "giusy" | "giuys" | "giysu" | "giyus" | "gims" | "gimu" | "gimy" | "gimuy" | "gimyu" | "gimsu" | "gimsy" | "gimsuy" | "gimsyu" | "gimys" | "gimus" | "gimusy" | "gimuys" | "gimysu" | "gimyus" | "giym" | "gium" | "giumy" | "giuym" | "giymu" | "giyum" | "gism" | "gismu" | "gismy" | "gismuy" | "gismyu" | "gisym" | "gisum" | "gisumy" | "gisuym" | "gisymu" | "gisyum" | "giyms" | "giysm" | "giums" | "giumsy" | "giumys" | "giusm" | "giusmy" | "giusym" | "giuyms" | "giuysm" | "giymsu" | "giymus" | "giysmu" | "giysum" | "giyums" | "giyusm" | "gyi" | "gui" | "guiy" | "guyi" | "gyiu" | "gyui" | "gsi" | "gsiu" | "gsiy" | "gsiuy" | "gsiyu" | "gsyi" | "gsui" | "gsuiy" | "gsuyi" | "gsyiu" | "gsyui" | "gyis" | "gysi" | "guis" | "guisy" | "guiys" | "gusi" | "gusiy" | "gusyi" | "guyis" | "guysi" | "gyisu" | "gyius" | "gysiu" | "gysui" | "gyuis" | "gyusi" | "gmi" | "gmis" | "gmiu" | "gmiy" | "gmiuy" | "gmiyu" | "gmisu" | "gmisy" | "gmisuy" | "gmisyu" | "gmiys" | "gmius" | "gmiusy" | "gmiuys" | "gmiysu" | "gmiyus" | "gmyi" | "gmui" | "gmuiy" | "gmuyi" | "gmyiu" | "gmyui" | "gmsi" | "gmsiu" | "gmsiy" | "gmsiuy" | "gmsiyu" | "gmsyi" | "gmsui" | "gmsuiy" | "gmsuyi" | "gmsyiu" | "gmsyui" | "gmyis" | "gmysi" | "gmuis" | "gmuisy" | "gmuiys" | "gmusi" | "gmusiy" | "gmusyi" | "gmuyis" | "gmuysi" | "gmyisu" | "gmyius" | "gmysiu" | "gmysui" | "gmyuis" | "gmyusi" | "gyim" | "gymi" | "guim" | "guimy" | "guiym" | "gumi" | "gumiy" | "gumyi" | "guyim" | "guymi" | "gyimu" | "gyium" | "gymiu" | "gymui" | "gyuim" | "gyumi" | "gsim" | "gsimu" | "gsimy" | "gsimuy" | "gsimyu" | "gsiym" | "gsium" | "gsiumy" | "gsiuym" | "gsiymu" | "gsiyum" | "gsmi" | "gsmiu" | "gsmiy" | "gsmiuy" | "gsmiyu" | "gsmyi" | "gsmui" | "gsmuiy" | "gsmuyi" | "gsmyiu" | "gsmyui" | "gsyim" | "gsymi" | "gsuim" | "gsuimy" | "gsuiym" | "gsumi" | "gsumiy" | "gsumyi" | "gsuyim" | "gsuymi" | "gsyimu" | "gsyium" | "gsymiu" | "gsymui" | "gsyuim" | "gsyumi" | "gyims" | "gyism" | "gymis" | "gymsi" | "gysim" | "gysmi" | "guims" | "guimsy" | "guimys" | "guism" | "guismy" | "guisym" | "guiyms" | "guiysm" | "gumis" | "gumisy" | "gumiys" | "gumsi" | "gumsiy" | "gumsyi" | "gumyis" | "gumysi" | "gusim" | "gusimy" | "gusiym" | "gusmi" | "gusmiy" | "gusmyi" | "gusyim" | "gusymi" | "guyims" | "guyism" | "guymis" | "guymsi" | "guysim" | "guysmi" | "gyimsu" | "gyimus" | "gyismu" | "gyisum" | "gyiums" | "gyiusm" | "gymisu" | "gymius" | "gymsiu" | "gymsui" | "gymuis" | "gymusi" | "gysimu" | "gysium" | "gysmiu" | "gysmui" | "gysuim" | "gysumi" | "gyuims" | "gyuism" | "gyumis" | "gyumsi" | "gyusim" | "gyusmi" | "yg" | "ug" | "ugy" | "uyg" | "ygu" | "yug" | "sg" | "sgu" | "sgy" | "sguy" | "sgyu" | "syg" | "sug" | "sugy" | "suyg" | "sygu" | "syug" | "ygs" | "ysg" | "ugs" | "ugsy" | "ugys" | "usg" | "usgy" | "usyg" | "uygs" | "uysg" | "ygsu" | "ygus" | "ysgu" | "ysug" | "yugs" | "yusg" | "mg" | "mgs" | "mgu" | "mgy" | "mguy" | "mgyu" | "mgsu" | "mgsy" | "mgsuy" | "mgsyu" | "mgys" | "mgus" | "mgusy" | "mguys" | "mgysu" | "mgyus" | "myg" | "mug" | "mugy" | "muyg" | "mygu" | "myug" | "msg" | "msgu" | "msgy" | "msguy" | "msgyu" | "msyg" | "msug" | "msugy" | "msuyg" | "msygu" | "msyug" | "mygs" | "mysg" | "mugs" | "mugsy" | "mugys" | "musg" | "musgy" | "musyg" | "muygs" | "muysg" | "mygsu" | "mygus" | "mysgu" | "mysug" | "myugs" | "myusg" | "ygm" | "ymg" | "ugm" | "ugmy" | "ugym" | "umg" | "umgy" | "umyg" | "uygm" | "uymg" | "ygmu" | "ygum" | "ymgu" | "ymug" | "yugm" | "yumg" | "sgm" | "sgmu" | "sgmy" | "sgmuy" | "sgmyu" | "sgym" | "sgum" | "sgumy" | "sguym" | "sgymu" | "sgyum" | "smg" | "smgu" | "smgy" | "smguy" | "smgyu" | "smyg" | "smug" | "smugy" | "smuyg" | "smygu" | "smyug" | "sygm" | "symg" | "sugm" | "sugmy" | "sugym" | "sumg" | "sumgy" | "sumyg" | "suygm" | "suymg" | "sygmu" | "sygum" | "symgu" | "symug" | "syugm" | "syumg" | "ygms" | "ygsm" | "ymgs" | "ymsg" | "ysgm" | "ysmg" | "ugms" | "ugmsy" | "ugmys" | "ugsm" | "ugsmy" | "ugsym" | "ugyms" | "ugysm" | "umgs" | "umgsy" | "umgys" | "umsg" | "umsgy" | "umsyg" | "umygs" | "umysg" | "usgm" | "usgmy" | "usgym" | "usmg" | "usmgy" | "usmyg" | "usygm" | "usymg" | "uygms" | "uygsm" | "uymgs" | "uymsg" | "uysgm" | "uysmg" | "ygmsu" | "ygmus" | "ygsmu" | "ygsum" | "ygums" | "ygusm" | "ymgsu" | "ymgus" | "ymsgu" | "ymsug" | "ymugs" | "ymusg" | "ysgmu" | "ysgum" | "ysmgu" | "ysmug" | "ysugm" | "ysumg" | "yugms" | "yugsm" | "yumgs" | "yumsg" | "yusgm" | "yusmg" | "ig" | "igm" | "igs" | "igu" | "igy" | "iguy" | "igyu" | "igsu" | "igsy" | "igsuy" | "igsyu" | "igys" | "igus" | "igusy" | "iguys" | "igysu" | "igyus" | "igms" | "igmu" | "igmy" | "igmuy" | "igmyu" | "igmsu" | "igmsy" | "igmsuy" | "igmsyu" | "igmys" | "igmus" | "igmusy" | "igmuys" | "igmysu" | "igmyus" | "igym" | "igum" | "igumy" | "iguym" | "igymu" | "igyum" | "igsm" | "igsmu" | "igsmy" | "igsmuy" | "igsmyu" | "igsym" | "igsum" | "igsumy" | "igsuym" | "igsymu" | "igsyum" | "igyms" | "igysm" | "igums" | "igumsy" | "igumys" | "igusm" | "igusmy" | "igusym" | "iguyms" | "iguysm" | "igymsu" | "igymus" | "igysmu" | "igysum" | "igyums" | "igyusm" | "iyg" | "iug" | "iugy" | "iuyg" | "iygu" | "iyug" | "isg" | "isgu" | "isgy" | "isguy" | "isgyu" | "isyg" | "isug" | "isugy" | "isuyg" | "isygu" | "isyug" | "iygs" | "iysg" | "iugs" | "iugsy" | "iugys" | "iusg" | "iusgy" | "iusyg" | "iuygs" | "iuysg" | "iygsu" | "iygus" | "iysgu" | "iysug" | "iyugs" | "iyusg" | "img" | "imgs" | "imgu" | "imgy" | "imguy" | "imgyu" | "imgsu" | "imgsy" | "imgsuy" | "imgsyu" | "imgys" | "imgus" | "imgusy" | "imguys" | "imgysu" | "imgyus" | "imyg" | "imug" | "imugy" | "imuyg" | "imygu" | "imyug" | "imsg" | "imsgu" | "imsgy" | "imsguy" | "imsgyu" | "imsyg" | "imsug" | "imsugy" | "imsuyg" | "imsygu" | "imsyug" | "imygs" | "imysg" | "imugs" | "imugsy" | "imugys" | "imusg" | "imusgy" | "imusyg" | "imuygs" | "imuysg" | "imygsu" | "imygus" | "imysgu" | "imysug" | "imyugs" | "imyusg" | "iygm" | "iymg" | "iugm" | "iugmy" | "iugym" | "iumg" | "iumgy" | "iumyg" | "iuygm" | "iuymg" | "iygmu" | "iygum" | "iymgu" | "iymug" | "iyugm" | "iyumg" | "isgm" | "isgmu" | "isgmy" | "isgmuy" | "isgmyu" | "isgym" | "isgum" | "isgumy" | "isguym" | "isgymu" | "isgyum" | "ismg" | "ismgu" | "ismgy" | "ismguy" | "ismgyu" | "ismyg" | "ismug" | "ismugy" | "ismuyg" | "ismygu" | "ismyug" | "isygm" | "isymg" | "isugm" | "isugmy" | "isugym" | "isumg" | "isumgy" | "isumyg" | "isuygm" | "isuymg" | "isygmu" | "isygum" | "isymgu" | "isymug" | "isyugm" | "isyumg" | "iygms" | "iygsm" | "iymgs" | "iymsg" | "iysgm" | "iysmg" | "iugms" | "iugmsy" | "iugmys" | "iugsm" | "iugsmy" | "iugsym" | "iugyms" | "iugysm" | "iumgs" | "iumgsy" | "iumgys" | "iumsg" | "iumsgy" | "iumsyg" | "iumygs" | "iumysg" | "iusgm" | "iusgmy" | "iusgym" | "iusmg" | "iusmgy" | "iusmyg" | "iusygm" | "iusymg" | "iuygms" | "iuygsm" | "iuymgs" | "iuymsg" | "iuysgm" | "iuysmg" | "iygmsu" | "iygmus" | "iygsmu" | "iygsum" | "iygums" | "iygusm" | "iymgsu" | "iymgus" | "iymsgu" | "iymsug" | "iymugs" | "iymusg" | "iysgmu" | "iysgum" | "iysmgu" | "iysmug" | "iysugm" | "iysumg" | "iyugms" | "iyugsm" | "iyumgs" | "iyumsg" | "iyusgm" | "iyusmg" | "ygi" | "yig" | "ugi" | "ugiy" | "ugyi" | "uig" | "uigy" | "uiyg" | "uygi" | "uyig" | "ygiu" | "ygui" | "yigu" | "yiug" | "yugi" | "yuig" | "sgi" | "sgiu" | "sgiy" | "sgiuy" | "sgiyu" | "sgyi" | "sgui" | "sguiy" | "sguyi" | "sgyiu" | "sgyui" | "sig" | "sigu" | "sigy" | "siguy" | "sigyu" | "siyg" | "siug" | "siugy" | "siuyg" | "siygu" | "siyug" | "sygi" | "syig" | "sugi" | "sugiy" | "sugyi" | "suig" | "suigy" | "suiyg" | "suygi" | "suyig" | "sygiu" | "sygui" | "syigu" | "syiug" | "syugi" | "syuig" | "ygis" | "ygsi" | "yigs" | "yisg" | "ysgi" | "ysig" | "ugis" | "ugisy" | "ugiys" | "ugsi" | "ugsiy" | "ugsyi" | "ugyis" | "ugysi" | "uigs" | "uigsy" | "uigys" | "uisg" | "uisgy" | "uisyg" | "uiygs" | "uiysg" | "usgi" | "usgiy" | "usgyi" | "usig" | "usigy" | "usiyg" | "usygi" | "usyig" | "uygis" | "uygsi" | "uyigs" | "uyisg" | "uysgi" | "uysig" | "ygisu" | "ygius" | "ygsiu" | "ygsui" | "yguis" | "ygusi" | "yigsu" | "yigus" | "yisgu" | "yisug" | "yiugs" | "yiusg" | "ysgiu" | "ysgui" | "ysigu" | "ysiug" | "ysugi" | "ysuig" | "yugis" | "yugsi" | "yuigs" | "yuisg" | "yusgi" | "yusig" | "mgi" | "mgis" | "mgiu" | "mgiy" | "mgiuy" | "mgiyu" | "mgisu" | "mgisy" | "mgisuy" | "mgisyu" | "mgiys" | "mgius" | "mgiusy" | "mgiuys" | "mgiysu" | "mgiyus" | "mgyi" | "mgui" | "mguiy" | "mguyi" | "mgyiu" | "mgyui" | "mgsi" | "mgsiu" | "mgsiy" | "mgsiuy" | "mgsiyu" | "mgsyi" | "mgsui" | "mgsuiy" | "mgsuyi" | "mgsyiu" | "mgsyui" | "mgyis" | "mgysi" | "mguis" | "mguisy" | "mguiys" | "mgusi" | "mgusiy" | "mgusyi" | "mguyis" | "mguysi" | "mgyisu" | "mgyius" | "mgysiu" | "mgysui" | "mgyuis" | "mgyusi" | "mig" | "migs" | "migu" | "migy" | "miguy" | "migyu" | "migsu" | "migsy" | "migsuy" | "migsyu" | "migys" | "migus" | "migusy" | "miguys" | "migysu" | "migyus" | "miyg" | "miug" | "miugy" | "miuyg" | "miygu" | "miyug" | "misg" | "misgu" | "misgy" | "misguy" | "misgyu" | "misyg" | "misug" | "misugy" | "misuyg" | "misygu" | "misyug" | "miygs" | "miysg" | "miugs" | "miugsy" | "miugys" | "miusg" | "miusgy" | "miusyg" | "miuygs" | "miuysg" | "miygsu" | "miygus" | "miysgu" | "miysug" | "miyugs" | "miyusg" | "mygi" | "myig" | "mugi" | "mugiy" | "mugyi" | "muig" | "muigy" | "muiyg" | "muygi" | "muyig" | "mygiu" | "mygui" | "myigu" | "myiug" | "myugi" | "myuig" | "msgi" | "msgiu" | "msgiy" | "msgiuy" | "msgiyu" | "msgyi" | "msgui" | "msguiy" | "msguyi" | "msgyiu" | "msgyui" | "msig" | "msigu" | "msigy" | "msiguy" | "msigyu" | "msiyg" | "msiug" | "msiugy" | "msiuyg" | "msiygu" | "msiyug" | "msygi" | "msyig" | "msugi" | "msugiy" | "msugyi" | "msuig" | "msuigy" | "msuiyg" | "msuygi" | "msuyig" | "msygiu" | "msygui" | "msyigu" | "msyiug" | "msyugi" | "msyuig" | "mygis" | "mygsi" | "myigs" | "myisg" | "mysgi" | "mysig" | "mugis" | "mugisy" | "mugiys" | "mugsi" | "mugsiy" | "mugsyi" | "mugyis" | "mugysi" | "muigs" | "muigsy" | "muigys" | "muisg" | "muisgy" | "muisyg" | "muiygs" | "muiysg" | "musgi" | "musgiy" | "musgyi" | "musig" | "musigy" | "musiyg" | "musygi" | "musyig" | "muygis" | "muygsi" | "muyigs" | "muyisg" | "muysgi" | "muysig" | "mygisu" | "mygius" | "mygsiu" | "mygsui" | "myguis" | "mygusi" | "myigsu" | "myigus" | "myisgu" | "myisug" | "myiugs" | "myiusg" | "mysgiu" | "mysgui" | "mysigu" | "mysiug" | "mysugi" | "mysuig" | "myugis" | "myugsi" | "myuigs" | "myuisg" | "myusgi" | "myusig" | "ygim" | "ygmi" | "yigm" | "yimg" | "ymgi" | "ymig" | "ugim" | "ugimy" | "ugiym" | "ugmi" | "ugmiy" | "ugmyi" | "ugyim" | "ugymi" | "uigm" | "uigmy" | "uigym" | "uimg" | "uimgy" | "uimyg" | "uiygm" | "uiymg" | "umgi" | "umgiy" | "umgyi" | "umig" | "umigy" | "umiyg" | "umygi" | "umyig" | "uygim" | "uygmi" | "uyigm" | "uyimg" | "uymgi" | "uymig" | "ygimu" | "ygium" | "ygmiu" | "ygmui" | "yguim" | "ygumi" | "yigmu" | "yigum" | "yimgu" | "yimug" | "yiugm" | "yiumg" | "ymgiu" | "ymgui" | "ymigu" | "ymiug" | "ymugi" | "ymuig" | "yugim" | "yugmi" | "yuigm" | "yuimg" | "yumgi" | "yumig" | "sgim" | "sgimu" | "sgimy" | "sgimuy" | "sgimyu" | "sgiym" | "sgium" | "sgiumy" | "sgiuym" | "sgiymu" | "sgiyum" | "sgmi" | "sgmiu" | "sgmiy" | "sgmiuy" | "sgmiyu" | "sgmyi" | "sgmui" | "sgmuiy" | "sgmuyi" | "sgmyiu" | "sgmyui" | "sgyim" | "sgymi" | "sguim" | "sguimy" | "sguiym" | "sgumi" | "sgumiy" | "sgumyi" | "sguyim" | "sguymi" | "sgyimu" | "sgyium" | "sgymiu" | "sgymui" | "sgyuim" | "sgyumi" | "sigm" | "sigmu" | "sigmy" | "sigmuy" | "sigmyu" | "sigym" | "sigum" | "sigumy" | "siguym" | "sigymu" | "sigyum" | "simg" | "simgu" | "simgy" | "simguy" | "simgyu" | "simyg" | "simug" | "simugy" | "simuyg" | "simygu" | "simyug" | "siygm" | "siymg" | "siugm" | "siugmy" | "siugym" | "siumg" | "siumgy" | "siumyg" | "siuygm" | "siuymg" | "siygmu" | "siygum" | "siymgu" | "siymug" | "siyugm" | "siyumg" | "smgi" | "smgiu" | "smgiy" | "smgiuy" | "smgiyu" | "smgyi" | "smgui" | "smguiy" | "smguyi" | "smgyiu" | "smgyui" | "smig" | "smigu" | "smigy" | "smiguy" | "smigyu" | "smiyg" | "smiug" | "smiugy" | "smiuyg" | "smiygu" | "smiyug" | "smygi" | "smyig" | "smugi" | "smugiy" | "smugyi" | "smuig" | "smuigy" | "smuiyg" | "smuygi" | "smuyig" | "smygiu" | "smygui" | "smyigu" | "smyiug" | "smyugi" | "smyuig" | "sygim" | "sygmi" | "syigm" | "syimg" | "symgi" | "symig" | "sugim" | "sugimy" | "sugiym" | "sugmi" | "sugmiy" | "sugmyi" | "sugyim" | "sugymi" | "suigm" | "suigmy" | "suigym" | "suimg" | "suimgy" | "suimyg" | "suiygm" | "suiymg" | "sumgi" | "sumgiy" | "sumgyi" | "sumig" | "sumigy" | "sumiyg" | "sumygi" | "sumyig" | "suygim" | "suygmi" | "suyigm" | "suyimg" | "suymgi" | "suymig" | "sygimu" | "sygium" | "sygmiu" | "sygmui" | "syguim" | "sygumi" | "syigmu" | "syigum" | "syimgu" | "syimug" | "syiugm" | "syiumg" | "symgiu" | "symgui" | "symigu" | "symiug" | "symugi" | "symuig" | "syugim" | "syugmi" | "syuigm" | "syuimg" | "syumgi" | "syumig" | "ygims" | "ygism" | "ygmis" | "ygmsi" | "ygsim" | "ygsmi" | "yigms" | "yigsm" | "yimgs" | "yimsg" | "yisgm" | "yismg" | "ymgis" | "ymgsi" | "ymigs" | "ymisg" | "ymsgi" | "ymsig" | "ysgim" | "ysgmi" | "ysigm" | "ysimg" | "ysmgi" | "ysmig" | "ugims" | "ugimsy" | "ugimys" | "ugism" | "ugismy" | "ugisym" | "ugiyms" | "ugiysm" | "ugmis" | "ugmisy" | "ugmiys" | "ugmsi" | "ugmsiy" | "ugmsyi" | "ugmyis" | "ugmysi" | "ugsim" | "ugsimy" | "ugsiym" | "ugsmi" | "ugsmiy" | "ugsmyi" | "ugsyim" | "ugsymi" | "ugyims" | "ugyism" | "ugymis" | "ugymsi" | "ugysim" | "ugysmi" | "uigms" | "uigmsy" | "uigmys" | "uigsm" | "uigsmy" | "uigsym" | "uigyms" | "uigysm" | "uimgs" | "uimgsy" | "uimgys" | "uimsg" | "uimsgy" | "uimsyg" | "uimygs" | "uimysg" | "uisgm" | "uisgmy" | "uisgym" | "uismg" | "uismgy" | "uismyg" | "uisygm" | "uisymg" | "uiygms" | "uiygsm" | "uiymgs" | "uiymsg" | "uiysgm" | "uiysmg" | "umgis" | "umgisy" | "umgiys" | "umgsi" | "umgsiy" | "umgsyi" | "umgyis" | "umgysi" | "umigs" | "umigsy" | "umigys" | "umisg" | "umisgy" | "umisyg" | "umiygs" | "umiysg" | "umsgi" | "umsgiy" | "umsgyi" | "umsig" | "umsigy" | "umsiyg" | "umsygi" | "umsyig" | "umygis" | "umygsi" | "umyigs" | "umyisg" | "umysgi" | "umysig" | "usgim" | "usgimy" | "usgiym" | "usgmi" | "usgmiy" | "usgmyi" | "usgyim" | "usgymi" | "usigm" | "usigmy" | "usigym" | "usimg" | "usimgy" | "usimyg" | "usiygm" | "usiymg" | "usmgi" | "usmgiy" | "usmgyi" | "usmig" | "usmigy" | "usmiyg" | "usmygi" | "usmyig" | "usygim" | "usygmi" | "usyigm" | "usyimg" | "usymgi" | "usymig" | "uygims" | "uygism" | "uygmis" | "uygmsi" | "uygsim" | "uygsmi" | "uyigms" | "uyigsm" | "uyimgs" | "uyimsg" | "uyisgm" | "uyismg" | "uymgis" | "uymgsi" | "uymigs" | "uymisg" | "uymsgi" | "uymsig" | "uysgim" | "uysgmi" | "uysigm" | "uysimg" | "uysmgi" | "uysmig" | "ygimsu" | "ygimus" | "ygismu" | "ygisum" | "ygiums" | "ygiusm" | "ygmisu" | "ygmius" | "ygmsiu" | "ygmsui" | "ygmuis" | "ygmusi" | "ygsimu" | "ygsium" | "ygsmiu" | "ygsmui" | "ygsuim" | "ygsumi" | "yguims" | "yguism" | "ygumis" | "ygumsi" | "ygusim" | "ygusmi" | "yigmsu" | "yigmus" | "yigsmu" | "yigsum" | "yigums" | "yigusm" | "yimgsu" | "yimgus" | "yimsgu" | "yimsug" | "yimugs" | "yimusg" | "yisgmu" | "yisgum" | "yismgu" | "yismug" | "yisugm" | "yisumg" | "yiugms" | "yiugsm" | "yiumgs" | "yiumsg" | "yiusgm" | "yiusmg" | "ymgisu" | "ymgius" | "ymgsiu" | "ymgsui" | "ymguis" | "ymgusi" | "ymigsu" | "ymigus" | "ymisgu" | "ymisug" | "ymiugs" | "ymiusg" | "ymsgiu" | "ymsgui" | "ymsigu" | "ymsiug" | "ymsugi" | "ymsuig" | "ymugis" | "ymugsi" | "ymuigs" | "ymuisg" | "ymusgi" | "ymusig" | "ysgimu" | "ysgium" | "ysgmiu" | "ysgmui" | "ysguim" | "ysgumi" | "ysigmu" | "ysigum" | "ysimgu" | "ysimug" | "ysiugm" | "ysiumg" | "ysmgiu" | "ysmgui" | "ysmigu" | "ysmiug" | "ysmugi" | "ysmuig" | "ysugim" | "ysugmi" | "ysuigm" | "ysuimg" | "ysumgi" | "ysumig" | "yugims" | "yugism" | "yugmis" | "yugmsi" | "yugsim" | "yugsmi" | "yuigms" | "yuigsm" | "yuimgs" | "yuimsg" | "yuisgm" | "yuismg" | "yumgis" | "yumgsi" | "yumigs" | "yumisg" | "yumsgi" | "yumsig" | "yusgim" | "yusgmi" | "yusigm" | "yusimg" | "yusmgi" | "yusmig") | undefined) => RegExpTsDsl;
  /** Creates a return statement. */
  return: (expr?: ReturnExpr | undefined) => ReturnTsDsl;
  /** Creates a setter method declaration. */
  setter: (name: _hey_api_codegen_core0.NodeName, fn?: ((s: SetterTsDsl) => void) | undefined) => SetterTsDsl;
  /** Wraps an expression or statement-like value into a `StmtTsDsl`. */
  stmt: (inner: ts.Expression | ts.Statement | TsDsl<any>) => StmtTsDsl;
  /** Creates a template literal expression. */
  template: (value?: TemplatePart | undefined) => TemplateTsDsl;
  /** Creates a ternary conditional expression (if ? then : else). */
  ternary: (condition?: string | ts.Expression | TsDsl<ts.Expression> | undefined) => TernaryTsDsl;
  /** Creates a throw statement. */
  throw: (error: string | ts.Expression | TsDsl<ts.Expression>, useNew?: boolean | undefined) => ThrowTsDsl;
  /** Creates a syntax token (e.g. `?`, `readonly`, `+`, `-`). */
  token: () => TokenTsDsl<never>;
  /** Creates a try/catch/finally statement. */
  try: (...args: ConstructorParameters<typeof TryTsDsl>) => TryTsDsl;
  /** Creates a basic type reference or type expression (e.g. Foo or Foo<T>). */
  type: ((name: _hey_api_codegen_core0.NodeName, fn?: TypeExprFn | undefined) => TypeExprTsDsl) & {
    /** Creates a type alias declaration (e.g. `type Foo = Bar`). */
    alias: (name: _hey_api_codegen_core0.NodeName, fn?: ((t: TypeAliasTsDsl) => void) | undefined) => TypeAliasTsDsl;
    /** Creates an intersection type (e.g. `A & B`). */
    and: (...args: ConstructorParameters<typeof TypeAndTsDsl>) => TypeAndTsDsl;
    /** Creates a qualified type reference (e.g. Foo.Bar). */
    attr: (right: _hey_api_codegen_core0.NodeName | ts.Identifier) => TypeAttrTsDsl;
    /** Creates a basic type reference or type expression (e.g. Foo or Foo<T>). */
    expr: (name: _hey_api_codegen_core0.NodeName, fn?: TypeExprFn | undefined) => TypeExprTsDsl;
    /** Converts a runtime value into a corresponding type expression node. */
    fromValue: (input: unknown) => TsDsl<ts.TypeNode>;
    /** Creates a function type node (e.g. `(a: string) => number`). */
    func: (...args: ConstructorParameters<typeof TypeFuncTsDsl>) => TypeFuncTsDsl;
    /** Creates an indexed-access type (e.g. `Foo<T>[K]`). */
    idx: (base: string | ts.TypeNode | TsDsl<ts.TypeNode>, index: string | number | ts.TypeNode | TsDsl<ts.TypeNode>) => TypeIdxTsDsl;
    /** Creates a literal type node (e.g. 'foo', 42, or true). */
    literal: (value: string | number | boolean | null) => TypeLiteralTsDsl;
    /** Creates a mapped type (e.g. `{ [K in keyof T]: U }`). */
    mapped: (name?: _hey_api_codegen_core0.NodeName | undefined) => TypeMappedTsDsl;
    /** Creates a type literal node (e.g. { foo: string }). */
    object: () => TypeObjectTsDsl;
    /** Creates a type operator node (e.g. `readonly T`, `keyof T`, `unique T`). */
    operator: () => TypeOperatorTsDsl;
    /** Represents a union type (e.g. `A | B | C`). */
    or: (...args: ConstructorParameters<typeof TypeOrTsDsl>) => TypeOrTsDsl;
    /** Creates a type parameter (e.g. `<T>`). */
    param: (name?: _hey_api_codegen_core0.NodeName | undefined, fn?: ((name: TypeParamTsDsl) => void) | undefined) => TypeParamTsDsl;
    /** Creates a type query node (e.g. `typeof Foo`). */
    query: (expr: TypeQueryExpr) => TypeQueryTsDsl;
    /** Builds a TypeScript template literal *type* (e.g. `${Foo}-${Bar}` as a type). */
    template: (value?: string | ts.TypeNode | TsDsl<ts.TypeNode> | undefined) => TypeTemplateTsDsl;
    /** Creates a tuple type (e.g. [A, B, C]). */
    tuple: (...args: ConstructorParameters<typeof TypeTupleTsDsl>) => TypeTupleTsDsl;
  };
  /** Creates a `typeof` expression (e.g. `typeof value`). */
  typeofExpr: (expr: TypeOfExpr) => TypeOfExprTsDsl;
  /** Creates a variable declaration (`var`). */
  var: (name?: _hey_api_codegen_core0.NodeName | undefined) => VarTsDsl;
};
type DollarTsDsl = {
  /**
   * Entry point to the TypeScript DSL.
   *
   * `$` creates a general expression node by default, but also exposes
   * builders for all other constructs such as `.type()`, `.call()`,
   * `.object()`, `.func()`, etc.
   *
   * Example:
   * ```ts
   * const node = $('console').attr('log').call($.literal('Hello'));
   * ```
   *
   * Returns:
   * - A new `ExprTsDsl` instance when called directly.
   * - The `tsDsl` object for constructing more specific nodes.
   */
  $: typeof $;
};
//#endregion
//#region src/plugins/@faker-js/faker/api.d.ts
type Expression = ReturnType<typeof $.expr>;
type IApi$4 = {
  /**
   * Generate a Faker expression for a schema.
   *
   * Returns an expression that produces a valid instance when executed.
   * Use when you need one-off generation without referencing shared artifacts.
   *
   * @example
   * ```ts
   * {
   *   name: faker.person.fullName(),
   *   email: faker.internet.email()
   * }
   * ```
   */
  toNode(schema: IR$1.SchemaObject): Expression;
  /**
   * Get a reference to a generated Faker expression for a schema.
   *
   * Returns a call expression referencing the shared artifact.
   * If the artifact doesn't exist, it will be created.
   *
   * @example
   * // Returns: fakeUser()
   */
  toNodeRef(schema: IR$1.SchemaObject): Expression;
};
//#endregion
//#region src/plugins/@faker-js/faker/types.d.ts
type UserConfig$23 = Plugin$1.Name<'@faker-js/faker'> & Plugin$1.Hooks & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for reusable schema definitions.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   */
  definitions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'fake{{name}}'
     */
    name?: NameTransformer;
  };
  /**
   * Faker locale for generated data.
   *
   * @default 'en'
   */
  locale?: string;
  /**
   * Seed for deterministic output. When set, Faker will produce
   * the same values across runs.
   */
  seed?: number;
};
type Config$20 = Plugin$1.Name<'@faker-js/faker'> & Plugin$1.Hooks & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Configuration for reusable schema definitions.
   */
  definitions: NamingOptions & FeatureToggle;
  /**
   * Faker locale for generated data.
   */
  locale: string;
  /**
   * Seed for deterministic output. When set, Faker will produce
   * the same values across runs.
   */
  seed?: number;
};
type FakerJsFakerPlugin = DefinePlugin$1<UserConfig$23, Config$20, IApi$4>;
//#endregion
//#region src/plugins/@hey-api/client-core/bundle/auth.d.ts
type AuthToken = string | undefined;
interface Auth {
  /**
   * Which part of the request do we use to send the auth?
   *
   * @default 'header'
   */
  in?: 'header' | 'query' | 'cookie';
  /**
   * Header or query parameter name.
   *
   * @default 'Authorization'
   */
  name?: string;
  scheme?: 'basic' | 'bearer';
  type: 'apiKey' | 'http';
}
//#endregion
//#region src/plugins/@hey-api/client-core/bundle/pathSerializer.d.ts
interface SerializerOptions<T> {
  /**
   * @default true
   */
  explode: boolean;
  style: T;
}
type ArrayStyle = 'form' | 'spaceDelimited' | 'pipeDelimited';
type ObjectStyle = 'form' | 'deepObject';
//#endregion
//#region src/plugins/@hey-api/client-core/bundle/bodySerializer.d.ts
type QuerySerializer$1 = (query: Record<string, unknown>) => string;
type BodySerializer = (body: any) => any;
type QuerySerializerOptionsObject = {
  allowReserved?: boolean;
  array?: Partial<SerializerOptions<ArrayStyle>>;
  object?: Partial<SerializerOptions<ObjectStyle>>;
};
type QuerySerializerOptions = QuerySerializerOptionsObject & {
  /**
   * Per-parameter serialization overrides. When provided, these settings
   * override the global array/object settings for specific parameter names.
   */
  parameters?: Record<string, QuerySerializerOptionsObject>;
};
//#endregion
//#region src/plugins/@hey-api/client-core/bundle/types.d.ts
type HttpMethod = 'connect' | 'delete' | 'get' | 'head' | 'options' | 'patch' | 'post' | 'put' | 'trace';
type Client$7<RequestFn$6 = never, Config$22 = unknown, MethodFn$6 = never, BuildUrlFn$6 = never, SseFn$6 = never> = {
  /**
   * Returns the final request URL.
   */
  buildUrl: BuildUrlFn$6;
  getConfig: () => Config$22;
  request: RequestFn$6;
  setConfig: (config: Config$22) => Config$22;
} & { [K in HttpMethod]: MethodFn$6 } & ([SseFn$6] extends [never] ? {
  sse?: never;
} : {
  sse: { [K in HttpMethod]: SseFn$6 };
});
interface Config$19 {
  /**
   * Auth token or a function returning auth token. The resolved value will be
   * added to the request payload as defined by its `security` array.
   */
  auth?: ((auth: Auth) => Promise<AuthToken> | AuthToken) | AuthToken;
  /**
   * A function for serializing request body parameter. By default,
   * {@link JSON.stringify()} will be used.
   */
  bodySerializer?: BodySerializer | null;
  /**
   * An object containing any HTTP headers that you want to pre-populate your
   * `Headers` object with.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/Headers/Headers#init See more}
   */
  headers?: RequestInit['headers'] | Record<string, string | number | boolean | (string | number | boolean)[] | null | undefined | unknown>;
  /**
   * The request method.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#method See more}
   */
  method?: Uppercase<HttpMethod>;
  /**
   * A function for serializing request query parameters. By default, arrays
   * will be exploded in form style, objects will be exploded in deepObject
   * style, and reserved characters are percent-encoded.
   *
   * This method will have no effect if the native `paramsSerializer()` Axios
   * API function is used.
   *
   * {@link https://swagger.io/docs/specification/serialization/#query View examples}
   */
  querySerializer?: QuerySerializer$1 | QuerySerializerOptions;
  /**
   * A function validating request data. This is useful if you want to ensure
   * the request conforms to the desired shape, so it can be safely sent to
   * the server.
   */
  requestValidator?: (data: unknown) => Promise<unknown>;
  /**
   * A function transforming response data before it's returned. This is useful
   * for post-processing data, e.g. converting ISO strings into Date objects.
   */
  responseTransformer?: (data: unknown) => Promise<unknown>;
  /**
   * A function validating response data. This is useful if you want to ensure
   * the response conforms to the desired shape, so it can be safely passed to
   * the transformers and returned to the user.
   */
  responseValidator?: (data: unknown) => Promise<unknown>;
}
//#endregion
//#region src/plugins/@hey-api/client-core/bundle/serverSentEvents.d.ts
type ServerSentEventsOptions<TData = unknown> = Omit<RequestInit, 'method'> & Pick<Config$19, 'method' | 'responseTransformer' | 'responseValidator'> & {
  /**
   * Fetch API implementation. You can use this option to provide a custom
   * fetch instance.
   *
   * @default globalThis.fetch
   */
  fetch?: typeof fetch;
  /**
   * Implementing clients can call request interceptors inside this hook.
   */
  onRequest?: (url: string, init: RequestInit) => Promise<Request>;
  /**
   * Callback invoked when a network or parsing error occurs during streaming.
   *
   * This option applies only if the endpoint returns a stream of events.
   *
   * @param error The error that occurred.
   */
  onSseError?: (error: unknown) => void;
  /**
   * Callback invoked when an event is streamed from the server.
   *
   * This option applies only if the endpoint returns a stream of events.
   *
   * @param event Event streamed from the server.
   * @returns Nothing (void).
   */
  onSseEvent?: (event: StreamEvent<TData>) => void;
  serializedBody?: RequestInit['body'];
  /**
   * Default retry delay in milliseconds.
   *
   * This option applies only if the endpoint returns a stream of events.
   *
   * @default 3000
   */
  sseDefaultRetryDelay?: number;
  /**
   * Maximum number of retry attempts before giving up.
   */
  sseMaxRetryAttempts?: number;
  /**
   * Maximum retry delay in milliseconds.
   *
   * Applies only when exponential backoff is used.
   *
   * This option applies only if the endpoint returns a stream of events.
   *
   * @default 30000
   */
  sseMaxRetryDelay?: number;
  /**
   * Optional sleep function for retry backoff.
   *
   * Defaults to using `setTimeout`.
   */
  sseSleepFn?: (ms: number) => Promise<void>;
  url: string;
};
interface StreamEvent<TData = unknown> {
  data: TData;
  event?: string;
  id?: string;
  retry?: number;
}
type ServerSentEventsResult<TData = unknown, TReturn = void, TNext = unknown> = {
  stream: AsyncGenerator<TData extends Record<string, unknown> ? TData[keyof TData] : TData, TReturn, TNext>;
};
//#endregion
//#region src/plugins/@hey-api/client-angular/bundle/utils.d.ts
type ErrInterceptor$3<Err, Res, Req, Options$6> = (error: Err, response: Res, request: Req, options: Options$6) => Err | Promise<Err>;
type ReqInterceptor$3<Req, Options$6> = (request: Req, options: Options$6) => Req | Promise<Req>;
type ResInterceptor$3<Res, Req, Options$6> = (response: Res, request: Req, options: Options$6) => Res | Promise<Res>;
declare class Interceptors$3<Interceptor> {
  fns: Array<Interceptor | null>;
  clear(): void;
  eject(id: number | Interceptor): void;
  exists(id: number | Interceptor): boolean;
  getInterceptorIndex(id: number | Interceptor): number;
  update(id: number | Interceptor, fn: Interceptor): number | Interceptor | false;
  use(fn: Interceptor): number;
}
interface Middleware$3<Req, Res, Err, Options$6> {
  error: Interceptors$3<ErrInterceptor$3<Err, Res, Req, Options$6>>;
  request: Interceptors$3<ReqInterceptor$3<Req, Options$6>>;
  response: Interceptors$3<ResInterceptor$3<Res, Req, Options$6>>;
}
//#endregion
//#region src/plugins/@hey-api/client-angular/bundle/types.d.ts
type ResponseStyle$2 = 'data' | 'fields';
interface Config$18<T extends ClientOptions$5 = ClientOptions$5> extends Omit<RequestInit, 'body' | 'headers' | 'method'>, Omit<Config$19, 'headers'> {
  /**
   * Base URL for all requests made by this client.
   */
  baseUrl?: T['baseUrl'];
  /**
   * An object containing any HTTP headers that you want to pre-populate your
   * `HttpHeaders` object with.
   *
   * {@link https://angular.dev/api/common/http/HttpHeaders#constructor See more}
   */
  headers?: HttpHeaders | Record<string, string | number | boolean | (string | number | boolean)[] | null | undefined | unknown>;
  /**
   * The HTTP client to use for making requests.
   */
  httpClient?: HttpClient;
  /**
   * Should we return only data or multiple fields (data, error, response, etc.)?
   *
   * @default 'fields'
   */
  responseStyle?: ResponseStyle$2;
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: T['throwOnError'];
}
interface RequestOptions$5<TData = unknown, TResponseStyle extends ResponseStyle$2 = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends Config$18<{
  responseStyle: TResponseStyle;
  throwOnError: ThrowOnError;
}>, Pick<ServerSentEventsOptions<TData>, 'onRequest' | 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: unknown;
  /**
   * Optional custom injector for dependency resolution if you don't implicitly or explicitly provide one.
   */
  injector?: Injector;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
interface ResolvedRequestOptions$3<TResponseStyle extends ResponseStyle$2 = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends RequestOptions$5<unknown, TResponseStyle, ThrowOnError, Url> {
  serializedBody?: string;
}
type RequestResult$5<TData = unknown, TError = unknown, ThrowOnError extends boolean = boolean, TResponseStyle extends ResponseStyle$2 = 'fields'> = Promise<ThrowOnError extends true ? TResponseStyle extends 'data' ? TData extends Record<string, unknown> ? TData[keyof TData] : TData : {
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  request: HttpRequest<unknown>;
  response: HttpResponse<TData>;
} : TResponseStyle extends 'data' ? (TData extends Record<string, unknown> ? TData[keyof TData] : TData) | undefined : {
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  error: undefined;
  request: HttpRequest<unknown>;
  response: HttpResponse<TData>;
} | {
  data: undefined;
  error: TError[keyof TError];
  request: HttpRequest<unknown>;
  response: HttpErrorResponse & {
    error: TError[keyof TError] | null;
  };
}>;
interface ClientOptions$5 {
  baseUrl?: string;
  responseStyle?: ResponseStyle$2;
  throwOnError?: boolean;
}
type MethodFn$5 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$2 = 'fields'>(options: Omit<RequestOptions$5<TData, TResponseStyle, ThrowOnError>, 'method'>) => RequestResult$5<TData, TError, ThrowOnError, TResponseStyle>;
type SseFn$5 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$2 = 'fields'>(options: Omit<RequestOptions$5<TData, TResponseStyle, ThrowOnError>, 'method'>) => Promise<ServerSentEventsResult<TData, TError>>;
type RequestFn$5 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$2 = 'fields'>(options: Omit<RequestOptions$5<TData, TResponseStyle, ThrowOnError>, 'method'> & Pick<Required<RequestOptions$5<TData, TResponseStyle, ThrowOnError>>, 'method'>) => RequestResult$5<TData, TError, ThrowOnError, TResponseStyle>;
type RequestOptionsFn = <T, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$2 = 'fields'>(options: RequestOptions$5<T, TResponseStyle, ThrowOnError>) => HttpRequest<T>;
type BuildUrlFn$5 = <TData extends {
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  url: string;
}>(options: TData & Options$5<TData>) => string;
type Client = Client$7<RequestFn$5, Config$18, MethodFn$5, BuildUrlFn$5, SseFn$5> & {
  interceptors: Middleware$3<HttpRequest<unknown>, HttpResponse<unknown>, unknown, ResolvedRequestOptions$3>;
  requestOptions: RequestOptionsFn;
};
interface TDataShape$5 {
  body?: unknown;
  headers?: unknown;
  path?: unknown;
  query?: unknown;
  url: string;
}
type OmitKeys$5<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options$5<TData extends TDataShape$5 = TDataShape$5, ThrowOnError extends boolean = boolean, TResponse = unknown, TResponseStyle extends ResponseStyle$2 = 'fields'> = OmitKeys$5<RequestOptions$5<TResponse, TResponseStyle, ThrowOnError>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : Omit<TData, 'url'>);
//#endregion
//#region src/plugins/@hey-api/client-axios/bundle/types.d.ts
interface Config$17<T extends ClientOptions$4 = ClientOptions$4> extends Omit<CreateAxiosDefaults, 'auth' | 'baseURL' | 'headers' | 'method'>, Config$19 {
  /**
   * Axios implementation. You can use this option to provide either an
   * `AxiosStatic` or an `AxiosInstance`.
   *
   * @default axios
   */
  axios?: AxiosStatic | AxiosInstance;
  /**
   * Base URL for all requests made by this client.
   */
  baseURL?: T['baseURL'];
  /**
   * An object containing any HTTP headers that you want to pre-populate your
   * `Headers` object with.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/Headers/Headers#init See more}
   */
  headers?: AxiosRequestHeaders | Record<string, string | number | boolean | (string | number | boolean)[] | null | undefined | unknown>;
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: T['throwOnError'];
}
interface RequestOptions$4<TData = unknown, ThrowOnError extends boolean = boolean, Url extends string = string> extends Config$17<{
  throwOnError: ThrowOnError;
}>, Pick<ServerSentEventsOptions<TData>, 'onRequest' | 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
interface ClientOptions$4 {
  baseURL?: string;
  throwOnError?: boolean;
}
type RequestResult$4<TData = unknown, TError = unknown, ThrowOnError extends boolean = boolean> = ThrowOnError extends true ? Promise<AxiosResponse<TData extends Record<string, unknown> ? TData[keyof TData] : TData>> : Promise<(AxiosResponse<TData extends Record<string, unknown> ? TData[keyof TData] : TData> & {
  error: undefined;
}) | (AxiosError<TError extends Record<string, unknown> ? TError[keyof TError] : TError> & {
  data: undefined;
  error: TError extends Record<string, unknown> ? TError[keyof TError] : TError;
})>;
type MethodFn$4 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$4<TData, ThrowOnError>, 'method'>) => RequestResult$4<TData, TError, ThrowOnError>;
type SseFn$4 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$4<TData, ThrowOnError>, 'method'>) => Promise<ServerSentEventsResult<TData, TError>>;
type RequestFn$4 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$4<TData, ThrowOnError>, 'method'> & Pick<Required<RequestOptions$4<TData, ThrowOnError>>, 'method'>) => RequestResult$4<TData, TError, ThrowOnError>;
type BuildUrlFn$4 = <TData extends {
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  url: string;
}>(options: TData & Options$4<TData>) => string;
type Client$1 = Client$7<RequestFn$4, Config$17, MethodFn$4, BuildUrlFn$4, SseFn$4> & {
  instance: AxiosInstance;
};
interface TDataShape$4 {
  body?: unknown;
  headers?: unknown;
  path?: unknown;
  query?: unknown;
  url: string;
}
type OmitKeys$4<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options$4<TData extends TDataShape$4 = TDataShape$4, ThrowOnError extends boolean = boolean, TResponse = unknown> = OmitKeys$4<RequestOptions$4<TResponse, ThrowOnError>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : Omit<TData, 'url'>);
//#endregion
//#region src/plugins/@hey-api/client-axios/types.d.ts
type UserConfig$22 = Plugin$1.Name<'@hey-api/client-axios'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientAxiosPlugin = DefinePlugin$1<UserConfig$22, UserConfig$22>;
//#endregion
//#region src/plugins/@hey-api/client-fetch/bundle/utils.d.ts
type ErrInterceptor$2<Err, Res, Req, Options$6> = (error: Err, response: Res, request: Req, options: Options$6) => Err | Promise<Err>;
type ReqInterceptor$2<Req, Options$6> = (request: Req, options: Options$6) => Req | Promise<Req>;
type ResInterceptor$2<Res, Req, Options$6> = (response: Res, request: Req, options: Options$6) => Res | Promise<Res>;
declare class Interceptors$2<Interceptor> {
  fns: Array<Interceptor | null>;
  clear(): void;
  eject(id: number | Interceptor): void;
  exists(id: number | Interceptor): boolean;
  getInterceptorIndex(id: number | Interceptor): number;
  update(id: number | Interceptor, fn: Interceptor): number | Interceptor | false;
  use(fn: Interceptor): number;
}
interface Middleware$2<Req, Res, Err, Options$6> {
  error: Interceptors$2<ErrInterceptor$2<Err, Res, Req, Options$6>>;
  request: Interceptors$2<ReqInterceptor$2<Req, Options$6>>;
  response: Interceptors$2<ResInterceptor$2<Res, Req, Options$6>>;
}
//#endregion
//#region src/plugins/@hey-api/client-fetch/bundle/types.d.ts
type ResponseStyle$1 = 'data' | 'fields';
interface Config$16<T extends ClientOptions$3 = ClientOptions$3> extends Omit<RequestInit, 'body' | 'headers' | 'method'>, Config$19 {
  /**
   * Base URL for all requests made by this client.
   */
  baseUrl?: T['baseUrl'];
  /**
   * Fetch API implementation. You can use this option to provide a custom
   * fetch instance.
   *
   * @default globalThis.fetch
   */
  fetch?: typeof fetch;
  /**
   * Please don't use the Fetch client for Next.js applications. The `next`
   * options won't have any effect.
   *
   * Install {@link https://www.npmjs.com/package/@hey-api/client-next `@hey-api/client-next`} instead.
   */
  next?: never;
  /**
   * Return the response data parsed in a specified format. By default, `auto`
   * will infer the appropriate method from the `Content-Type` response header.
   * You can override this behavior with any of the {@link Body} methods.
   * Select `stream` if you don't want to parse response data at all.
   *
   * @default 'auto'
   */
  parseAs?: 'arrayBuffer' | 'auto' | 'blob' | 'formData' | 'json' | 'stream' | 'text';
  /**
   * Should we return only data or multiple fields (data, error, response, etc.)?
   *
   * @default 'fields'
   */
  responseStyle?: ResponseStyle$1;
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: T['throwOnError'];
}
interface RequestOptions$3<TData = unknown, TResponseStyle extends ResponseStyle$1 = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends Config$16<{
  responseStyle: TResponseStyle;
  throwOnError: ThrowOnError;
}>, Pick<ServerSentEventsOptions<TData>, 'onRequest' | 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
interface ResolvedRequestOptions$2<TResponseStyle extends ResponseStyle$1 = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends RequestOptions$3<unknown, TResponseStyle, ThrowOnError, Url> {
  serializedBody?: string;
}
type RequestResult$3<TData = unknown, TError = unknown, ThrowOnError extends boolean = boolean, TResponseStyle extends ResponseStyle$1 = 'fields'> = ThrowOnError extends true ? Promise<TResponseStyle extends 'data' ? TData extends Record<string, unknown> ? TData[keyof TData] : TData : {
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  request: Request;
  response: Response;
}> : Promise<TResponseStyle extends 'data' ? (TData extends Record<string, unknown> ? TData[keyof TData] : TData) | undefined : ({
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  error: undefined;
} | {
  data: undefined;
  error: TError extends Record<string, unknown> ? TError[keyof TError] : TError;
}) & {
  request: Request;
  response: Response;
}>;
interface ClientOptions$3 {
  baseUrl?: string;
  responseStyle?: ResponseStyle$1;
  throwOnError?: boolean;
}
type MethodFn$3 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$1 = 'fields'>(options: Omit<RequestOptions$3<TData, TResponseStyle, ThrowOnError>, 'method'>) => RequestResult$3<TData, TError, ThrowOnError, TResponseStyle>;
type SseFn$3 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$1 = 'fields'>(options: Omit<RequestOptions$3<TData, TResponseStyle, ThrowOnError>, 'method'>) => Promise<ServerSentEventsResult<TData, TError>>;
type RequestFn$3 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle$1 = 'fields'>(options: Omit<RequestOptions$3<TData, TResponseStyle, ThrowOnError>, 'method'> & Pick<Required<RequestOptions$3<TData, TResponseStyle, ThrowOnError>>, 'method'>) => RequestResult$3<TData, TError, ThrowOnError, TResponseStyle>;
type BuildUrlFn$3 = <TData extends {
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  url: string;
}>(options: TData & Options$3<TData>) => string;
type Client$3 = Client$7<RequestFn$3, Config$16, MethodFn$3, BuildUrlFn$3, SseFn$3> & {
  interceptors: Middleware$2<Request, Response, unknown, ResolvedRequestOptions$2>;
};
interface TDataShape$3 {
  body?: unknown;
  headers?: unknown;
  path?: unknown;
  query?: unknown;
  url: string;
}
type OmitKeys$3<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options$3<TData extends TDataShape$3 = TDataShape$3, ThrowOnError extends boolean = boolean, TResponse = unknown, TResponseStyle extends ResponseStyle$1 = 'fields'> = OmitKeys$3<RequestOptions$3<TResponse, TResponseStyle, ThrowOnError>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : Omit<TData, 'url'>);
//#endregion
//#region src/plugins/@hey-api/client-fetch/types.d.ts
type UserConfig$21 = Plugin$1.Name<'@hey-api/client-fetch'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientFetchPlugin = DefinePlugin$1<UserConfig$21, UserConfig$21>;
//#endregion
//#region src/plugins/@hey-api/client-next/bundle/utils.d.ts
type ErrInterceptor$1<Err, Res, Options$6> = (error: Err, response: Res, options: Options$6) => Err | Promise<Err>;
type ReqInterceptor$1<Options$6> = (options: Options$6) => void | Promise<void>;
type ResInterceptor$1<Res, Options$6> = (response: Res, options: Options$6) => Res | Promise<Res>;
declare class Interceptors$1<Interceptor> {
  fns: Array<Interceptor | null>;
  clear(): void;
  eject(id: number | Interceptor): void;
  exists(id: number | Interceptor): boolean;
  getInterceptorIndex(id: number | Interceptor): number;
  update(id: number | Interceptor, fn: Interceptor): number | Interceptor | false;
  use(fn: Interceptor): number;
}
interface Middleware$1<Res, Err, Options$6> {
  error: Interceptors$1<ErrInterceptor$1<Err, Res, Options$6>>;
  request: Interceptors$1<ReqInterceptor$1<Options$6>>;
  response: Interceptors$1<ResInterceptor$1<Res, Options$6>>;
}
//#endregion
//#region src/plugins/@hey-api/client-next/bundle/types.d.ts
interface Config$15<T extends ClientOptions$2 = ClientOptions$2> extends Omit<RequestInit, 'body' | 'headers' | 'method'>, Config$19 {
  /**
   * Base URL for all requests made by this client.
   */
  baseUrl?: T['baseUrl'];
  /**
   * Fetch API implementation. You can use this option to provide a custom
   * fetch instance.
   *
   * @default globalThis.fetch
   */
  fetch?: typeof fetch;
  /**
   * Return the response data parsed in a specified format. By default, `auto`
   * will infer the appropriate method from the `Content-Type` response header.
   * You can override this behavior with any of the {@link Body} methods.
   * Select `stream` if you don't want to parse response data at all.
   *
   * @default 'auto'
   */
  parseAs?: 'arrayBuffer' | 'auto' | 'blob' | 'formData' | 'json' | 'stream' | 'text';
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: T['throwOnError'];
}
interface RequestOptions$2<TData = unknown, ThrowOnError extends boolean = boolean, Url extends string = string> extends Config$15<{
  throwOnError: ThrowOnError;
}>, Pick<ServerSentEventsOptions<TData>, 'onRequest' | 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
interface ResolvedRequestOptions$1<ThrowOnError extends boolean = boolean, Url extends string = string> extends RequestOptions$2<unknown, ThrowOnError, Url> {
  serializedBody?: string;
}
type RequestResult$2<TData = unknown, TError = unknown, ThrowOnError extends boolean = boolean> = ThrowOnError extends true ? Promise<{
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  response: Response;
}> : Promise<({
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  error: undefined;
} | {
  data: undefined;
  error: TError extends Record<string, unknown> ? TError[keyof TError] : TError;
}) & {
  response: Response;
}>;
interface ClientOptions$2 {
  baseUrl?: string;
  throwOnError?: boolean;
}
type MethodFn$2 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$2<TData, ThrowOnError>, 'method'>) => RequestResult$2<TData, TError, ThrowOnError>;
type SseFn$2 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$2<TData, ThrowOnError>, 'method'>) => Promise<ServerSentEventsResult<TData, TError>>;
type RequestFn$2 = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false>(options: Omit<RequestOptions$2<TData, ThrowOnError>, 'method'> & Pick<Required<RequestOptions$2<TData, ThrowOnError>>, 'method'>) => RequestResult$2<TData, TError, ThrowOnError>;
type BuildUrlFn$2 = <TData extends {
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  url: string;
}>(options: TData & Options$2<TData>) => string;
type Client$4 = Client$7<RequestFn$2, Config$15, MethodFn$2, BuildUrlFn$2, SseFn$2> & {
  interceptors: Middleware$1<Response, unknown, ResolvedRequestOptions$1>;
};
interface TDataShape$2 {
  body?: unknown;
  headers?: unknown;
  path?: unknown;
  query?: unknown;
  url: string;
}
type OmitKeys$2<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options$2<TData extends TDataShape$2 = TDataShape$2, ThrowOnError extends boolean = boolean, TResponse = unknown> = OmitKeys$2<RequestOptions$2<TResponse, ThrowOnError>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : Omit<TData, 'url'>);
//#endregion
//#region src/plugins/@hey-api/client-next/types.d.ts
type UserConfig$20 = Plugin$1.Name<'@hey-api/client-next'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientNextPlugin = DefinePlugin$1<UserConfig$20, UserConfig$20>;
//#endregion
//#region src/plugins/@hey-api/client-nuxt/bundle/types.d.ts
type QuerySerializer = (query: Parameters<Client$5['buildUrl']>[0]['query']) => string;
type WithRefs<TData> = { [K in keyof TData]: NonNullable<TData[K]> extends object ? WithRefs<NonNullable<TData[K]>> | Ref$1<NonNullable<TData[K]>> | Extract<TData[K], null> : NonNullable<TData[K]> | Ref$1<NonNullable<TData[K]>> | Extract<TData[K], null> };
type KeysOf<T> = Array<T extends T ? (keyof T extends string ? keyof T : never) : never>;
interface Config$14<T extends ClientOptions$1 = ClientOptions$1> extends Omit<FetchOptions$1<unknown>, 'baseURL' | 'body' | 'headers' | 'method' | 'query'>, WithRefs<Pick<FetchOptions$1<unknown>, 'query'>>, Omit<Config$19, 'querySerializer'> {
  /**
   * Base URL for all requests made by this client.
   */
  baseURL?: T['baseURL'];
  /**
   * A function for serializing request query parameters. By default, arrays
   * will be exploded in form style, objects will be exploded in deepObject
   * style, and reserved characters are percent-encoded.
   *
   * {@link https://swagger.io/docs/specification/serialization/#query View examples}
   */
  querySerializer?: QuerySerializer | QuerySerializerOptions;
}
interface RequestOptions$1<TComposable extends Composable = '$fetch', ResT = unknown, DefaultT = undefined, Url extends string = string> extends Config$14, WithRefs<{
  path?: FetchOptions$1<unknown>['query'];
  query?: FetchOptions$1<unknown>['query'];
}>, Pick<ServerSentEventsOptions<ResT>, 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  asyncDataOptions?: AsyncDataOptions<ResT, ResT, KeysOf<ResT>, DefaultT>;
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: NonNullable<unknown> | Ref$1<NonNullable<unknown>> | null;
  composable?: TComposable;
  key?: string;
  rawBody?: NonNullable<unknown> | Ref$1<NonNullable<unknown>> | null;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
type RequestResult$1<TComposable extends Composable, ResT, TError> = TComposable extends '$fetch' ? ReturnType<typeof $fetch<ResT>> : TComposable extends 'useAsyncData' ? ReturnType<typeof useAsyncData<ResT | null, TError>> : TComposable extends 'useFetch' ? ReturnType<typeof useFetch<ResT | null, TError>> : TComposable extends 'useLazyAsyncData' ? ReturnType<typeof useLazyAsyncData<ResT | null, TError>> : TComposable extends 'useLazyFetch' ? ReturnType<typeof useLazyFetch<ResT | null, TError>> : never;
interface ClientOptions$1 {
  baseURL?: string;
}
type MethodFn$1 = <TComposable extends Composable = '$fetch', ResT = unknown, TError = unknown, DefaultT = undefined>(options: Omit<RequestOptions$1<TComposable, ResT, DefaultT>, 'method'>) => RequestResult$1<TComposable, ResT, TError>;
type SseFn$1 = <TComposable extends Composable = '$fetch', ResT = unknown, TError = unknown, DefaultT = undefined>(options: Omit<RequestOptions$1<TComposable, ResT, DefaultT>, 'method'>) => Promise<ServerSentEventsResult<RequestResult$1<TComposable, ResT, TError>>>;
type RequestFn$1 = <TComposable extends Composable = '$fetch', ResT = unknown, TError = unknown, DefaultT = undefined>(options: Omit<RequestOptions$1<TComposable, ResT, DefaultT>, 'method'> & Pick<Required<RequestOptions$1<TComposable, ResT, DefaultT>>, 'method'>) => RequestResult$1<TComposable, ResT, TError>;
/**
 * The `createClientConfig()` function will be called on client initialization
 * and the returned object will become the client's initial configuration.
 *
 * You may want to initialize your client this way instead of calling
 * `setConfig()`. This is useful for example if you're using Next.js
 * to ensure your client always has the correct values.
 */

interface TDataShape$1 {
  body?: unknown;
  headers?: unknown;
  path?: FetchOptions$1<unknown>['query'];
  query?: FetchOptions$1<unknown>['query'];
  url: string;
}
type BuildUrlOptions<TData extends Omit<TDataShape$1, 'headers'> = Omit<TDataShape$1, 'headers'>> = Pick<WithRefs<TData>, 'path' | 'query'> & Pick<TData, 'url'> & Pick<Options$1<'$fetch', TData>, 'baseURL' | 'querySerializer'>;
type BuildUrlFn$1 = <TData extends Omit<TDataShape$1, 'headers'>>(options: BuildUrlOptions<TData>) => string;
type Client$5 = Client$7<RequestFn$1, Config$14, MethodFn$1, BuildUrlFn$1, SseFn$1>;
type OmitKeys$1<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options$1<TComposable extends Composable = '$fetch', TData extends TDataShape$1 = TDataShape$1, ResT = unknown, DefaultT = undefined> = OmitKeys$1<RequestOptions$1<TComposable, ResT, DefaultT>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : WithRefs<Omit<TData, 'url'>>);
type FetchOptions$1<TData> = Omit<UseFetchOptions<TData, TData>, keyof AsyncDataOptions<TData>>;
type Composable = '$fetch' | 'useAsyncData' | 'useFetch' | 'useLazyAsyncData' | 'useLazyFetch';
//#endregion
//#region src/plugins/@hey-api/client-nuxt/types.d.ts
type UserConfig$19 = Plugin$1.Name<'@hey-api/client-nuxt'> & Client$2.Config;
type HeyApiClientNuxtPlugin = DefinePlugin$1<UserConfig$19, UserConfig$19>;
//#endregion
//#region src/plugins/@hey-api/client-ofetch/bundle/utils.d.ts
type ErrInterceptor<Err, Res, Req, Options$6> = (error: Err, response: Res, request: Req, options: Options$6) => Err | Promise<Err>;
type ReqInterceptor<Req, Options$6> = (request: Req, options: Options$6) => Req | Promise<Req>;
type ResInterceptor<Res, Req, Options$6> = (response: Res, request: Req, options: Options$6) => Res | Promise<Res>;
declare class Interceptors<Interceptor> {
  fns: Array<Interceptor | null>;
  clear(): void;
  eject(id: number | Interceptor): void;
  exists(id: number | Interceptor): boolean;
  getInterceptorIndex(id: number | Interceptor): number;
  update(id: number | Interceptor, fn: Interceptor): number | Interceptor | false;
  use(fn: Interceptor): number;
}
interface Middleware<Req, Res, Err, Options$6> {
  error: Interceptors<ErrInterceptor<Err, Res, Req, Options$6>>;
  request: Interceptors<ReqInterceptor<Req, Options$6>>;
  response: Interceptors<ResInterceptor<Res, Req, Options$6>>;
}
//#endregion
//#region src/plugins/@hey-api/client-ofetch/bundle/types.d.ts
type ResponseStyle = 'data' | 'fields';
interface Config$13<T extends ClientOptions = ClientOptions> extends Omit<RequestInit, 'body' | 'headers' | 'method'>, Config$19 {
  /**
   * HTTP(S) agent configuration (Node.js only). Passed through to ofetch.
   */
  agent?: FetchOptions['agent'];
  /**
   * Base URL for all requests made by this client.
   */
  baseUrl?: T['baseUrl'];
  /**
   * Node-only proxy/agent options.
   */
  dispatcher?: FetchOptions['dispatcher'];
  /**
   * Fetch API implementation. Used for SSE streaming. You can use this option
   * to provide a custom fetch instance.
   *
   * @default globalThis.fetch
   */
  fetch?: typeof fetch;
  /**
   * Controls the native ofetch behaviour that throws `FetchError` when
   * `response.ok === false`. We default to suppressing it to match the fetch
   * client semantics and let `throwOnError` drive the outcome.
   */
  ignoreResponseError?: FetchOptions['ignoreResponseError'];
  /**
   * Please don't use the Fetch client for Next.js applications. The `next`
   * options won't have any effect.
   *
   * Install {@link https://www.npmjs.com/package/@hey-api/client-next `@hey-api/client-next`} instead.
   */
  next?: never;
  /**
   * Custom ofetch instance created via `ofetch.create()`. If provided, it will
   * be used for requests instead of the default `ofetch` export.
   */
  ofetch?: typeof ofetch;
  /**
   * ofetch hook called before a request is sent.
   */
  onRequest?: FetchOptions['onRequest'];
  /**
   * ofetch hook called when a request fails before receiving a response
   * (e.g., network errors or aborted requests).
   */
  onRequestError?: FetchOptions['onRequestError'];
  /**
   * ofetch hook called after a successful response is received and parsed.
   */
  onResponse?: FetchOptions['onResponse'];
  /**
   * ofetch hook called when the response indicates an error (non-ok status)
   * or when response parsing fails.
   */
  onResponseError?: FetchOptions['onResponseError'];
  /**
   * Return the response data parsed in a specified format. By default, `auto`
   * will infer the appropriate method from the `Content-Type` response header.
   * You can override this behavior with any of the {@link Body} methods.
   * Select `stream` if you don't want to parse response data at all.
   *
   * @default 'auto'
   */
  parseAs?: 'arrayBuffer' | 'auto' | 'blob' | 'formData' | 'json' | 'stream' | 'text';
  /** Custom response parser (ofetch). */
  parseResponse?: FetchOptions['parseResponse'];
  /**
   * Should we return only data or multiple fields (data, error, response, etc.)?
   *
   * @default 'fields'
   */
  responseStyle?: ResponseStyle;
  /**
   * ofetch responseType override. If provided, it will be passed directly to
   * ofetch and take precedence over `parseAs`.
   */
  responseType?: ResponseType;
  /**
   * Automatically retry failed requests.
   */
  retry?: FetchOptions['retry'];
  /**
   * Delay (in ms) between retry attempts.
   */
  retryDelay?: FetchOptions['retryDelay'];
  /**
   * HTTP status codes that should trigger a retry.
   */
  retryStatusCodes?: FetchOptions['retryStatusCodes'];
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: T['throwOnError'];
  /**
   * Abort the request after the given milliseconds.
   */
  timeout?: number;
}
interface RequestOptions<TData = unknown, TResponseStyle extends ResponseStyle = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends Config$13<{
  responseStyle: TResponseStyle;
  throwOnError: ThrowOnError;
}>, Pick<ServerSentEventsOptions<TData>, 'onSseError' | 'onSseEvent' | 'sseDefaultRetryDelay' | 'sseMaxRetryAttempts' | 'sseMaxRetryDelay'> {
  /**
   * Any body that you want to add to your request.
   *
   * {@link https://developer.mozilla.org/docs/Web/API/fetch#body}
   */
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  /**
   * Security mechanism(s) to use for the request.
   */
  security?: ReadonlyArray<Auth>;
  url: Url;
}
interface ResolvedRequestOptions<TResponseStyle extends ResponseStyle = 'fields', ThrowOnError extends boolean = boolean, Url extends string = string> extends RequestOptions<unknown, TResponseStyle, ThrowOnError, Url> {
  serializedBody?: string;
}
type RequestResult<TData = unknown, TError = unknown, ThrowOnError extends boolean = boolean, TResponseStyle extends ResponseStyle = 'fields'> = ThrowOnError extends true ? Promise<TResponseStyle extends 'data' ? TData extends Record<string, unknown> ? TData[keyof TData] : TData : {
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  request: Request;
  response: Response;
}> : Promise<TResponseStyle extends 'data' ? (TData extends Record<string, unknown> ? TData[keyof TData] : TData) | undefined : ({
  data: TData extends Record<string, unknown> ? TData[keyof TData] : TData;
  error: undefined;
} | {
  data: undefined;
  error: TError extends Record<string, unknown> ? TError[keyof TError] : TError;
}) & {
  request: Request;
  response: Response;
}>;
interface ClientOptions {
  baseUrl?: string;
  responseStyle?: ResponseStyle;
  throwOnError?: boolean;
}
type MethodFn = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle = 'fields'>(options: Omit<RequestOptions<TData, TResponseStyle, ThrowOnError>, 'method'>) => RequestResult<TData, TError, ThrowOnError, TResponseStyle>;
type SseFn = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle = 'fields'>(options: Omit<RequestOptions<TData, TResponseStyle, ThrowOnError>, 'method'>) => Promise<ServerSentEventsResult<TData, TError>>;
type RequestFn = <TData = unknown, TError = unknown, ThrowOnError extends boolean = false, TResponseStyle extends ResponseStyle = 'fields'>(options: Omit<RequestOptions<TData, TResponseStyle, ThrowOnError>, 'method'> & Pick<Required<RequestOptions<TData, TResponseStyle, ThrowOnError>>, 'method'>) => RequestResult<TData, TError, ThrowOnError, TResponseStyle>;
type BuildUrlFn = <TData extends {
  body?: unknown;
  path?: Record<string, unknown>;
  query?: Record<string, unknown>;
  url: string;
}>(options: TData & Options<TData>) => string;
type Client$6 = Client$7<RequestFn, Config$13, MethodFn, BuildUrlFn, SseFn> & {
  interceptors: Middleware<Request, Response, unknown, ResolvedRequestOptions>;
};
interface TDataShape {
  body?: unknown;
  headers?: unknown;
  path?: unknown;
  query?: unknown;
  url: string;
}
type OmitKeys<T, K$1> = Pick<T, Exclude<keyof T, K$1>>;
type Options<TData extends TDataShape = TDataShape, ThrowOnError extends boolean = boolean, TResponse = unknown, TResponseStyle extends ResponseStyle = 'fields'> = OmitKeys<RequestOptions<TResponse, TResponseStyle, ThrowOnError>, 'body' | 'path' | 'query' | 'url'> & ([TData] extends [never] ? unknown : Omit<TData, 'url'>);
//#endregion
//#region src/plugins/@hey-api/client-ofetch/types.d.ts
type UserConfig$18 = Plugin$1.Name<'@hey-api/client-ofetch'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientOfetchPlugin = DefinePlugin$1<UserConfig$18, UserConfig$18>;
//#endregion
//#region src/plugins/@hey-api/client-core/types.d.ts
interface PluginHandler {
  (...args: Parameters<HeyApiClientAngularPlugin['Handler']>): void;
  (...args: Parameters<HeyApiClientAxiosPlugin['Handler']>): void;
  (...args: Parameters<HeyApiClientFetchPlugin['Handler']>): void;
  (...args: Parameters<HeyApiClientNextPlugin['Handler']>): void;
  (...args: Parameters<HeyApiClientNuxtPlugin['Handler']>): void;
  (...args: Parameters<HeyApiClientOfetchPlugin['Handler']>): void;
}
/**
 * Public Client API.
 */
declare namespace Client$2 {
  type Config = Plugin$1.Hooks & Plugin$1.UserExports & {
    /**
     * Set a default base URL when creating the client? You can set `baseUrl`
     * to a string which will be used as the base URL. If your input defines
     * server(s), you can set `baseUrl` to a number to pick a specific server
     * to use as the base URL. You can disable setting the base URL by setting
     * `baseUrl` to `false`. By default, `baseUrl` is `true` and it will try to
     * use the first defined server value. If there's none, we won't set a
     * base URL.
     *
     * If the matched URL contains template literals, it will be ignored.
     *
     * @default true
     */
    baseUrl?: string | number | boolean;
    /**
     * Bundle the client module? When `true`, the client module will be copied
     * from the client plugin and bundled with the generated output.
     *
     * @default true
     */
    bundle?: boolean;
    /**
     * Relative path to the runtime configuration file. This file must export
     * a `createClientConfig()` function. The `createClientConfig()` function
     * will be called on client initialization and the returned object will
     * become the client's initial configuration.
     *
     * You may want to initialize your client this way instead of calling
     * `setConfig()`. This is useful for example if you're using Next.js
     * to ensure your client always has the correct values.
     */
    runtimeConfigPath?: string;
    /**
     * Should the type helper for base URL allow only values matching the
     * server(s) defined in the input? By default, `strictBaseUrl` is `false`
     * which will provide type hints and allow you to pass any string.
     *
     * Note that setting `strictBaseUrl` to `true` can produce an invalid
     * build if you specify `baseUrl` which doesn't conform to the type helper.
     *
     * @default false
     */
    strictBaseUrl?: boolean;
  };
}
//#endregion
//#region src/plugins/@hey-api/client-angular/types.d.ts
type UserConfig$17 = Plugin$1.Name<'@hey-api/client-angular'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientAngularPlugin = DefinePlugin$1<UserConfig$17, UserConfig$17>;
//#endregion
//#region src/plugins/@hey-api/client-ky/types.d.ts
type UserConfig$16 = Plugin$1.Name<'@hey-api/client-ky'> & Client$2.Config & {
  /**
   * Throw an error instead of returning it in the response?
   *
   * @default false
   */
  throwOnError?: boolean;
};
type HeyApiClientKyPlugin = DefinePlugin$1<UserConfig$16, UserConfig$16>;
//#endregion
//#region src/plugins/@hey-api/schemas/types.d.ts
type UserConfig$15 = Plugin$1.Name<'@hey-api/schemas'> & Plugin$1.Hooks & Plugin$1.UserExports & {
  /**
   * Customise the schema name. By default, `{{name}}Schema` is used. `name` is a
   * valid JavaScript/TypeScript identifier, e.g. if your schema name is
   * "Foo-Bar", `name` value would be "FooBar".
   *
   * @default '{{name}}Schema'
   */
  nameBuilder?: string | ((name: string, schema: OpenApiV2_0_XTypes['SchemaObject'] | OpenApiV3_0_XTypes['ReferenceObject'] | OpenApiV3_0_XTypes['SchemaObject'] | OpenApiV3_1_XTypes['SchemaObject']) => string);
  /**
   * Choose schema type to generate. Select 'form' if you don't want
   * descriptions to reduce bundle size and you plan to use schemas
   * for form validation
   *
   * @default 'json'
   */
  type?: 'form' | 'json';
};
type HeyApiSchemasPlugin = DefinePlugin$1<UserConfig$15, UserConfig$15>;
//#endregion
//#region src/plugins/types.d.ts
type PluginClientNames = '@hey-api/client-angular' | '@hey-api/client-axios' | '@hey-api/client-fetch' | '@hey-api/client-ky' | '@hey-api/client-next' | '@hey-api/client-nuxt' | '@hey-api/client-ofetch';
type PluginTransformerNames = '@hey-api/transformers';
type PluginValidatorNames = 'arktype' | 'valibot' | 'zod';
//#endregion
//#region src/plugins/@hey-api/sdk/examples/types.d.ts
type UserExamplesConfig = Omit<ExampleOptions, 'payload'> & {
  /**
   * Whether this feature is enabled.
   *
   * @default true
   */
  enabled?: boolean;
  /**
   * The programming language for the generated examples.
   *
   * This is used to display the language label in code blocks in
   * documentation UIs.
   *
   * @default 'JavaScript'
   */
  language?: LinguistLanguages;
  /**
   * Example request payload.
   */
  payload?: MaybeFunc<(operation: IR$1.OperationObject, ctx: DollarTsDsl) => CallArgs | CallArgs[number]>;
  /**
   * Transform the generated example string.
   *
   * @param example The generated example string.
   * @param operation The operation the example was generated for.
   * @returns The final example string.
   */
  transform?: (example: string, operation: IR$1.OperationObject) => string;
};
type ExamplesConfig = Omit<ExampleOptions, 'payload'> & FeatureToggle & {
  /**
   * The programming language for the generated examples.
   *
   * This is used to display the language label in code blocks in
   * documentation UIs.
   */
  language: LinguistLanguages;
  /**
   * Example request payload.
   */
  payload?: MaybeFunc<(operation: IR$1.OperationObject, ctx: DollarTsDsl) => CallArgs | CallArgs[number]>;
  /**
   * Transform the generated example string.
   *
   * @param example The generated example string.
   * @param operation The operation the example was generated for.
   * @returns The final example string.
   */
  transform?: (example: string, operation: IR$1.OperationObject) => string;
};
//#endregion
//#region src/plugins/@hey-api/sdk/operations/types.d.ts
interface UserOperationsConfig {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   *
   * @default 'class'
   */
  container?: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', casing: 'PascalCase' }
   */
  containerName?: NamingRule;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName?: NamingRule;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'static'` - Static methods, no instantiation required
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   *
   * @default 'instance'
   */
  methods?: 'instance' | 'static';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   *
   * @default 'operationId'
   */
  nesting?: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   *
   * @default /[./]/
   */
  nestingDelimiters?: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName?: NamingRule;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   *
   * @default 'flat'
   */
  strategy?: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   *
   * @default 'default'
   */
  strategyDefaultTag?: string;
}
interface OperationsConfig {
  /**
   * Type of container for grouped operations.
   *
   * Ignored when `strategy` is `'flat'`.
   *
   * - `'class'` - Class with methods
   */
  container: 'class';
  /**
   * Customize container names.
   *
   * For `'single'` strategy, this sets the root container name.
   * For `'byTags'` strategy, this transforms tag names.
   *
   * @default 'Sdk' for `'single'` strategy
   *
   * @example
   * // Set root name for single strategy
   * containerName: 'MyApi'
   *
   * @example
   * // Transform tag names with suffix
   * containerName: '{{name}}Service'
   *
   * @example
   * // With casing
   * containerName: { name: '{{name}}Service', case: 'PascalCase' }
   */
  containerName: NamingConfig;
  /**
   * Customize method/function names.
   *
   * Applied to the final segment of the path (the method name).
   */
  methodName: NamingConfig;
  /**
   * How methods are attached to class containers.
   *
   * Only applies when `container` is `'class'`.
   *
   * - `'static'` - Static methods, no instantiation required
   * - `'instance'` - Instance methods, requires `new ClassName(config)`
   */
  methods: 'instance' | 'static';
  /**
   * How to derive nesting structure from operations.
   *
   * - `'operationId'` - Split operationId by delimiters (e.g., `users.list` → `Users.list()`)
   * - `'id'` - Use operation id as-is, no nesting
   * - Custom function for full control
   */
  nesting: 'operationId' | 'id' | OperationPathStrategy;
  /**
   * Delimiters for splitting operationId.
   *
   * Only applies when `nesting` is `'operationId'`.
   */
  nestingDelimiters: RegExp;
  /**
   * Customize nesting segment names.
   *
   * Applied to intermediate path segments (not the method name).
   */
  segmentName: NamingConfig;
  /**
   * Grouping strategy.
   *
   * - `'flat'` - Standalone functions, no grouping
   * - `'byTags'` - One container per operation tag
   * - `'single'` - All operations in one container
   * - Custom function for full control
   */
  strategy: OperationsStrategy;
  /**
   * Default container name for operations without tags.
   *
   * Only applies when `strategy` is `'byTags'`.
   */
  strategyDefaultTag: string;
}
//#endregion
//#region src/plugins/@hey-api/sdk/types.d.ts
type UserConfig$14 = Plugin$1.Name<'@hey-api/sdk'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Should the generated functions contain auth mechanisms? You may want to
   * disable this option if you're handling auth yourself or defining it
   * globally on the client and want to reduce the size of generated code.
   *
   * @default true
   */
  auth?: boolean;
  /**
   * Use an internal client instance to send HTTP requests? This is useful if
   * you don't want to manually pass the client to each SDK function.
   *
   * You can customize the selected client output through its plugin. You can
   * also set `client` to `true` to automatically choose the client from your
   * defined plugins. If we can't detect a client plugin when using `true`, we
   * will default to `@hey-api/client-fetch`.
   *
   * @default true
   */
  client?: PluginClientNames | boolean;
  /**
   * Generate code examples for SDK operations and attach them to the
   * input source (e.g. via `x-codeSamples`).
   *
   * Set to `false` to disable example generation entirely, or provide an
   * object for fine-grained control over the output and post-processing.
   *
   * @default false
   */
  examples?: boolean | UserExamplesConfig;
  /**
   * Define the structure of generated SDK operations.
   *
   * String shorthand:
   * - `'byTags'` – one container per operation tag
   * - `'flat'` – standalone functions, no container
   * - `'single'` – all operations in a single container
   * - custom function for full control
   *
   * Use the object form for advanced configuration.
   *
   * @default 'flat'
   */
  operations?: OperationsStrategy | UserOperationsConfig;
  /**
   * Define how request parameters are structured in generated SDK methods.
   *
   * - `'flat'` merges parameters into a single object.
   * - `'grouped'` separates parameters by transport layer.
   *
   * Use `'flat'` for simpler calls or `'grouped'` for stricter typing and code clarity.
   *
   * @default 'grouped'
   */
  paramsStructure?: 'flat' | 'grouped';
  /**
   * **This feature works only with the Fetch client**
   *
   * Should we return only data or multiple fields (data, error, response, etc.)?
   *
   * @default 'fields'
   */
  responseStyle?: 'data' | 'fields';
  /**
   * Transform response data before returning. This is useful if you want to
   * convert for example ISO strings into Date objects. However, transformation
   * adds runtime overhead, so it's not recommended to use unless necessary.
   *
   * You can customize the selected transformer output through its plugin. You
   * can also set `transformer` to `true` to automatically choose the
   * transformer from your defined plugins.
   *
   * @default false
   */
  transformer?: PluginTransformerNames | boolean;
  /**
   * Validate request and/or response data against schema before returning.
   * This is useful if you want to ensure the request and/or response conforms
   * to a desired shape. However, validation adds runtime overhead, so it's
   * not recommended to use unless absolutely necessary.
   *
   * You can customize the validator output through its plugin. You can also
   * set `validator` to `true` to automatically choose the validator from your
   * defined plugins.
   *
   * You can enable/disable validation for requests and responses separately
   * by setting `validator` to an object `{ request, response }`.
   *
   * Ensure you have declared the selected library as a dependency to avoid
   * errors.
   *
   * @default false
   */
  validator?: PluginValidatorNames | boolean | {
    /**
     * Validate request data against schema before sending.
     *
     * Can be a validator plugin name or boolean (true to auto-select, false
     * to disable).
     *
     * @default false
     */
    request?: PluginValidatorNames | boolean;
    /**
     * Validate response data against schema before returning.
     *
     * Can be a validator plugin name or boolean (true to auto-select, false
     * to disable).
     *
     * @default false
     */
    response?: PluginValidatorNames | boolean;
  };
  /**
   * Group operation methods into classes? When enabled, you can select which
   * classes to export with `sdk.include` and/or transform their names with
   * `sdk.classNameBuilder`.
   *
   * Note that by enabling this option, your SDKs will **NOT**
   * support {@link https://developer.mozilla.org/docs/Glossary/Tree_shaking tree-shaking}.
   * For this reason, it is disabled by default.
   *
   * @deprecated Use `operations: { strategy: "byTags" }` or `operations: { strategy: "single" }` instead.
   * @default false
   */
  asClass?: boolean;
  /**
   * Customize the generated class names. The name variable is obtained from
   * your OpenAPI specification tags or `instance` value.
   *
   * This option has no effect if `sdk.asClass` is `false`.
   *
   * @deprecated Use `operations: { containerName: "..." }` instead.
   */
  classNameBuilder?: NameTransformer;
  /**
   * How should we structure your SDK? By default, we try to infer the ideal
   * structure using `operationId` keywords. If you prefer a flatter structure,
   * you can set `classStructure` to `off` to disable this behavior.
   *
   * @deprecated Use `operations: { nesting: "operationId" }` or `operations: { nesting: "id" }` instead.
   * @default 'auto'
   */
  classStructure?: 'auto' | 'off';
  /**
   * Set `instance` to create an instantiable SDK. Using `true` will use the
   * default instance name; in practice, you want to define your own by passing
   * a string value.
   *
   * @deprecated Use `operations: { strategy: "single", containerName: "Name", methods: "instance" }` instead.
   * @default false
   */
  instance?: string | boolean;
  /**
   * Customise the name of methods within the service. By default,
   * `operation.id` is used.
   *
   * @deprecated Use `operations: { methodName: "..." }` instead.
   */
  methodNameBuilder?: NameTransformer;
  /**
   * Use operation ID to generate operation names?
   *
   * @deprecated Use `operations: { nesting: "operationId" }` or `operations: { nesting: "id" }` instead.
   * @default true
   */
  operationId?: boolean;
  /**
   * Define shape of returned value from service calls
   *
   * @deprecated
   * @default 'body'
   */
  response?: 'body' | 'response';
};
type Config$12 = Plugin$1.Name<'@hey-api/sdk'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Should the generated functions contain auth mechanisms? You may want to
   * disable this option if you're handling auth yourself or defining it
   * globally on the client and want to reduce the size of generated code.
   *
   * @default true
   */
  auth: boolean;
  /**
   * Use an internal client instance to send HTTP requests? This is useful if
   * you don't want to manually pass the client to each SDK function.
   *
   * You can customize the selected client output through its plugin. You can
   * also set `client` to `true` to automatically choose the client from your
   * defined plugins. If we can't detect a client plugin when using `true`, we
   * will default to `@hey-api/client-fetch`.
   *
   * @default true
   */
  client: PluginClientNames | false;
  /**
   * Configuration for generating SDK code examples.
   */
  examples: ExamplesConfig;
  /**
   * Define the structure of generated SDK operations.
   */
  operations: OperationsConfig;
  /**
   * Define how request parameters are structured in generated SDK methods.
   *
   * - `'flat'` merges parameters into a single object.
   * - `'grouped'` separates parameters by transport layer.
   *
   * Use `'flat'` for simpler calls or `'grouped'` for stricter typing and code clarity.
   *
   * @default 'grouped'
   */
  paramsStructure: 'flat' | 'grouped';
  /**
   * **This feature works only with the Fetch client**
   *
   * Should we return only data or multiple fields (data, error, response, etc.)?
   *
   * @default 'fields'
   */
  responseStyle: 'data' | 'fields';
  /**
   * Transform response data before returning. This is useful if you want to
   * convert for example ISO strings into Date objects. However, transformation
   * adds runtime overhead, so it's not recommended to use unless necessary.
   *
   * You can customize the selected transformer output through its plugin. You
   * can also set `transformer` to `true` to automatically choose the
   * transformer from your defined plugins.
   *
   * @default false
   */
  transformer: PluginTransformerNames | false;
  /**
   * Validate request and/or response data against schema before returning.
   * This is useful if you want to ensure the request and/or response conforms
   * to a desired shape. However, validation adds runtime overhead, so it's
   * not recommended to use unless absolutely necessary.
   */
  validator: {
    /**
     * The validator plugin to use for request validation, or false to disable.
     *
     * @default false
     */
    request: PluginValidatorNames | false;
    /**
     * The validator plugin to use for response validation, or false to disable.
     *
     * @default false
     */
    response: PluginValidatorNames | false;
  };
  /**
   * Define shape of returned value from service calls
   *
   * @deprecated
   * @default 'body'
   */
  response: 'body' | 'response';
};
type HeyApiSdkPlugin = DefinePlugin$1<UserConfig$14, Config$12>;
//#endregion
//#region src/plugins/@hey-api/transformers/expressions.d.ts
type ExpressionTransformer = ({
  config,
  dataExpression,
  schema
}: {
  config: Omit<UserConfig$13, 'name'>;
  dataExpression?: ts.Expression | ReturnType<typeof $.expr | typeof $.attr> | string;
  schema: IR$1.SchemaObject;
}) => Array<ReturnType<typeof $.fromValue>> | undefined;
//#endregion
//#region src/plugins/@hey-api/transformers/types.d.ts
/**
 * Returns the TypeScript type node for a schema with a specific format.
 * If undefined is returned, the default type will be used.
 */
type TypeTransformer = ({
  schema
}: {
  schema: IR$1.SchemaObject;
}) => ts.TypeNode | undefined;
type UserConfig$13 = Plugin$1.Name<'@hey-api/transformers'> & Plugin$1.Hooks & Plugin$1.UserExports & {
  /**
   * Convert long integers into BigInt values?
   *
   * @default true
   */
  bigInt?: boolean;
  /**
   * Convert date strings into Date objects?
   *
   * @default true
   */
  dates?: boolean;
  /**
   * Custom transforms to apply to the generated code.
   */
  transformers?: ReadonlyArray<ExpressionTransformer>;
  /**
   * Custom type transformers that modify the TypeScript types generated.
   */
  typeTransformers?: ReadonlyArray<TypeTransformer>;
};
type Config$11 = Plugin$1.Name<'@hey-api/transformers'> & Plugin$1.Hooks & Plugin$1.Exports & {
  /**
   * Convert long integers into BigInt values?
   *
   * @default true
   */
  bigInt: boolean;
  /**
   * Convert date strings into Date objects?
   *
   * @default true
   */
  dates: boolean;
  /**
   * Custom transforms to apply to the generated code.
   */
  transformers: ReadonlyArray<ExpressionTransformer>;
  /**
   * Custom type transformers that modify the TypeScript types generated.
   */
  typeTransformers: ReadonlyArray<TypeTransformer>;
};
type HeyApiTransformersPlugin = DefinePlugin$1<UserConfig$13, Config$11>;
//#endregion
//#region src/plugins/@hey-api/typescript/shared/types.d.ts
type IrSchemaToAstOptions$1 = {
  /** The plugin instance. */
  plugin: HeyApiTypeScriptPlugin['Instance'];
  /** Optional schema extractor function. */
  schemaExtractor?: SchemaExtractor;
  /** The plugin state references. */
  state: Refs<PluginState$1>;
};
type PluginState$1 = Pick<Required<SymbolMeta>, 'path'> & Pick<Partial<SymbolMeta>, 'tags'>;
//#endregion
//#region src/plugins/@hey-api/typescript/v1/plugin.d.ts
declare function irSchemaToAst({
  plugin,
  schema,
  schemaExtractor,
  state
}: IrSchemaToAstOptions$1 & {
  schema: IR$1.SchemaObject;
}): MaybeTsDsl<TypeTsDsl>;
//#endregion
//#region src/plugins/@hey-api/typescript/api.d.ts
type IApi$3 = {
  schemaToType: (args: Parameters<typeof irSchemaToAst>[0]) => MaybeTsDsl<TypeTsDsl>;
};
//#endregion
//#region src/plugins/@hey-api/typescript/types.d.ts
type EnumsType = 'javascript' | 'typescript' | 'typescript-const';
type UserConfig$12 = Plugin$1.Name<'@hey-api/typescript'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'PascalCase'
   */
  case?: Exclude<Casing, 'SCREAMING_SNAKE_CASE'>;
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared types that can be referenced across
   * requests and responses.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default '{{name}}'
   */
  definitions?: NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}'
     */
    name?: NameTransformer;
  };
  /**
   * By default, enums are emitted as types to preserve runtime-free output.
   *
   * However, you may want to generate enums as JavaScript objects or
   * TypeScript enums for runtime usage, interoperability, or integration with
   * other tools.
   *
   * @default false
   */
  enums?: boolean | EnumsType | {
    /**
     * Casing convention for generated names.
     *
     * @default 'SCREAMING_SNAKE_CASE'
     */
    case?: Casing;
    /**
     * When generating enums as JavaScript objects, they'll contain a null
     * value if they're nullable. This might be undesirable if you want to do
     * `Object.values(Foo)` and have all values be of the same type.
     *
     * This setting is disabled by default to preserve the source schemas.
     *
     * @default false
     */
    constantsIgnoreNull?: boolean;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Specifies the output mode for generated enums.
     *
     * Can be:
     * - `javascript`: Generates JavaScript objects
     * - `typescript`: Generates TypeScript enums
     * - `typescript-const`: Generates TypeScript const enums
     *
     * @default 'javascript'
     */
    mode?: EnumsType;
  };
  /**
   * Configuration for error-specific types.
   *
   * Controls generation of types for error response bodies and status codes.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default '{{name}}Errors'
   */
  errors?: NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Error'
     */
    error?: NameTransformer;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Errors'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for request-specific types.
   *
   * Controls generation of types for request bodies, query parameters, path
   * parameters, and headers.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default '{{name}}Data'
   */
  requests?: NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Data'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for response-specific types.
   *
   * Controls generation of types for response bodies and status codes.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default '{{name}}Responses'
   */
  responses?: NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Responses'
     */
    name?: NameTransformer;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Response'
     */
    response?: NameTransformer;
  };
  /**
   * The top type to use for untyped or unspecified schema values.
   *
   * Can be:
   * - `unknown` (default): safe top type, you must narrow before use
   * - `any`: disables type checking, can be used anywhere
   *
   * @default 'unknown'
   */
  topType?: 'any' | 'unknown';
  /**
   * Configuration for webhook-specific types.
   *
   * Controls generation of types for webhook payloads and webhook requests.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default '{{name}}WebhookRequest'
   */
  webhooks?: NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}WebhookRequest'
     */
    name?: NameTransformer;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}WebhookPayload'
     */
    payload?: NameTransformer;
  };
};
type Config$10 = Plugin$1.Name<'@hey-api/typescript'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Exclude<Casing, 'SCREAMING_SNAKE_CASE'>;
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared types that can be referenced across
   * requests and responses.
   */
  definitions: NamingOptions;
  /**
   * By default, enums are emitted as types to preserve runtime-free output.
   *
   * However, you may want to generate enums as JavaScript objects or
   * TypeScript enums for runtime usage, interoperability, or integration with
   * other tools.
   */
  enums: FeatureToggle & {
    /**
     * Casing convention for generated names.
     */
    case: Casing;
    /**
     * When generating enums as JavaScript objects, they'll contain a null
     * value if they're nullable. This might be undesirable if you want to do
     * `Object.values(Foo)` and have all values be of the same type.
     *
     * This setting is disabled by default to preserve the source schemas.
     *
     * @default false
     */
    constantsIgnoreNull: boolean;
    /**
     * Specifies the output mode for generated enums.
     *
     * Can be:
     * - `javascript`: Generates JavaScript objects
     * - `typescript`: Generates TypeScript enums
     * - `typescript-const`: Generates TypeScript const enums
     *
     * @default 'javascript'
     */
    mode: EnumsType;
  };
  /**
   * Configuration for error-specific types.
   *
   * Controls generation of types for error response bodies and status codes.
   *
   * Can be:
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   */
  errors: NamingOptions & {
    /**
     * Naming pattern for generated names.
     */
    error: NameTransformer;
  };
  /**
   * Configuration for request-specific types.
   *
   * Controls generation of types for request bodies, query parameters, path
   * parameters, and headers.
   */
  requests: NamingOptions;
  /**
   * Configuration for response-specific types.
   *
   * Controls generation of types for response bodies and status codes.
   */
  responses: NamingOptions & {
    /**
     * Naming pattern for generated names.
     */
    response: NameTransformer;
  };
  /**
   * The top type to use for untyped or unspecified schema values.
   *
   * @default 'unknown'
   */
  topType: 'any' | 'unknown';
  /**
   * Configuration for webhook-specific types.
   *
   * Controls generation of types for webhook payloads and webhook requests.
   */
  webhooks: NamingOptions & {
    /**
     * Naming pattern for generated names.
     */
    payload: NameTransformer;
  };
};
type HeyApiTypeScriptPlugin = DefinePlugin$1<UserConfig$12, Config$10, IApi$3>;
//#endregion
//#region src/plugins/@pinia/colada/types.d.ts
type UserConfig$11 = Plugin$1.Name<'@pinia/colada'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://pinia-colada.esm.dev/guide/mutations.html Mutations}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Mutation'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://pinia-colada.esm.dev/guide/query-keys.html Query Keys}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}QueryKey'
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://pinia-colada.esm.dev/guide/queries.html Queries}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Query'
     */
    name?: NameTransformer;
  };
};
type Config$9 = Plugin$1.Name<'@pinia/colada'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated mutation options helpers.
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: ((operation: IR$1.OperationObject) => Record<string, unknown>) | undefined;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * See {@link https://pinia-colada.esm.dev/guide/query-keys.html Query Keys}
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * See {@link https://pinia-colada.esm.dev/guide/queries.html Queries}
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: ((operation: IR$1.OperationObject) => Record<string, unknown>) | undefined;
  };
};
type PiniaColadaPlugin = DefinePlugin$1<UserConfig$11, Config$9>;
//#endregion
//#region src/plugins/@tanstack/angular-query-experimental/types.d.ts
type UserConfig$10 = Plugin$1.Name<'@tanstack/angular-query-experimental'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteQueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteOptions'
     * @see https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/angular/reference/useMutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Mutation'
     * @see https://tanstack.com/query/v5/docs/framework/angular/reference/useMutation
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/angular/reference/queryKey}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}QueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/angular/reference/queryKey
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/angular/reference/queryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Options'
     * @see https://tanstack.com/query/v5/docs/framework/angular/reference/queryOptions
     */
    name?: NameTransformer;
  };
};
type Config$8 = Plugin$1.Name<'@tanstack/angular-query-experimental'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/angular/reference/infiniteQueryOptions
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/angular/reference/useMutation
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * @see https://tanstack.com/query/v5/docs/framework/angular/reference/queryKey
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/angular/reference/queryOptions
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
};
type TanStackAngularQueryPlugin = DefinePlugin$1<UserConfig$10, Config$8>;
//#endregion
//#region src/plugins/@tanstack/react-query/types.d.ts
type UserConfig$9 = Plugin$1.Name<'@tanstack/react-query'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
     *
     * @default '{{name}}InfiniteQueryKey'
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
     *
     * @default '{{name}}InfiniteOptions'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
     *
     * @default '{{name}}Mutation'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryKey queryKey}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/guides/query-keys Query Keys}
     *
     * @default '{{name}}QueryKey'
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
     *
     * @default '{{name}}Options'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated `useQuery()` function helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useQuery useQuery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default false
   */
  useQuery?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useQuery useQuery}
     *
     * @default 'use{{name}}Query'
     */
    name?: NameTransformer;
  };
};
type Config$7 = Plugin$1.Name<'@tanstack/react-query'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/guides/query-keys Query Keys}
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Configuration for generated `useQuery()` function helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useQuery useQuery}
   */
  useQuery: NamingOptions & FeatureToggle;
};
type TanStackReactQueryPlugin = DefinePlugin$1<UserConfig$9, Config$7>;
//#endregion
//#region src/plugins/@tanstack/solid-query/types.d.ts
type UserConfig$8 = Plugin$1.Name<'@tanstack/solid-query'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteQueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteOptions'
     * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/solid/reference/createMutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Mutation'
     * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createMutation
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/solid/reference/queryKey}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}QueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/solid/reference/queryKey
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/solid/reference/createQuery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Options'
     * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createQuery
     */
    name?: NameTransformer;
  };
};
type Config$6 = Plugin$1.Name<'@tanstack/solid-query'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createInfiniteQuery
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createMutation
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * @see https://tanstack.com/query/v5/docs/framework/solid/reference/queryKey
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/solid/reference/createQuery
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
};
type TanStackSolidQueryPlugin = DefinePlugin$1<UserConfig$8, Config$6>;
//#endregion
//#region src/plugins/@tanstack/svelte-query/types.d.ts
type UserConfig$7 = Plugin$1.Name<'@tanstack/svelte-query'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteQueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteOptions'
     * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createmutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Mutation'
     * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createmutation
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/guides/query-keys}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}QueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/react/guides/query-keys
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createquery}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Options'
     * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createquery
     */
    name?: NameTransformer;
  };
};
type Config$5 = Plugin$1.Name<'@tanstack/svelte-query'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createinfinitequery
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createmutation
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * @see https://tanstack.com/query/v5/docs/framework/react/guides/query-keys
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/svelte/reference/functions/createquery
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
};
type TanStackSvelteQueryPlugin = DefinePlugin$1<UserConfig$7, Config$5>;
//#endregion
//#region src/plugins/@tanstack/vue-query/types.d.ts
type UserConfig$6 = Plugin$1.Name<'@tanstack/vue-query'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteQueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}InfiniteOptions'
     * @see https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/vue/reference/useMutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Mutation'
     * @see https://tanstack.com/query/v5/docs/framework/vue/reference/useMutation
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/vue/reference/queryKey}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}QueryKey'
     * @see https://tanstack.com/query/v5/docs/framework/vue/reference/queryKey
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/vue/reference/queryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Options'
     * @see https://tanstack.com/query/v5/docs/framework/vue/reference/queryOptions
     */
    name?: NameTransformer;
  };
};
type Config$4 = Plugin$1.Name<'@tanstack/vue-query'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/vue/reference/infiniteQueryOptions
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/vue/reference/useMutation
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * @see https://tanstack.com/query/v5/docs/framework/vue/reference/queryKey
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * @see https://tanstack.com/query/v5/docs/framework/vue/reference/queryOptions
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
};
type TanStackVueQueryPlugin = DefinePlugin$1<UserConfig$6, Config$4>;
//#endregion
//#region src/plugins/arktype/shared/types.d.ts
type ValidatorArgs$2 = {
  operation: IR$1.OperationObject;
  plugin: ArktypePlugin['Instance'];
};
//#endregion
//#region src/plugins/arktype/api.d.ts
type IApi$2 = {
  createRequestValidator: (args: ValidatorArgs$2) => ReturnType<typeof $.func> | undefined;
  createResponseValidator: (args: ValidatorArgs$2) => ReturnType<typeof $.func> | undefined;
};
//#endregion
//#region src/plugins/arktype/types.d.ts
type UserConfig$5 = Plugin$1.Name<'arktype'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'PascalCase'
   */
  case?: Casing;
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared Arktype schemas that can be referenced
   * across requests and responses.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   */
  definitions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Enable Arktype metadata support? It's often useful to associate a schema
   * with some additional metadata for documentation, code generation, AI
   * structured outputs, form validation, and other purposes.
   *
   * @default false
   */
  metadata?: boolean;
  /**
   * Configuration for request-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for request bodies, query parameters, path
   * parameters, and headers.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  requests?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Data'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}Data'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Configuration for response-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for response bodies, error responses,
   * and status codes.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  responses?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}Response'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}Response'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Configuration for TypeScript type generation from Arktype schemas.
   *
   * Controls generation of TypeScript types based on the generated Arktype schemas.
   */
  types?: {
    /**
     * Configuration for `infer` types.
     *
     * Can be:
     * - `boolean`: Shorthand for `{ enabled: boolean }`
     * - `string` or `function`: Shorthand for `{ name: string | function }`
     * - `object`: Full configuration object
     *
     * @default false
     */
    infer?: boolean | NameTransformer | {
      /**
       * Casing convention for generated names.
       *
       * @default 'PascalCase'
       */
      case?: Casing;
      /**
       * Whether this feature is enabled.
       *
       * @default true
       */
      enabled?: boolean;
    };
  };
  /**
   * Configuration for webhook-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for webhook payloads.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  webhooks?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'PascalCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default '{{name}}WebhookRequest'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}WebhookRequest'
         */
        name?: NameTransformer;
      };
    };
  };
};
type Config$3 = Plugin$1.Name<'arktype'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared Arktype schemas that can be referenced across
   * requests and responses.
   */
  definitions: NamingOptions & FeatureToggle & {
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types: {
      /**
       * Configuration for `infer` types.
       */
      infer: NamingOptions & FeatureToggle;
    };
  };
  /**
   * Enable Arktype metadata support? It's often useful to associate a schema with
   * some additional metadata for documentation, code generation, AI
   * structured outputs, form validation, and other purposes.
   *
   * @default false
   */
  metadata: boolean;
  /**
   * Configuration for request-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for request bodies, query parameters, path
   * parameters, and headers.
   */
  requests: NamingOptions & FeatureToggle & {
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types: {
      /**
       * Configuration for `infer` types.
       */
      infer: NamingOptions & FeatureToggle;
    };
  };
  /**
   * Configuration for response-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for response bodies, error responses,
   * and status codes.
   */
  responses: NamingOptions & FeatureToggle & {
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types: {
      /**
       * Configuration for `infer` types.
       */
      infer: NamingOptions & FeatureToggle;
    };
  };
  /**
   * Configuration for TypeScript type generation from Arktype schemas.
   *
   * Controls generation of TypeScript types based on the generated Arktype schemas.
   */
  types: {
    /**
     * Configuration for `infer` types.
     */
    infer: FeatureToggle & {
      /**
       * Casing convention for generated names.
       */
      case: Casing;
    };
  };
  /**
   * Configuration for webhook-specific Arktype schemas.
   *
   * Controls generation of Arktype schemas for webhook payloads.
   */
  webhooks: NamingOptions & FeatureToggle & {
    /**
     * Configuration for TypeScript type generation from Arktype schemas.
     *
     * Controls generation of TypeScript types based on the generated Arktype schemas.
     */
    types: {
      /**
       * Configuration for `infer` types.
       */
      infer: NamingOptions & FeatureToggle;
    };
  };
};
type ArktypePlugin = DefinePlugin$1<UserConfig$5, Config$3, IApi$2>;
//#endregion
//#region src/plugins/fastify/types.d.ts
type UserConfig$4 = Plugin$1.Name<'fastify'> & Plugin$1.Hooks & Plugin$1.UserExports;
type FastifyPlugin = DefinePlugin$1<UserConfig$4, UserConfig$4>;
//#endregion
//#region src/plugins/swr/types.d.ts
type UserConfig$3 = Plugin$1.Name<'swr'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
     *
     * @default '{{name}}InfiniteQueryKey'
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  infiniteQueryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
     *
     * @default '{{name}}InfiniteOptions'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  mutationOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
     *
     * @default '{{name}}Mutation'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryKey queryKey}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryKeys?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/guides/query-keys Query Keys}
     *
     * @default '{{name}}QueryKey'
     */
    name?: NameTransformer;
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags?: boolean;
  };
  /**
   * Configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  queryOptions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported?: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta?: (operation: IR$1.OperationObject) => Record<string, unknown>;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
     *
     * @default '{{name}}Options'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for generated `useSwr()` function helpers.
   *
   * See {@link https://swr.vercel.app/docs/api API}
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  useSwr?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * See {@link https://swr.vercel.app/docs/api API}
     *
     * @default 'use{{name}}'
     */
    name?: NameTransformer;
  };
};
type Config$2 = Plugin$1.Name<'swr'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & {
  /**
   * Casing convention for generated names.
   */
  case: Casing;
  /**
   * Resolved configuration for generated infinite query key helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   */
  infiniteQueryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in infinite query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated infinite query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/infiniteQueryOptions infiniteQueryOptions}
   */
  infiniteQueryOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated infinite query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated mutation options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/useMutation useMutation}
   */
  mutationOptions: NamingOptions & FeatureToggle & {
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated mutation options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Resolved configuration for generated query keys.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/guides/query-keys Query Keys}
   */
  queryKeys: NamingOptions & FeatureToggle & {
    /**
     * Whether to include operation tags in query keys.
     * This will make query keys larger but provides better cache invalidation capabilities.
     *
     * @default false
     */
    tags: boolean;
  };
  /**
   * Resolved configuration for generated query options helpers.
   *
   * See {@link https://tanstack.com/query/v5/docs/framework/react/reference/queryOptions queryOptions}
   */
  queryOptions: NamingOptions & FeatureToggle & {
    /**
     * Whether to export generated symbols.
     *
     * @default true
     */
    exported: boolean;
    /**
     * Custom function to generate metadata for the operation.
     * Can return any valid meta object that will be included in the generated query options.
     *
     * @param operation - The operation object containing all available metadata
     * @returns A meta object with any properties you want to include
     *
     * @example
     * ```ts
     * meta: (operation) => ({
     *   customField: operation.id,
     *   isDeprecated: operation.deprecated,
     *   tags: operation.tags,
     *   customObject: {
     *     method: operation.method,
     *     path: operation.path
     *   }
     * })
     * ```
     *
     * @default undefined
     */
    meta: (operation: IR$1.OperationObject) => Record<string, unknown>;
  };
  /**
   * Configuration for generated `useSwr()` function helpers.
   *
   * See {@link https://swr.vercel.app/docs/api API}
   */
  useSwr: NamingOptions & FeatureToggle;
};
type SwrPlugin = DefinePlugin$1<UserConfig$3, Config$2>;
//#endregion
//#region src/plugins/valibot/shared/pipes.d.ts
type Pipe = ReturnType<typeof $.call | typeof $.expr>;
type Pipes = Array<Pipe>;
type PipeResult = Pipes | Pipe | undefined;
interface PipesUtils {
  /**
   * Pushes a pipe result onto a pipes array.
   *
   * Handles single pipes, arrays of pipes, and undefined.
   */
  push: (target: Pipes, result: PipeResult) => Pipes;
  /**
   * Converts a pipes array to a single node expression.
   */
  toNode: (pipes: Pipes | Pipe, plugin: ValibotPlugin['Instance']) => Pipe;
}
//#endregion
//#region src/plugins/valibot/shared/types.d.ts
type ValidatorArgs$1 = {
  operation: IR$1.OperationObject;
  /** The plugin instance. */
  plugin: ValibotPlugin['Instance'];
};
/**
 * Metadata that flows through schema walking.
 */
interface ValibotMeta {
  /** Default value from schema. */
  default?: unknown;
  /** Original format (for BigInt coercion). */
  format?: string;
  /** Whether this or any child contains a lazy reference. */
  hasLazy: boolean;
  /** Does this schema explicitly allow null? */
  nullable: boolean;
  /** Is this schema read-only? */
  readonly: boolean;
}
/**
 * Result from walking a schema node.
 */
interface ValibotResult {
  meta: ValibotMeta;
  pipes: Pipes;
}
/**
 * Finalized result after applyModifiers.
 */
interface ValibotFinal {
  pipes: Pipes;
  /** Type annotation for schemas requiring explicit typing (e.g., lazy). */
  typeName?: string | ts.Identifier;
}
//#endregion
//#region src/plugins/valibot/api.d.ts
type IApi$1 = {
  createRequestValidator: (args: ValidatorArgs$1) => ReturnType<typeof $.func> | undefined;
  createResponseValidator: (args: ValidatorArgs$1) => ReturnType<typeof $.func> | undefined;
};
//#endregion
//#region src/plugins/shared/utils/coerce.d.ts
type MaybeBigInt = (value: unknown, format: string | undefined) => ReturnType<typeof $.fromValue>;
type ShouldCoerceToBigInt = (format: string | undefined) => boolean;
//#endregion
//#region src/plugins/shared/utils/formats.d.ts
type Range = number | string;
interface IntegerLimit {
  maxError: string;
  maxValue: Range;
  minError: string;
  minValue: Range;
}
type GetIntegerLimit = (format: string | undefined) => IntegerLimit | undefined;
//#endregion
//#region src/plugins/valibot/resolvers.d.ts
type Resolvers$1 = Plugin$1.Resolvers<{
  /**
   * Resolver for enum schemas.
   *
   * Allows customization of how enum types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  enum?: (ctx: EnumResolverContext$1) => PipeResult;
  /**
   * Resolver for number schemas.
   *
   * Allows customization of how number types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  number?: (ctx: NumberResolverContext$1) => PipeResult;
  /**
   * Resolver for object schemas.
   *
   * Allows customization of how object types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  object?: (ctx: ObjectResolverContext$1) => PipeResult;
  /**
   * Resolver for string schemas.
   *
   * Allows customization of how string types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  string?: (ctx: StringResolverContext$1) => PipeResult;
  /**
   * Resolvers for request and response validators.
   *
   * Allow customization of validator function bodies.
   *
   * Example path: `~resolvers.validator.request` or `~resolvers.validator.response`
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  validator?: ValidatorResolver$1 | {
    /**
     * Controls how the request validator function body is generated.
     *
     * Returning `undefined` will execute the default resolver logic.
     */
    request?: ValidatorResolver$1;
    /**
     * Controls how the response validator function body is generated.
     *
     * Returning `undefined` will execute the default resolver logic.
     */
    response?: ValidatorResolver$1;
  };
}>;
type ValidatorResolver$1 = (ctx: ValidatorResolverContext$1) => PipeResult | null | undefined;
interface BaseContext$1 extends DollarTsDsl {
  /**
   * Functions for working with pipes.
   */
  pipes: PipesUtils & {
    /**
     * The current pipe.
     *
     * In Valibot, this represents a list of call expressions ("pipes")
     * being assembled to form a schema definition.
     *
     * Each pipe can be extended, modified, or replaced to customize
     * the resulting schema.
     */
    current: Pipes;
  };
  /** The plugin instance. */
  plugin: ValibotPlugin['Instance'];
  /**
   * Provides access to commonly used symbols within the plugin.
   */
  symbols: {
    v: Symbol;
  };
}
interface EnumResolverContext$1 extends BaseContext$1 {
  /**
   * Nodes used to build different parts of the schema.
   */
  nodes: {
    /**
     * Returns the base enum expression (v.picklist([...])).
     */
    base: (ctx: EnumResolverContext$1) => PipeResult;
    /**
     * Returns parsed enum items with metadata about the enum members.
     */
    items: (ctx: EnumResolverContext$1) => {
      /**
       * String literal values for use with v.picklist([...]).
       */
      enumMembers: Array<ReturnType<typeof $.literal>>;
      /**
       * Whether the enum includes a null value.
       */
      isNullable: boolean;
    };
  };
  schema: SchemaWithType<'enum'>;
}
interface NumberResolverContext$1 extends BaseContext$1 {
  /**
   * Nodes used to build different parts of the schema.
   */
  nodes: {
    base: (ctx: NumberResolverContext$1) => PipeResult;
    const: (ctx: NumberResolverContext$1) => PipeResult;
    max: (ctx: NumberResolverContext$1) => PipeResult;
    min: (ctx: NumberResolverContext$1) => PipeResult;
  };
  schema: SchemaWithType<'integer' | 'number'>;
  /**
   * Utility functions for number schema processing.
   */
  utils: {
    getIntegerLimit: GetIntegerLimit;
    maybeBigInt: MaybeBigInt;
    shouldCoerceToBigInt: ShouldCoerceToBigInt;
  };
}
interface ObjectResolverContext$1 extends BaseContext$1 {
  _childResults: Array<ValibotResult>;
  applyModifiers: (result: ValibotResult, opts: {
    optional?: boolean;
  }) => ValibotFinal;
  /**
   * Nodes used to build different parts of the schema.
   */
  nodes: {
    additionalProperties: (ctx: ObjectResolverContext$1) => Pipe | null | undefined;
    base: (ctx: ObjectResolverContext$1) => Pipes | Pipe;
    shape: (ctx: ObjectResolverContext$1) => ReturnType<typeof $.object>;
  };
  schema: SchemaWithType<'object'>;
  /**
   * Utility functions for object schema processing.
   */
  utils: {
    ast: Partial<{
      hasLazy: boolean;
    }>;
  };
  walk: Walker<ValibotResult, ValibotPlugin['Instance']>;
  walkerCtx: SchemaVisitorContext<ValibotPlugin['Instance']>;
}
interface StringResolverContext$1 extends BaseContext$1 {
  /**
   * Nodes used to build different parts of the schema.
   */
  nodes: {
    base: (ctx: StringResolverContext$1) => PipeResult;
    const: (ctx: StringResolverContext$1) => PipeResult;
    format: (ctx: StringResolverContext$1) => PipeResult;
    length: (ctx: StringResolverContext$1) => PipeResult;
    maxLength: (ctx: StringResolverContext$1) => PipeResult;
    minLength: (ctx: StringResolverContext$1) => PipeResult;
    pattern: (ctx: StringResolverContext$1) => PipeResult;
  };
  schema: SchemaWithType<'string'>;
}
interface ValidatorResolverContext$1 extends BaseContext$1 {
  operation: IR$1.OperationObject;
  /**
   * Provides access to commonly used symbols within the plugin.
   */
  symbols: BaseContext$1['symbols'] & {
    schema: Symbol;
  };
}
//#endregion
//#region src/plugins/valibot/types.d.ts
type UserConfig$2 = Plugin$1.Name<'valibot'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & Resolvers$1 & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared Valibot schemas that can be referenced
   * across requests and responses.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  definitions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'v{{name}}'
     */
    name?: NameTransformer;
  };
  /**
   * Enable Valibot metadata support? It's often useful to associate a schema
   * with some additional metadata for documentation, code generation, AI
   * structured outputs, form validation, and other purposes.
   *
   * @default false
   */
  metadata?: boolean;
  /**
   * Configuration for request-specific Valibot schemas.
   *
   * Controls generation of Valibot schemas for request bodies, query
   * parameters, path parameters, and headers.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  requests?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'v{{name}}Data'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for response-specific Valibot schemas.
   *
   * Controls generation of Valibot schemas for response bodies, error
   * responses, and status codes.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  responses?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'v{{name}}Response'
     */
    name?: NameTransformer;
  };
  /**
   * Configuration for webhook-specific Valibot schemas.
   *
   * Controls generation of Valibot schemas for webhook payloads.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  webhooks?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'v{{name}}WebhookRequest'
     */
    name?: NameTransformer;
  };
};
type Config$1 = Plugin$1.Name<'valibot'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & Resolvers$1 & {
  /** Casing convention for generated names. */
  case: Casing;
  /** Configuration for reusable schema definitions. */
  definitions: NamingOptions & FeatureToggle;
  /** Enable Valibot metadata support? */
  metadata: boolean;
  /** Configuration for request-specific Valibot schemas. */
  requests: NamingOptions & FeatureToggle;
  /** Configuration for response-specific Valibot schemas. */
  responses: NamingOptions & FeatureToggle;
  /** Configuration for webhook-specific Valibot schemas. */
  webhooks: NamingOptions & FeatureToggle;
};
type ValibotPlugin = DefinePlugin$1<UserConfig$2, Config$1, IApi$1>;
//#endregion
//#region src/plugins/zod/shared/types.d.ts
type Ast = {
  anyType?: string;
  expression: ReturnType<typeof $.expr | typeof $.call>;
  hasLazyExpression?: boolean;
  typeName?: string | ts.Identifier;
};
type IrSchemaToAstOptions = {
  /** The plugin instance. */
  plugin: ZodPlugin['Instance'];
  /** The plugin state references. */
  state: Refs<PluginState>;
  walk: Walker<ZodSchemaResult, ZodPlugin['Instance']>;
};
type PluginState = Pick<Required<SymbolMeta>, 'path'> & Pick<Partial<SymbolMeta>, 'tags'> & {
  anyType?: string;
  hasLazyExpression: boolean;
};
type TypeOptions = {
  /** Configuration for TypeScript type generation from Zod schemas. */
  types: {
    /** Configuration for `infer` types. */
    infer: NamingOptions & FeatureToggle;
  };
};
type ValidatorArgs = {
  operation: IR$1.OperationObject;
  plugin: ZodPlugin['Instance'];
};
/**
 * The result from schema walking.
 */
interface ZodSchemaResult {
  /** Default value from schema, if any. */
  default?: unknown;
  /** The Zod expression AST. */
  expression: {
    expression: ReturnType<typeof $.expr | typeof $.call>;
  };
  /** The original schema format (for BigInt coercion). */
  format?: string;
  /** Whether any child contains a lazy expression. */
  hasLazyExpression?: boolean;
  /** Whether THIS result is itself lazy (not just inherited). */
  isLazy?: boolean;
  /** Does this schema explicitly allow null? */
  nullable: boolean;
  /** Is this schema read-only? */
  readonly: boolean;
}
//#endregion
//#region src/plugins/zod/api.d.ts
type IApi = {
  createRequestValidator: (args: ValidatorArgs) => ReturnType<typeof $.func> | undefined;
  createResponseValidator: (args: ValidatorArgs) => ReturnType<typeof $.func> | undefined;
};
//#endregion
//#region src/plugins/zod/shared/chain.d.ts
type Chain = ReturnType<typeof $.call | typeof $.expr>;
//#endregion
//#region src/plugins/zod/resolvers/types.d.ts
type Resolvers = Plugin$1.Resolvers<{
  /**
   * Resolver for enum schemas.
   *
   * Allows customization of how enum types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  enum?: (ctx: EnumResolverContext) => Chain | undefined;
  /**
   * Resolver for number schemas.
   *
   * Allows customization of how number types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  number?: (ctx: NumberResolverContext) => Chain | undefined;
  /**
   * Resolver for object schemas.
   *
   * Allows customization of how object types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  object?: (ctx: ObjectResolverContext) => Chain | undefined;
  /**
   * Resolver for string schemas.
   *
   * Allows customization of how string types are rendered.
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  string?: (ctx: StringResolverContext) => Chain | undefined;
  /**
   * Resolvers for request and response validators.
   *
   * Allow customization of validator function bodies.
   *
   * Example path: `~resolvers.validator.request` or `~resolvers.validator.response`
   *
   * Returning `undefined` will execute the default resolver logic.
   */
  validator?: ValidatorResolver | {
    /**
     * Controls how the request validator function body is generated.
     *
     * Returning `undefined` will execute the default resolver logic.
     */
    request?: ValidatorResolver;
    /**
     * Controls how the response validator function body is generated.
     *
     * Returning `undefined` will execute the default resolver logic.
     */
    response?: ValidatorResolver;
  };
}>;
type ValidatorResolver = (ctx: ValidatorResolverContext) => MaybeArray<TsDsl<ts.Statement>> | null | undefined;
type BaseContext = DollarTsDsl & Pick<IrSchemaToAstOptions, 'plugin'> & {
  /**
   * Functions for working with chains.
   */
  chain: {
    /**
     * The current chain.
     *
     * In Zod, this represents a chain of call expressions ("chains")
     * being assembled to form a schema definition.
     *
     * Each chain can be extended, modified, or replaced to customize
     * the resulting schema.
     */
    current: Chain;
  };
  /**
   * Provides access to commonly used symbols within the plugin.
   */
  symbols: {
    z: Symbol;
  };
};
interface EnumResolverContext extends BaseContext {
  /**
   * Nodes used to build different parts of the enum schema.
   */
  nodes: {
    /**
     * Returns the base enum expression (z.enum([...]) or z.union([...]) for mixed types).
     */
    base: (ctx: EnumResolverContext) => Chain;
    /**
     * Returns parsed enum items with metadata about the enum members.
     */
    items: (ctx: EnumResolverContext) => {
      /**
       * Whether all enum items are strings (determines if z.enum can be used).
       */
      allStrings: boolean;
      /**
       * String literal values for use with z.enum([...]).
       */
      enumMembers: Array<ReturnType<typeof $.literal>>;
      /**
       * Whether the enum includes a null value.
       */
      isNullable: boolean;
      /**
       * z.literal(...) expressions for each non-null enum value.
       */
      literalMembers: Array<Chain>;
    };
  };
  schema: SchemaWithType<'enum'>;
  /**
   * Utility functions for enum schema processing.
   */
  utils: {
    ast: Partial<Omit<Ast, 'typeName'>>;
    state: Refs<PluginState>;
  };
}
interface NumberResolverContext extends BaseContext {
  /**
   * Nodes used to build different parts of the number schema.
   */
  nodes: {
    base: (ctx: NumberResolverContext) => Chain;
    const: (ctx: NumberResolverContext) => Chain | undefined;
    max: (ctx: NumberResolverContext) => Chain | undefined;
    min: (ctx: NumberResolverContext) => Chain | undefined;
  };
  schema: SchemaWithType<'integer' | 'number'>;
  /**
   * Utility functions for number schema processing.
   */
  utils: {
    ast: Partial<Omit<Ast, 'typeName'>>;
    getIntegerLimit: GetIntegerLimit;
    maybeBigInt: MaybeBigInt;
    shouldCoerceToBigInt: ShouldCoerceToBigInt;
    state: Refs<PluginState>;
  };
}
interface ObjectResolverContext extends BaseContext {
  applyModifiers: (result: ZodSchemaResult, opts: {
    optional?: boolean;
  }) => Ast;
  /**
   * Nodes used to build different parts of the object schema.
   */
  nodes: {
    /**
     * If `additionalProperties` is `false` or `{ type: 'never' }`, returns `null`
     * to indicate no additional properties are allowed.
     */
    additionalProperties: (ctx: ObjectResolverContext) => Chain | null | undefined;
    base: (ctx: ObjectResolverContext) => Chain;
    shape: (ctx: ObjectResolverContext) => ReturnType<typeof $.object>;
  };
  schema: SchemaWithType<'object'>;
  /**
   * Utility functions for object schema processing.
   */
  utils: {
    ast: Partial<Omit<Ast, 'typeName'>>;
    state: Refs<PluginState>;
  };
  walk: Walker<ZodSchemaResult, ZodPlugin['Instance']>;
  walkerCtx: SchemaVisitorContext<ZodPlugin['Instance']>;
}
interface StringResolverContext extends BaseContext {
  /**
   * Nodes used to build different parts of the string schema.
   */
  nodes: {
    base: (ctx: StringResolverContext) => Chain;
    const: (ctx: StringResolverContext) => Chain | undefined;
    format: (ctx: StringResolverContext) => Chain | undefined;
    length: (ctx: StringResolverContext) => Chain | undefined;
    maxLength: (ctx: StringResolverContext) => Chain | undefined;
    minLength: (ctx: StringResolverContext) => Chain | undefined;
    pattern: (ctx: StringResolverContext) => Chain | undefined;
  };
  schema: SchemaWithType<'string'>;
}
interface ValidatorResolverContext extends BaseContext {
  operation: IR$1.OperationObject;
  /**
   * Provides access to commonly used symbols within the plugin.
   */
  symbols: BaseContext['symbols'] & {
    schema: Symbol;
  };
}
//#endregion
//#region src/plugins/zod/types.d.ts
type UserConfig$1 = Plugin$1.Name<'zod'> & Plugin$1.Hooks & Plugin$1.UserComments & Plugin$1.UserExports & Resolvers & {
  /**
   * Casing convention for generated names.
   *
   * @default 'camelCase'
   */
  case?: Casing;
  /**
   * The compatibility version to target for generated output.
   *
   * Can be:
   * - `4`: [Zod 4](https://zod.dev/packages/zod) (default).
   * - `3`: [Zod 3](https://v3.zod.dev/).
   * - `'mini'`: [Zod Mini](https://zod.dev/packages/mini).
   *
   * @default 4
   */
  compatibilityVersion?: 3 | 4 | 'mini';
  /**
   * Configuration for date handling in generated Zod schemas.
   *
   * Controls how date values are processed and validated using Zod's
   * date validation features.
   */
  dates?: {
    /**
     * Whether to allow unqualified (timezone-less) datetimes:
     *
     * When enabled, Zod will accept datetime strings without timezone information.
     * When disabled, Zod will require timezone information in datetime strings.
     *
     * @default false
     */
    local?: boolean;
    /**
     * Whether to include timezone offset information when handling dates.
     *
     * When enabled, date strings will preserve timezone information.
     * When disabled, dates will be treated as local time.
     *
     * @default false
     */
    offset?: boolean;
  };
  /**
   * Configuration for reusable schema definitions.
   *
   * Controls generation of shared Zod schemas that can be referenced across
   * requests and responses.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  definitions?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'z{{name}}'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Zod schemas.
     *
     * Controls generation of TypeScript types based on the generated Zod schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}ZodType'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Enable Zod metadata support? It's often useful to associate a schema with
   * some additional metadata for documentation, code generation, AI
   * structured outputs, form validation, and other purposes.
   *
   * @default false
   */
  metadata?: boolean;
  /**
   * Configuration for request-specific Zod schemas.
   *
   * Controls generation of Zod schemas for request bodies, query parameters, path
   * parameters, and headers.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  requests?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'z{{name}}Data'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Zod schemas.
     *
     * Controls generation of TypeScript types based on the generated Zod schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}DataZodType'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Configuration for response-specific Zod schemas.
   *
   * Controls generation of Zod schemas for response bodies, error responses,
   * and status codes.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  responses?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'z{{name}}Response'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Zod schemas.
     *
     * Controls generation of TypeScript types based on the generated Zod schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}ResponseZodType'
         */
        name?: NameTransformer;
      };
    };
  };
  /**
   * Configuration for TypeScript type generation from Zod schemas.
   *
   * Controls generation of TypeScript types based on the generated Zod schemas.
   */
  types?: {
    /**
     * Configuration for `infer` types.
     *
     * Can be:
     * - `boolean`: Shorthand for `{ enabled: boolean }`
     * - `string` or `function`: Shorthand for `{ name: string | function }`
     * - `object`: Full configuration object
     *
     * @default false
     */
    infer?: boolean | NameTransformer | {
      /**
       * Casing convention for generated names.
       *
       * @default 'PascalCase'
       */
      case?: Casing;
      /**
       * Whether this feature is enabled.
       *
       * @default true
       */
      enabled?: boolean;
    };
  };
  /**
   * Configuration for webhook-specific Zod schemas.
   *
   * Controls generation of Zod schemas for webhook payloads.
   *
   * Can be:
   * - `boolean`: Shorthand for `{ enabled: boolean }`
   * - `string` or `function`: Shorthand for `{ name: string | function }`
   * - `object`: Full configuration object
   *
   * @default true
   */
  webhooks?: boolean | NameTransformer | {
    /**
     * Casing convention for generated names.
     *
     * @default 'camelCase'
     */
    case?: Casing;
    /**
     * Whether this feature is enabled.
     *
     * @default true
     */
    enabled?: boolean;
    /**
     * Naming pattern for generated names.
     *
     * @default 'z{{name}}WebhookRequest'
     */
    name?: NameTransformer;
    /**
     * Configuration for TypeScript type generation from Zod schemas.
     *
     * Controls generation of TypeScript types based on the generated Zod schemas.
     */
    types?: {
      /**
       * Configuration for `infer` types.
       *
       * Can be:
       * - `boolean`: Shorthand for `{ enabled: boolean }`
       * - `string` or `function`: Shorthand for `{ name: string | function }`
       * - `object`: Full configuration object
       *
       * @default false
       */
      infer?: boolean | NameTransformer | {
        /**
         * Casing convention for generated names.
         *
         * @default 'PascalCase'
         */
        case?: Casing;
        /**
         * Whether this feature is enabled.
         *
         * @default true
         */
        enabled?: boolean;
        /**
         * Naming pattern for generated names.
         *
         * @default '{{name}}WebhookRequestZodType'
         */
        name?: NameTransformer;
      };
    };
  };
};
type Config = Plugin$1.Name<'zod'> & Plugin$1.Hooks & Plugin$1.Comments & Plugin$1.Exports & Resolvers & {
  /** Casing convention for generated names. */
  case: Casing;
  /** The compatibility version to target for generated output. */
  compatibilityVersion: 3 | 4 | 'mini';
  /** Configuration for date handling in generated Zod schemas. */
  dates: {
    /** Whether to allow unqualified (timezone-less) datetimes. */
    local: boolean;
    /** Whether to include timezone offset information when handling dates. */
    offset: boolean;
  };
  /** Configuration for reusable schema definitions. */
  definitions: NamingOptions & FeatureToggle & TypeOptions;
  /** Enable Zod metadata support? */
  metadata: boolean;
  /** Configuration for request-specific Zod schemas. */
  requests: NamingOptions & FeatureToggle & TypeOptions;
  /** Configuration for response-specific Zod schemas. */
  responses: NamingOptions & FeatureToggle & TypeOptions;
  /** Configuration for TypeScript type generation from Zod schemas. */
  types: {
    /** Configuration for `infer` types. */
    infer: FeatureToggle & {
      /** Casing convention for generated names. */
      case: Casing;
    };
  };
  /** Configuration for webhook-specific Zod schemas. */
  webhooks: NamingOptions & FeatureToggle & TypeOptions;
};
type ZodPlugin = DefinePlugin$1<UserConfig$1, Config, IApi>;
//#endregion
//#region src/generate.d.ts
/**
 * Generate a client from the provided configuration.
 *
 * @param userConfig User provided {@link UserConfig} configuration(s).
 */
declare function createClient(userConfig?: LazyOrAsync<MaybeArray<UserConfig>>, logger?: Logger$1): Promise<ReadonlyArray<Context>>;
//#endregion
//#region src/config/plugins.d.ts
/**
 * Default plugins used to generate artifacts if plugins aren't specified.
 */
declare const defaultPlugins: readonly ["@hey-api/typescript", "@hey-api/sdk"];
//#endregion
//#region src/plugins/@hey-api/client-core/config.d.ts
declare const clientDefaultConfig: {
  readonly baseUrl: true;
  readonly bundle: true;
  readonly includeInEntry: false;
};
declare const clientDefaultMeta: {
  readonly dependencies: readonly ["@hey-api/typescript"];
  readonly tags: readonly ["client"];
};
//#endregion
//#region src/plugins/@hey-api/client-core/plugin.d.ts
declare const clientPluginHandler: ({
  plugin
}: Parameters<PluginHandler>[0]) => void;
//#endregion
//#region src/index.d.ts
declare module '@hey-api/codegen-core' {
  interface ProjectRenderMeta {
    /**
     * If specified, this will be the file extension used when importing
     * other modules. By default, we don't add a file extension and let the
     * runtime resolve it.
     *
     * @default null
     */
    importFileExtension?: AnyString | null;
  }
  interface SymbolMeta {
    category?: 'client' | 'external' | 'hook' | 'schema' | 'sdk' | 'transform' | 'type' | 'utility' | AnyString;
    /**
     * Path to the resource this symbol represents.
     */
    path?: ReadonlyArray<string | number>;
    /**
     * Name of the plugin that registered this symbol.
     */
    pluginName?: string;
    resource?: 'client' | 'definition' | 'operation' | 'webhook' | AnyString;
    resourceId?: string;
    role?: 'data' | 'error' | 'errors' | 'options' | 'response' | 'responses' | AnyString;
    /**
     * Tags associated with this symbol.
     */
    tags?: ReadonlyArray<string>;
    tool?: 'angular' | 'arktype' | 'fastify' | 'json-schema' | 'sdk' | 'typescript' | 'valibot' | 'zod' | AnyString;
    variant?: 'container' | AnyString;
  }
}
declare module '@hey-api/shared' {
  interface PluginConfigMap {
    '@angular/common': AngularCommonPlugin['Types'];
    '@faker-js/faker': FakerJsFakerPlugin['Types'];
    '@hey-api/client-angular': HeyApiClientAngularPlugin['Types'];
    '@hey-api/client-axios': HeyApiClientAxiosPlugin['Types'];
    '@hey-api/client-fetch': HeyApiClientFetchPlugin['Types'];
    '@hey-api/client-ky': HeyApiClientKyPlugin['Types'];
    '@hey-api/client-next': HeyApiClientNextPlugin['Types'];
    '@hey-api/client-nuxt': HeyApiClientNuxtPlugin['Types'];
    '@hey-api/client-ofetch': HeyApiClientOfetchPlugin['Types'];
    '@hey-api/schemas': HeyApiSchemasPlugin['Types'];
    '@hey-api/sdk': HeyApiSdkPlugin['Types'];
    '@hey-api/transformers': HeyApiTransformersPlugin['Types'];
    '@hey-api/typescript': HeyApiTypeScriptPlugin['Types'];
    '@pinia/colada': PiniaColadaPlugin['Types'];
    '@tanstack/angular-query-experimental': TanStackAngularQueryPlugin['Types'];
    '@tanstack/react-query': TanStackReactQueryPlugin['Types'];
    '@tanstack/solid-query': TanStackSolidQueryPlugin['Types'];
    '@tanstack/svelte-query': TanStackSvelteQueryPlugin['Types'];
    '@tanstack/vue-query': TanStackVueQueryPlugin['Types'];
    arktype: ArktypePlugin['Types'];
    fastify: FastifyPlugin['Types'];
    swr: SwrPlugin['Types'];
    valibot: ValibotPlugin['Types'];
    zod: ZodPlugin['Types'];
  }
  interface PluginInstanceTypes {
    Node: TsDsl;
  }
}
/**
 * Type helper for configuration object, returns {@link MaybeArray<UserConfig>} object(s)
 */
declare function defineConfig(config: LazyOrAsync<ReadonlyArray<UserConfig>>): Promise<ReadonlyArray<UserConfig>>;
declare function defineConfig(config: LazyOrAsync<UserConfig>): Promise<UserConfig>;
//#endregion
export { $, type Client as AngularClient, type Client$1 as AxiosClient, type CallArgs, type Client$2 as Client, type DefinePlugin, DollarTsDsl, type ExampleOptions, type ExpressionTransformer, type Client$3 as FetchClient, type IR, Logger, type MaybeTsDsl, type Client$4 as NextClient, type Client$5 as NuxtClient, type Client$6 as OfetchClient, type OpenApi, type OpenApiMetaObject, type OpenApiOperationObject, type OpenApiParameterObject, type OpenApiRequestBodyObject, type OpenApiResponseObject, type OpenApiSchemaObject, OperationPath, OperationStrategy, type Plugin, TsDsl, TsDslContext, TypeScriptRenderer, type TypeTransformer, type TypeTsDsl, type UserConfig, clientDefaultConfig, clientDefaultMeta, clientPluginHandler, createClient, ctx, defaultPaginationKeywords, defaultPlugins, defineConfig, definePluginConfig, keywords, regexp, reserved, utils };
//# sourceMappingURL=index.d.mts.map