<div align="center">
  <img alt="Hey API presents openapi-ts" height="214" src="https://heyapi.dev/assets/.gen/openapi-ts-hero-640w.png" width="438">
  <h1><b>OpenAPI TypeScript</b></h1>
  <p><em>“OpenAPI codegen that just works.”</em><br/><sub>— Guillermo Rauch, CEO of Vercel</sub></p>
</div>

<p align="center">
  <a href="https://www.devtrends.dev/trends?c=v1.kZIBIg"><img src="https://api.devtrends.dev/badge/npm/%40hey-api%2Fopenapi-ts?period=month&style=flat&view=value" alt="DevTrends badge for @hey-api/openapi-ts" /></a>
  <a href="https://www.devtrends.dev/trends?c=v1.kZIBIg&v=change"><img src="https://api.devtrends.dev/badge/npm/%40hey-api%2Fopenapi-ts?period=year&style=flat&view=change" alt="DevTrends badge for @hey-api/openapi-ts" /></a>
  <a href="https://github.com/hey-api/openapi-ts/actions?query=branch%3Amain"><img src="https://github.com/hey-api/openapi-ts/actions/workflows/ci.yml/badge.svg?event=push&branch=main" alt="CI status" /></a>
  <a href="https://github.com/hey-api/openapi-ts"><img src="https://img.shields.io/github/stars/hey-api/openapi-ts?style=flat&logo=github&label=GitHub&color=54C82D" alt="GitHub stars" /></a>
  <a href="https://github.com/hey-api/openapi-ts/blob/main/LICENSE.md"><img src="https://img.shields.io/github/license/hey-api/openapi-ts" alt="MIT License"></a>
</p>

<p align="center">
  <a href="https://stackblitz.com/edit/hey-api-example?file=openapi-ts.config.ts,src%2Fclient%2Fschemas.gen.ts,src%2Fclient%2Fsdk.gen.ts,src%2Fclient%2Ftypes.gen.ts">Demo</a>
  <span>&nbsp;•&nbsp;</span>
  <a href="https://heyapi.dev">Manual</a>
  <span>&nbsp;•&nbsp;</span>
  <a href="https://github.com/hey-api/openapi-ts/issues">Issues</a>
  <span>&nbsp;•&nbsp;</span>
  <a href="https://heyapi.dev/openapi-ts/community/contributing">Contribute</a>
</p>

## About

The OpenAPI to TypeScript code generator used by Vercel, OpenCode, and PayPal.

Generate production-ready SDKs, Zod schemas, TanStack Query hooks, or choose from 20+ other plugins.

Part of the Hey API ecosystem.

## Features

- production-ready code that compiles
- runs in any Node.js 20+ environment
- accepts any OpenAPI specification
- core plugins for SDKs, types, and schemas
- HTTP clients for Fetch API, Angular, Axios, Next.js, Nuxt, and more
- 20+ plugins to reduce third-party boilerplate
- highly customizable via plugins
- [sync with Hey API Registry](https://heyapi.dev/openapi-ts/integrations) for spec management

## Contributing

Want to see your code in products used by millions?

Start with our [Contributing](https://heyapi.dev/openapi-ts/community/contributing) guide and release your first feature.

## Sponsors

Hey API is sponsor-funded. If you rely on Hey API in production, consider becoming a [sponsor](https://github.com/sponsors/hey-api) to accelerate the roadmap.

<h3 align="center">Gold</h3>

<table align="center" style="justify-content: center;align-items: center;display: flex;">
  <tbody>
    <tr>
      <td align="center" width="336px">
        <p></p>
        <p>
          <a href="https://kutt.it/pkEZyc" target="_blank">
            <picture height="50px">
              <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/.gen/stainless-logo-wordmark-480w.jpeg">
              <img alt="Stainless logo" height="50px" src="https://heyapi.dev/assets/.gen/stainless-logo-wordmark-480w.jpeg">
            </picture>
          </a>
          <br/>
          Best-in-class developer interfaces for your API.
          <br/>
          <a href="https://kutt.it/pkEZyc" style="text-decoration:none;" target="_blank">
            stainless.com
          </a>
        </p>
        <p></p>
      </td>
      <td align="center" width="336px">
        <p></p>
        <p>
          <a href="https://kutt.it/QM9Q2N" target="_blank">
            <picture height="50px">
              <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/opencode/logo-light.svg">
              <img alt="Opencode logo" height="50px" src="https://heyapi.dev/assets/opencode/logo-dark.svg">
            </picture>
          </a>
          <br/>
          The open source coding agent.
          <br/>
          <a href="https://kutt.it/QM9Q2N" style="text-decoration:none;" target="_blank">
            opencode.ai
          </a>
        </p>
        <p></p>
      </td>
    </tr>
    <tr>
      <td align="center" width="336px">
        <p></p>
        <p>
          <a href="https://kutt.it/6vrYy9" target="_blank">
            <picture height="50px">
              <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/mintlify/logo-light.svg">
              <img alt="Mintlify logo" height="50px" src="https://heyapi.dev/assets/mintlify/logo-dark.svg">
            </picture>
          </a>
          <br/>
          The intelligent knowledge platform.
          <br/>
          <a href="https://kutt.it/6vrYy9" style="text-decoration:none;" target="_blank">
            mintlify.com
          </a>
        </p>
        <p></p>
      </td>
    </tr>
  </tbody>
</table>

<h3 align="center">Silver</h3>

<table align="center" style="justify-content: center;align-items: center;display: flex;">
  <tbody>
    <tr>
      <td align="center" width="172px">
        <a href="https://kutt.it/skQUVd" target="_blank">
          <picture height="40px">
            <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/scalar/logo-light.svg">
            <img alt="Scalar logo" height="40px" src="https://heyapi.dev/assets/scalar/logo-dark.svg">
          </picture>
        </a>
        <br/>
        <a href="https://kutt.it/skQUVd" style="text-decoration:none;" target="_blank">
          scalar.com
        </a>
      </td>
      <td align="center" width="172px">
        <a href="https://kutt.it/Dr9GuW" target="_blank">
          <picture height="40px">
            <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/fastapi/logo-light.svg">
            <img alt="FastAPI logo" height="40px" src="https://heyapi.dev/assets/fastapi/logo-dark.svg">
          </picture>
        </a>
        <br/>
        <a href="https://kutt.it/Dr9GuW" style="text-decoration:none;" target="_blank">
          fastapi.tiangolo.com
        </a>
      </td>
    </tr>
  </tbody>
</table>

<h3 align="center">Bronze</h3>

<table align="center" style="justify-content: center;align-items: center;display: flex;">
  <tbody>
    <tr>
      <td align="center" width="136px">
        <a href="https://kutt.it/YpaKsX" target="_blank">
          <picture height="34px">
            <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/.gen/kinde-logo-wordmark-dark-480w.webp">
            <img alt="Kinde logo" height="34px" src="https://heyapi.dev/assets/.gen/kinde-logo-wordmark-480w.jpeg">
          </picture>
        </a>
      </td>
      <td align="center" width="136px">
        <a href="https://kutt.it/KkqSaw" target="_blank">
          <picture height="34px">
            <source media="(prefers-color-scheme: dark)" srcset="https://heyapi.dev/assets/cella/logo-light.svg">
            <img alt="Cella logo" height="34px" src="https://heyapi.dev/assets/cella/logo-dark.svg">
          </picture>
        </a>
      </td>
    </tr>
  </tbody>
</table>

## Quick Start

The fastest way to use `@hey-api/openapi-ts` is via npx

```sh
npx @hey-api/openapi-ts -i hey-api/backend -o src/client
```

Congratulations on creating your first client! 🎉 You can learn more about the generated files on the [Output](https://heyapi.dev/openapi-ts/output) page.

## Installation

You can download `@hey-api/openapi-ts` from npm using your favorite package manager.

#### npm

```sh
npm install @hey-api/openapi-ts -D -E
```

#### pnpm

```sh
pnpm add @hey-api/openapi-ts -D -E
```

#### yarn

```sh
yarn add @hey-api/openapi-ts -D -E
```

#### bun

```sh
bun add @hey-api/openapi-ts -D -E
```

### Versioning

This package is in [initial development](https://semver.org/#spec-item-4). Please pin an exact version so you can safely upgrade when you're ready.

We publish [migration notes](https://heyapi.dev/openapi-ts/migrating) for every breaking release. You might not be impacted by a breaking change if you don't use the affected features.

## Usage

### CLI

Most people run `@hey-api/openapi-ts` via CLI. To do that, add a script to your `package.json` file which will make `openapi-ts` executable through script.

```json
"scripts": {
  "openapi-ts": "openapi-ts"
}
```

The above script can be executed by running `npm run openapi-ts` or equivalent command in other package managers. Next, we will create a [configuration](https://heyapi.dev/openapi-ts/configuration) file and move our options from Quick Start to it.

### Node.js

You can also generate output programmatically by calling `createClient()` in a JavaScript/TypeScript file.

#### `script.ts`

```ts
import { createClient } from '@hey-api/openapi-ts';

createClient({
  input: 'hey-api/backend', // sign up at app.heyapi.dev
  output: 'src/client',
});
```

## Configuration

`@hey-api/openapi-ts` supports loading configuration from any file inside your project root folder supported by [jiti loader](https://github.com/unjs/c12?tab=readme-ov-file#-features). Below are the most common file formats.

#### `openapi-ts.config.ts`

```js
import { defineConfig } from '@hey-api/openapi-ts';

export default defineConfig({
  input: 'hey-api/backend', // sign up at app.heyapi.dev
  output: 'src/client',
});
```

#### `openapi-ts.config.cjs`

```js
/** @type {import('@hey-api/openapi-ts').UserConfig} */
module.exports = {
  input: 'hey-api/backend', // sign up at app.heyapi.dev
  output: 'src/client',
};
```

#### `openapi-ts.config.mjs`

```js
/** @type {import('@hey-api/openapi-ts').UserConfig} */
export default {
  input: 'hey-api/backend', // sign up at app.heyapi.dev
  output: 'src/client',
};
```

Alternatively, you can use `openapi-ts.config.js` and configure the export statement depending on your project setup.

### Input

You must set the input so we can load your OpenAPI specification. It can be a path or URL, object containing a path or URL, or an object representing an OpenAPI specification. Hey API supports all valid OpenAPI versions and file formats.

> If you use an HTTPS URL with a self-signed certificate in development, you will need to set [`NODE_TLS_REJECT_UNAUTHORIZED=0`](https://github.com/hey-api/openapi-ts/issues/276#issuecomment-2043143501) in your environment.

### Output

You must set the output so we know where to generate your files. It can be a path to the destination folder or an object containing the destination folder path and optional settings.

> You should treat the output folder as a dependency. Do not directly modify its contents as your changes might be erased when you run `@hey-api/openapi-ts` again.

## Parser

We parse your input before making it available to plugins. While configuring the parser is optional, it's the perfect place to modify or validate your input if needed.

## Plugins

Plugins are responsible for generating artifacts from your input. By default, Hey API will generate TypeScript interfaces and SDK from your OpenAPI specification. You can add, remove, or customize any of the plugins. In fact, we highly encourage you to do so!

### Client

Clients are responsible for sending the actual HTTP requests. Using clients is not required, but you must add a client to `plugins` if you're generating SDKs (we default to Fetch).

### Native Clients

- [`@hey-api/client-fetch`](https://heyapi.dev/openapi-ts/clients/fetch)
- [`@hey-api/client-angular`](https://heyapi.dev/openapi-ts/clients/angular)
- [`@hey-api/client-axios`](https://heyapi.dev/openapi-ts/clients/axios)
- [`@hey-api/client-ky`](https://heyapi.dev/openapi-ts/clients/ky)
- [`@hey-api/client-next`](https://heyapi.dev/openapi-ts/clients/next-js)
- [`@hey-api/client-nuxt`](https://heyapi.dev/openapi-ts/clients/nuxt)
- [`@hey-api/client-ofetch`](https://heyapi.dev/openapi-ts/clients/ofetch)

### Planned Clients

The following clients are planned but not in development yet. You can help us prioritize them by voting on [GitHub](https://github.com/hey-api/openapi-ts/labels/RSVP%20%F0%9F%91%8D%F0%9F%91%8E).

- [`@hey-api/client-effect`](https://heyapi.dev/openapi-ts/clients/effect)

Don't see your client? [Build your own](https://heyapi.dev/openapi-ts/clients/custom) or let us know your interest by [opening an issue](https://github.com/hey-api/openapi-ts/issues).

### Native Plugins

These plugins help reduce boilerplate associated with third-party dependencies. Hey API natively supports the most popular packages. Please open an issue on [GitHub](https://github.com/hey-api/openapi-ts/issues) if you'd like us to support your favorite package.

- [`@angular/common`](https://heyapi.dev/openapi-ts/plugins/angular)
- [`@hey-api/schemas`](https://heyapi.dev/openapi-ts/output/json-schema)
- [`@hey-api/sdk`](https://heyapi.dev/openapi-ts/output/sdk)
- [`@hey-api/transformers`](https://heyapi.dev/openapi-ts/transformers)
- [`@hey-api/typescript`](https://heyapi.dev/openapi-ts/output/typescript)
- [`@pinia/colada`](https://heyapi.dev/openapi-ts/plugins/pinia-colada)
- [`@tanstack/angular-query-experimental`](https://heyapi.dev/openapi-ts/plugins/tanstack-query)
- [`@tanstack/react-query`](https://heyapi.dev/openapi-ts/plugins/tanstack-query)
- [`@tanstack/solid-query`](https://heyapi.dev/openapi-ts/plugins/tanstack-query)
- [`@tanstack/svelte-query`](https://heyapi.dev/openapi-ts/plugins/tanstack-query)
- [`@tanstack/vue-query`](https://heyapi.dev/openapi-ts/plugins/tanstack-query)
- [`fastify`](https://heyapi.dev/openapi-ts/plugins/fastify)
- [`valibot`](https://heyapi.dev/openapi-ts/plugins/valibot)
- [`zod`](https://heyapi.dev/openapi-ts/plugins/zod)

### Planned Plugins

The following plugins are planned but not in development yet. You can help us prioritize them by voting on [GitHub](https://github.com/hey-api/openapi-ts/labels/RSVP%20%F0%9F%91%8D%F0%9F%91%8E).

- [Adonis](https://heyapi.dev/openapi-ts/plugins/adonis)
- [Ajv](https://heyapi.dev/openapi-ts/plugins/ajv)
- [Arktype](https://heyapi.dev/openapi-ts/plugins/arktype)
- [Chance](https://heyapi.dev/openapi-ts/plugins/chance)
- [Elysia](https://heyapi.dev/openapi-ts/plugins/elysia)
- [Express](https://heyapi.dev/openapi-ts/plugins/express)
- [Faker](https://heyapi.dev/openapi-ts/plugins/faker)
- [Falso](https://heyapi.dev/openapi-ts/plugins/falso)
- [Hono](https://heyapi.dev/openapi-ts/plugins/hono)
- [Joi](https://heyapi.dev/openapi-ts/plugins/joi)
- [Koa](https://heyapi.dev/openapi-ts/plugins/koa)
- [MSW](https://heyapi.dev/openapi-ts/plugins/msw)
- [Nest](https://heyapi.dev/openapi-ts/plugins/nest)
- [Nock](https://heyapi.dev/openapi-ts/plugins/nock)
- [Superstruct](https://heyapi.dev/openapi-ts/plugins/superstruct)
- [Supertest](https://heyapi.dev/openapi-ts/plugins/supertest)
- [SWR](https://heyapi.dev/openapi-ts/plugins/swr)
- [TypeBox](https://heyapi.dev/openapi-ts/plugins/typebox)
- [Yup](https://heyapi.dev/openapi-ts/plugins/yup)
- [Zustand](https://heyapi.dev/openapi-ts/plugins/zustand)

Don't see your plugin? [Build your own](https://heyapi.dev/openapi-ts/plugins/custom) or let us know your interest by [opening an issue](https://github.com/hey-api/openapi-ts/issues).

## Migrating

You can learn more on the [Migrating](https://heyapi.dev/openapi-ts/migrating) page.

## License

Released under the [MIT License](https://github.com/hey-api/openapi-ts/blob/main/LICENSE.md).
