/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

/**
 * MSAL-defined interaction required error code indicating no tokens are found in cache.
 * @public
 */
export const noTokensFound = "no_tokens_found";
/**
 * MSAL-defined error code indicating a native account is unavailable on the platform.
 * @public
 */
export const nativeAccountUnavailable = "native_account_unavailable";
/**
 * MSAL-defined error code indicating the refresh token has expired and user interaction is needed.
 * @public
 */
export const refreshTokenExpired = "refresh_token_expired";
/**
 * MSAL-defined error code indicating UI/UX is not allowed (e.g., blocked by policy), requiring alternate interaction.
 * @public
 */
export const uxNotAllowed = "ux_not_allowed";

/**
 * Server-originated error code indicating interaction is required to complete the request.
 * @public
 */
export const interactionRequired = "interaction_required";
/**
 * Server-originated error code indicating user consent is required.
 * @public
 */
export const consentRequired = "consent_required";
/**
 * Server-originated error code indicating user login is required.
 * @public
 */
export const loginRequired = "login_required";
/**
 * Server-originated error code indicating the token is invalid or corrupted.
 * @public
 */
export const badToken = "bad_token";
/**
 * Server-originated error code indicating the user was interrupted and must reattempt the flow.
 * @public
 */
export const interruptedUser = "interrupted_user";
