/**
 * MSAL-defined interaction required error code indicating no tokens are found in cache.
 * @public
 */
export declare const noTokensFound = "no_tokens_found";
/**
 * MSAL-defined error code indicating a native account is unavailable on the platform.
 * @public
 */
export declare const nativeAccountUnavailable = "native_account_unavailable";
/**
 * MSAL-defined error code indicating the refresh token has expired and user interaction is needed.
 * @public
 */
export declare const refreshTokenExpired = "refresh_token_expired";
/**
 * MSAL-defined error code indicating UI/UX is not allowed (e.g., blocked by policy), requiring alternate interaction.
 * @public
 */
export declare const uxNotAllowed = "ux_not_allowed";
/**
 * Server-originated error code indicating interaction is required to complete the request.
 * @public
 */
export declare const interactionRequired = "interaction_required";
/**
 * Server-originated error code indicating user consent is required.
 * @public
 */
export declare const consentRequired = "consent_required";
/**
 * Server-originated error code indicating user login is required.
 * @public
 */
export declare const loginRequired = "login_required";
/**
 * Server-originated error code indicating the token is invalid or corrupted.
 * @public
 */
export declare const badToken = "bad_token";
/**
 * Server-originated error code indicating the user was interrupted and must reattempt the flow.
 * @public
 */
export declare const interruptedUser = "interrupted_user";
//# sourceMappingURL=InteractionRequiredAuthErrorCodes.d.ts.map