/*! @azure/msal-common v15.15.0 2026-02-23 */
'use strict';
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * MSAL-defined interaction required error code indicating no tokens are found in cache.
 * @public
 */
const noTokensFound = "no_tokens_found";
/**
 * MSAL-defined error code indicating a native account is unavailable on the platform.
 * @public
 */
const nativeAccountUnavailable = "native_account_unavailable";
/**
 * MSAL-defined error code indicating the refresh token has expired and user interaction is needed.
 * @public
 */
const refreshTokenExpired = "refresh_token_expired";
/**
 * MSAL-defined error code indicating UI/UX is not allowed (e.g., blocked by policy), requiring alternate interaction.
 * @public
 */
const uxNotAllowed = "ux_not_allowed";
/**
 * Server-originated error code indicating interaction is required to complete the request.
 * @public
 */
const interactionRequired = "interaction_required";
/**
 * Server-originated error code indicating user consent is required.
 * @public
 */
const consentRequired = "consent_required";
/**
 * Server-originated error code indicating user login is required.
 * @public
 */
const loginRequired = "login_required";
/**
 * Server-originated error code indicating the token is invalid or corrupted.
 * @public
 */
const badToken = "bad_token";
/**
 * Server-originated error code indicating the user was interrupted and must reattempt the flow.
 * @public
 */
const interruptedUser = "interrupted_user";

export { badToken, consentRequired, interactionRequired, interruptedUser, loginRequired, nativeAccountUnavailable, noTokensFound, refreshTokenExpired, uxNotAllowed };
//# sourceMappingURL=InteractionRequiredAuthErrorCodes.mjs.map
