/*! @azure/msal-browser v4.29.0 2026-02-23 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { SIGN_UP_FAILED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Represents the state of a sign-up operation that has failed.
 */
class SignUpFailedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_UP_FAILED_STATE_TYPE;
    }
}

export { SignUpFailedState };
//# sourceMappingURL=SignUpFailedState.mjs.map
