/*! @azure/msal-browser v4.29.0 2026-02-23 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { SIGN_IN_COMPLETED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Represents the completed state of the sign-in operation.
 * This state indicates that the sign-in process has finished successfully.
 */
class SignInCompletedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_IN_COMPLETED_STATE_TYPE;
    }
}

export { SignInCompletedState };
//# sourceMappingURL=SignInCompletedState.mjs.map
