const { promises: fs } = require('fs');

const camelCase = (attribute) => {
  const words = attribute.toUpperCase().replace('/', '-').split('-');
  return words.join('_');
};

(async () => {
  const files = await fs.readdir('./dictionaries', 'utf8');
  const dictionaries = {
    all: {
      file: 'node_modules/node-radius-utils/dictionaries/dictionary',
    },
  };
  await Promise.all(files.map(async (file) => {
    if (file.startsWith('dictionary.')) {
      const name = file.split('.').slice(1).join('_');
      dictionaries[name] = {
        file: `node_modules/node-radius-utils/dictionaries/${file}`,
        attributes: {},
        values: {},
      };
      const contents = await fs.readFile(`./dictionaries/${file}`, 'utf8');
      contents.split('\n').forEach((line) => {
        if (line.startsWith('ATTRIBUTE')) {
          const attribute = line.split(/\s+/g)[1];
          const camelCaseAttribute = camelCase(attribute);
          dictionaries[name].attributes[camelCaseAttribute] = attribute;
        } else if (line.startsWith('VALUE')) {
          const [_, type, value] = line.split(/\s+/g);
          const camelCaseType = camelCase(type);
          const camelCaseValue = camelCase(value);
          dictionaries[name].values[camelCaseType] = dictionaries[name].values[camelCaseType] || { value: type };
          dictionaries[name].values[camelCaseType][camelCaseValue] = value;
        }
      });
    }
  }));
  fs.writeFile('./src/dictionaries.json', JSON.stringify(dictionaries, null, 2), 'utf8');
})();
