export declare const ed448: import("./abstract/edwards.js").CurveFn;
export declare const ed448ph: import("./abstract/edwards.js").CurveFn;
export declare const x448: import("./abstract/montgomery.js").CurveFn;
/**
 * Converts edwards448 public key to x448 public key. Uses formula:
 * * `(u, v) = ((y-1)/(y+1), sqrt(156324)*u/x)`
 * * `(x, y) = (sqrt(156324)*u/v, (1+u)/(1-u))`
 * @example
 *   const aPub = ed448.getPublicKey(utils.randomPrivateKey());
 *   x448.getSharedSecret(edwardsToMontgomery(aPub), edwardsToMontgomery(someonesPub))
 */
export declare function edwardsToMontgomeryPub(edwardsPub: string | Uint8Array): Uint8Array;
export declare const edwardsToMontgomery: typeof edwardsToMontgomeryPub;
export declare const hashToCurve: (msg: Uint8Array, options?: import("./abstract/hash-to-curve.js").htfBasicOpts | undefined) => import("./abstract/hash-to-curve.js").H2CPoint<bigint>;
export declare const encodeToCurve: (msg: Uint8Array, options?: import("./abstract/hash-to-curve.js").htfBasicOpts | undefined) => import("./abstract/hash-to-curve.js").H2CPoint<bigint>;
//# sourceMappingURL=ed448.d.ts.map