## ❗ Important Announcements

<details><summary>Click here for more details:</summary>
</p>

**⚠️ Please Note: We do not accept all types of pull requests, and we want to ensure we don’t waste your time. Before submitting, make sure you have read our pull request guidelines: [Pull Request Rules](https://github.com/louislam/uptime-kuma/blob/master/CONTRIBUTING.md#can-i-create-a-pull-request-for-uptime-kuma)**

### 🚫 Please Avoid Unnecessary Pinging of Maintainers

We kindly ask you to refrain from pinging maintainers unless absolutely necessary. Pings are for critical/urgent pull requests that require immediate attention.

</p>
</details>

## 📋 Overview

<!-- Provide a clear summary of the purpose and scope of this pull request:-->

- **What problem does this pull request address?**
  - Please provide a detailed explanation here.
- **What features or functionality does this pull request introduce or enhance?**
  - Please provide a detailed explanation here.

<!--
Please link any GitHub issues or tasks that this pull request addresses.
Use the appropriate issue numbers or links to enable auto-closing.
-->

- Relates to #issue-number
- Resolves #issue-number

## 🛠️ Type of change

<!-- Please select all options that apply -->

- [ ] 🐛 Bugfix (a non-breaking change that resolves an issue)
- [ ] ✨ New feature (a non-breaking change that adds new functionality)
- [ ] ⚠️ Breaking change (a fix or feature that alters existing functionality in a way that could cause issues)
- [ ] 🎨 User Interface (UI) updates
- [ ] 📄 New Documentation (addition of new documentation)
- [ ] 📄 Documentation Update (modification of existing documentation)
- [ ] 📄 Documentation Update Required (the change requires updates to related documentation)
- [ ] 🔧 Other (please specify):
  - Provide additional details here.

## 📄 Checklist

<!-- Please select all options that apply -->

- [ ] 🔍 My code adheres to the style guidelines of this project.
- [ ] 🦿 I have indicated where (if any) I used an LLM for the contributions
- [ ] ✅ I ran ESLint and other code linters for modified files.
- [ ] 🛠️ I have reviewed and tested my code.
- [ ] 📝 I have commented my code, especially in hard-to-understand areas (e.g., using JSDoc for methods).
- [ ] ⚠️ My changes generate no new warnings.
- [ ] 🤖 My code needed automated testing. I have added them (this is an optional task).
- [ ] 📄 Documentation updates are included (if applicable).
- [ ] 🔒 I have considered potential security impacts and mitigated risks.
- [ ] 🧰 Dependency updates are listed and explained.
- [ ] 📚 I have read and understood the [Pull Request guidelines](https://github.com/louislam/uptime-kuma/blob/master/CONTRIBUTING.md#recommended-pull-request-guideline).

## 📷 Screenshots or Visual Changes

<!--
If this pull request introduces visual changes, please provide the following details.
If not, remove this section.

Please upload the image directly here by pasting it or dragging and dropping.
Avoid using external image services as the image will be uploaded automatically.
-->

- **UI Modifications**: Highlight any changes made to the user interface.
- **Before & After**: Include screenshots or comparisons (if applicable).

| Event              | Before                | After                |
| ------------------ | --------------------- | -------------------- |
| `UP`               | ![Before](image-link) | ![After](image-link) |
| `DOWN`             | ![Before](image-link) | ![After](image-link) |
| Certificate-expiry | ![Before](image-link) | ![After](image-link) |
| Testing            | ![Before](image-link) | ![After](image-link) |
