/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.telemetry.apm.internal.APMMeterService;
import org.elasticsearch.telemetry.apm.internal.APMTelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.tracing.APMTracer;

public class APMAgentSettings {
    private static final Logger LOGGER = LogManager.getLogger(APMAgentSettings.class);
    private static final String TELEMETRY_SETTING_PREFIX = "telemetry.";
    private static final String LEGACY_TRACING_APM_SETTING_PREFIX = "tracing.apm.";
    public static final Set<String> PERMITTED_AGENT_KEYS = Set.of("circuit_breaker_enabled", "stress_monitoring_interval", "stress_monitor_gc_stress_threshold", "stress_monitor_gc_relief_threshold", "stress_monitor_cpu_duration_threshold", "stress_monitor_system_cpu_stress_threshold", "stress_monitor_system_cpu_relief_threshold", "service_name", "service_node_name", "hostname", "environment", "transaction_sample_rate", "transaction_max_spans", "long_field_max_length", "sanitize_field_names", "enable_instrumentations", "disable_instrumentations", "unnest_exceptions", "ignore_exceptions", "capture_body", "capture_headers", "global_labels", "instrument_ancient_bytecode", "context_propagation_only", "classes_excluded_from_instrumentation", "trace_methods", "trace_methods_duration_threshold", "breakdown_metrics", "plugins_dir", "use_elastic_traceparent_header", "disable_outgoing_tracecontext_headers", "span_min_duration", "cloud_provider", "enable_public_api_annotation_inheritance", "transaction_name_groups", "trace_continuation_strategy", "baggage_to_attach", "capture_body_content_types", "transaction_ignore_urls", "transaction_ignore_user_agents", "use_path_as_transaction_name", "span_compression_enabled", "span_compression_exact_match_max_duration", "span_compression_same_kind_max_duration", "exit_span_min_duration", "capture_jmx_metrics", "log_level", "log_ecs_reformatting", "log_ecs_reformatting_additional_fields", "log_ecs_formatter_allow_list", "log_file_size", "log_sending", "dedot_custom_metrics", "custom_metrics_histogram_boundaries", "metric_set_limit", "agent_reporter_health_metrics", "agent_background_overhead_metrics", "profiling_inferred_spans_enabled", "profiling_inferred_spans_logging_enabled", "profiling_inferred_spans_sampling_interval", "profiling_inferred_spans_min_duration", "profiling_inferred_spans_included_classes", "profiling_inferred_spans_excluded_classes", "profiling_inferred_spans_lib_directory", "server_url", "server_urls", "disable_send", "server_timeout", "verify_server_cert", "max_queue_size", "include_process_args", "api_request_time", "api_request_size", "metrics_interval", "disable_metrics", "aws_lambda_handler", "data_flush_timeout", "application_packages", "stack_trace_limit", "span_stack_trace_min_duration");
    public static final Setting.AffixSetting<String> APM_AGENT_SETTINGS = Setting.prefixKeySetting((String)"telemetry.agent.", (String)"tracing.apm.agent.", (namespace, qualifiedKey) -> qualifiedKey.startsWith(LEGACY_TRACING_APM_SETTING_PREFIX) ? APMAgentSettings.concreteAgentSetting(namespace, qualifiedKey, Setting.Property.NodeScope, Setting.Property.OperatorDynamic, Setting.Property.Deprecated) : APMAgentSettings.concreteAgentSetting(namespace, qualifiedKey, Setting.Property.NodeScope, Setting.Property.OperatorDynamic));
    @Deprecated
    public static final Setting<List<String>> TRACING_APM_NAMES_INCLUDE_SETTING = Setting.stringListSetting((String)"tracing.apm.names.include", (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<List<String>> TELEMETRY_TRACING_NAMES_INCLUDE_SETTING = Setting.listSetting((String)"telemetry.tracing.names.include", TRACING_APM_NAMES_INCLUDE_SETTING, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    @Deprecated
    public static final Setting<List<String>> TRACING_APM_NAMES_EXCLUDE_SETTING = Setting.stringListSetting((String)"tracing.apm.names.exclude", (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<List<String>> TELEMETRY_TRACING_NAMES_EXCLUDE_SETTING = Setting.listSetting((String)"telemetry.tracing.names.exclude", TRACING_APM_NAMES_EXCLUDE_SETTING, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    @Deprecated
    public static final Setting<List<String>> TRACING_APM_SANITIZE_FIELD_NAMES = Setting.stringListSetting((String)"tracing.apm.sanitize_field_names", List.of("password", "passwd", "pwd", "secret", "*key", "*token*", "*session*", "*credit*", "*card*", "*auth*", "*principal*", "set-cookie"), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<List<String>> TELEMETRY_TRACING_SANITIZE_FIELD_NAMES = Setting.listSetting((String)"telemetry.tracing.sanitize_field_names", TRACING_APM_SANITIZE_FIELD_NAMES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    @Deprecated
    public static final Setting<Boolean> TRACING_APM_ENABLED_SETTING = Setting.boolSetting((String)"tracing.apm.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<Boolean> TELEMETRY_TRACING_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.tracing.enabled", TRACING_APM_ENABLED_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> TELEMETRY_METRICS_ENABLED_SETTING = Setting.boolSetting((String)"telemetry.metrics.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    @Deprecated
    public static final Setting<SecureString> TRACING_APM_SECRET_TOKEN_SETTING = SecureSetting.secureString((String)"tracing.apm.secret_token", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated});
    public static final Setting<SecureString> TELEMETRY_SECRET_TOKEN_SETTING = SecureSetting.secureString((String)"telemetry.secret_token", TRACING_APM_SECRET_TOKEN_SETTING, (Setting.Property[])new Setting.Property[0]);
    @Deprecated
    public static final Setting<SecureString> TRACING_APM_API_KEY_SETTING = SecureSetting.secureString((String)"tracing.apm.api_key", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated});
    public static final Setting<SecureString> TELEMETRY_API_KEY_SETTING = SecureSetting.secureString((String)"telemetry.api_key", TRACING_APM_API_KEY_SETTING, (Setting.Property[])new Setting.Property[0]);

    public void addClusterSettingsListeners(ClusterService clusterService, APMTelemetryProvider apmTelemetryProvider) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        APMTracer apmTracer = apmTelemetryProvider.getTracer();
        APMMeterService apmMeterService = apmTelemetryProvider.getMeterService();
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_TRACING_ENABLED_SETTING, enabled -> {
            apmTracer.setEnabled((boolean)enabled);
            boolean recording = enabled != false || (Boolean)clusterSettings.get(TELEMETRY_METRICS_ENABLED_SETTING) != false;
            this.setAgentSetting("recording", Boolean.toString(recording));
        });
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_METRICS_ENABLED_SETTING, enabled -> {
            apmMeterService.setEnabled((boolean)enabled);
            boolean recording = enabled != false || (Boolean)clusterSettings.get(TELEMETRY_TRACING_ENABLED_SETTING) != false;
            this.setAgentSetting("recording", Boolean.toString(recording));
        });
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_TRACING_NAMES_INCLUDE_SETTING, apmTracer::setIncludeNames);
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_TRACING_NAMES_EXCLUDE_SETTING, apmTracer::setExcludeNames);
        clusterSettings.addSettingsUpdateConsumer(TELEMETRY_TRACING_SANITIZE_FIELD_NAMES, apmTracer::setLabelFilters);
        clusterSettings.addAffixMapUpdateConsumer(APM_AGENT_SETTINGS, map -> map.forEach(this::setAgentSetting), (x, y) -> {});
    }

    public void initAgentSystemProperties(Settings settings) {
        boolean tracing = (Boolean)TELEMETRY_TRACING_ENABLED_SETTING.get(settings);
        boolean metrics = (Boolean)TELEMETRY_METRICS_ENABLED_SETTING.get(settings);
        this.setAgentSetting("recording", Boolean.toString(tracing || metrics));
        APM_AGENT_SETTINGS.getAsMap(settings).forEach(this::setAgentSetting);
    }

    @SuppressForbidden(reason="Need to be able to manipulate APM agent-related properties to set them dynamically")
    public void setAgentSetting(String key, String value) {
        if (key.startsWith("global_labels.")) {
            return;
        }
        String completeKey = "elastic.apm." + Objects.requireNonNull(key);
        if (value == null || value.isEmpty()) {
            LOGGER.trace("Clearing system property [{}]", (Object)completeKey);
            System.clearProperty(completeKey);
        } else {
            LOGGER.trace("Setting setting property [{}] to [{}]", (Object)completeKey, (Object)value);
            System.setProperty(completeKey, value);
        }
    }

    private static Setting<String> concreteAgentSetting(String namespace, String qualifiedKey, Setting.Property ... properties) {
        return new Setting(qualifiedKey, "", value -> {
            if (!qualifiedKey.equals("_na_") && !PERMITTED_AGENT_KEYS.contains(namespace)) {
                if (namespace.startsWith("global_labels.")) {
                    return value;
                }
                throw new IllegalArgumentException("Configuration [" + qualifiedKey + "] is either prohibited or unknown.");
            }
            return value;
        }, properties);
    }
}

