/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.server.cli.JvmOption;
import org.elasticsearch.server.cli.SystemMemoryInfo;

public class MachineDependentHeap {
    protected static final long GB = 0x40000000L;
    protected static final long MAX_HEAP_SIZE = 0x7C0000000L;
    protected static final long MIN_HEAP_SIZE = 0x8000000L;
    private static final FeatureFlag NEW_ML_MEMORY_COMPUTATION_FEATURE_FLAG = new FeatureFlag("new_ml_memory_computation");

    public final List<String> determineHeapSettings(Settings nodeSettings, SystemMemoryInfo systemMemoryInfo, List<String> userDefinedJvmOptions) throws IOException, InterruptedException {
        Map<String, JvmOption> finalJvmOptions = JvmOption.findFinalOptions(userDefinedJvmOptions);
        if (JvmOption.isMaxHeapSpecified(finalJvmOptions) || JvmOption.isMinHeapSpecified(finalJvmOptions) || JvmOption.isInitialHeapSpecified(finalJvmOptions)) {
            return Collections.emptyList();
        }
        List roles = (List)NodeRoleSettings.NODE_ROLES_SETTING.get(nodeSettings);
        long availableSystemMemory = systemMemoryInfo.availableSystemMemory();
        MachineNodeRole nodeRole = MachineDependentHeap.mapNodeRole(roles);
        return MachineDependentHeap.options(this.getHeapSizeMb(nodeSettings, nodeRole, availableSystemMemory));
    }

    protected int getHeapSizeMb(Settings nodeSettings, MachineNodeRole role, long availableMemory) {
        return switch (role) {
            default -> throw new IncompatibleClassChangeError();
            case MachineNodeRole.MASTER_ONLY -> MachineDependentHeap.mb(Math.min((long)((double)availableMemory * 0.6), 0x7C0000000L));
            case MachineNodeRole.ML_ONLY -> {
                double heapFractionBelow16GB = 0.4;
                double heapFractionAbove16GB = 0.1;
                if (NEW_ML_MEMORY_COMPUTATION_FEATURE_FLAG.isEnabled()) {
                    heapFractionBelow16GB = 0.26666666666666666;
                    heapFractionAbove16GB = 0.06666666666666667;
                }
                if (availableMemory <= 0x400000000L) {
                    yield MachineDependentHeap.mb((long)((double)availableMemory * heapFractionBelow16GB), 4);
                }
                yield MachineDependentHeap.mb((long)Math.min(1.7179869184E10 * heapFractionBelow16GB + (double)(availableMemory - 0x400000000L) * heapFractionAbove16GB, 3.3285996544E10), 4);
            }
            case MachineNodeRole.DATA -> availableMemory < 0x40000000L ? MachineDependentHeap.mb(Math.max((long)((double)availableMemory * 0.4), 0x8000000L)) : MachineDependentHeap.mb(Math.min((long)((double)availableMemory * 0.5), 0x7C0000000L));
        };
    }

    protected static int mb(long bytes) {
        return (int)(bytes / 0x100000L);
    }

    protected static int mb(long bytes, int toLowerMultipleOfMb) {
        return toLowerMultipleOfMb * (int)(bytes / (long)(0x100000 * toLowerMultipleOfMb));
    }

    private static MachineNodeRole mapNodeRole(List<DiscoveryNodeRole> roles) {
        if (roles.isEmpty()) {
            return MachineNodeRole.DATA;
        }
        if (MachineDependentHeap.containsOnly(roles, DiscoveryNodeRole.MASTER_ROLE)) {
            return MachineNodeRole.MASTER_ONLY;
        }
        if (roles.contains(DiscoveryNodeRole.ML_ROLE) && MachineDependentHeap.containsOnly(roles, DiscoveryNodeRole.ML_ROLE, DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE)) {
            return MachineNodeRole.ML_ONLY;
        }
        return MachineNodeRole.DATA;
    }

    private static <T> boolean containsOnly(Collection<T> collection, T ... items) {
        return Arrays.asList(items).containsAll(collection);
    }

    private static List<String> options(int heapSize) {
        return List.of("-Xms" + heapSize + "m", "-Xmx" + heapSize + "m");
    }

    protected static enum MachineNodeRole {
        MASTER_ONLY,
        ML_ONLY,
        DATA;

    }
}

