/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;

public class Shutdowner {
    public static void main(String[] args) {
        try {
            new Shutdowner().run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    void run() throws IOException {
        File homeDir = Shutdowner.detectHomeDir();
        Properties p = Shutdowner.loadPropertiesFile(homeDir);
        File tmpDir = Shutdowner.resolveTempDir(p);
        Shutdowner.askForHardStop(tmpDir);
    }

    static File detectHomeDir() {
        try {
            File appJar = new File(Shutdowner.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            return appJar.getParentFile().getParentFile();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot detect path of shutdowner jar file", e);
        }
    }

    static Properties loadPropertiesFile(File homeDir) {
        Properties p = new Properties();
        File propsFile = new File(new File(homeDir, "conf"), "sonar.properties");
        if (propsFile.exists()) {
            Properties properties;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8);
            try {
                p.load(reader);
                properties = p;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot open file " + String.valueOf(propsFile), e);
                }
            }
            ((Reader)reader).close();
            return properties;
        }
        throw new IllegalStateException("Configuration file not found: " + String.valueOf(propsFile));
    }

    static File resolveTempDir(Properties p) {
        return new File(Optional.ofNullable(p.getProperty("sonar.path.temp")).orElse("temp"));
    }

    static void askForHardStop(File tmpDir) throws IOException {
        Shutdowner.writeToShareMemory(tmpDir, 1, (byte)-1);
    }

    private static void writeToShareMemory(File tmpDir, int offset, byte value) throws IOException {
        try (RandomAccessFile sharedMemory = new RandomAccessFile(new File(tmpDir, "sharedmemory"), "rw");){
            MappedByteBuffer mappedByteBuffer = sharedMemory.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 500L);
            mappedByteBuffer.put(offset, value);
        }
    }
}

