/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.mistral.MistralCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.mistral.MistralEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.mistral.action.MistralActionVisitor;
import org.elasticsearch.xpack.inference.services.mistral.completion.MistralChatCompletionModel;
import org.elasticsearch.xpack.inference.services.mistral.embeddings.MistralEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.mistral.request.completion.MistralChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class MistralActionCreator
implements MistralActionVisitor {
    public static final String COMPLETION_ERROR_PREFIX = "Mistral completions";
    static final String USER_ROLE = "user";
    static final ResponseHandler COMPLETION_HANDLER = new MistralCompletionResponseHandler("mistral completions", OpenAiChatCompletionResponseEntity::fromResponse);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public MistralActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(MistralEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        MistralEmbeddingsRequestManager requestManager = new MistralEmbeddingsRequestManager(embeddingsModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = MistralActionCreator.buildErrorMessage(TaskType.TEXT_EMBEDDING, embeddingsModel.getInferenceEntityId());
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(MistralChatCompletionModel chatCompletionModel) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), chatCompletionModel, COMPLETION_HANDLER, inputs -> new MistralChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), chatCompletionModel), ChatCompletionInput.class);
        String errorMessage = MistralActionCreator.buildErrorMessage(TaskType.COMPLETION, chatCompletionModel.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)"Failed to send Mistral %s request from inference entity id [%s]", (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

