/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.rerank;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class HuggingFaceRerankServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
HuggingFaceRateLimitServiceSettings {
    public static final String NAME = "hugging_face_rerank_service_settings";
    public static final String URL = "url";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    private static final TransportVersion ML_INFERENCE_HUGGING_FACE_RERANK_ADDED = TransportVersion.fromName((String)"ml_inference_sagemaker_chat_completion");
    private final URI uri;
    private final RateLimitSettings rateLimitSettings;

    public static HuggingFaceRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        URI uri = HuggingFaceServiceSettings.extractUri(map, URL, validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "hugging_face", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new HuggingFaceRerankServiceSettings(uri, rateLimitSettings);
    }

    public HuggingFaceRerankServiceSettings(String url) {
        this.uri = ServiceUtils.createUri(url);
        this.rateLimitSettings = DEFAULT_RATE_LIMIT_SETTINGS;
    }

    HuggingFaceRerankServiceSettings(URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        this.uri = Objects.requireNonNull(uri);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public HuggingFaceRerankServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createUri(in.readString());
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public String modelId() {
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(URL, this.uri.toString());
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_HUGGING_FACE_RERANK_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HuggingFaceRerankServiceSettings that = (HuggingFaceRerankServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.rateLimitSettings);
    }
}

