/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleDiscoveryEngineRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GoogleVertexAiChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GoogleDiscoveryEngineRateLimitServiceSettings {
    public static final String NAME = "google_vertex_ai_chatcompletion_service_settings";
    private static final TransportVersion ML_INFERENCE_VERTEXAI_CHATCOMPLETION_ADDED = TransportVersion.fromName((String)"ml_inference_vertexai_chatcompletion_added");
    private final String location;
    private final String modelId;
    private final String projectId;
    private final RateLimitSettings rateLimitSettings;
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1000L);

    public GoogleVertexAiChatCompletionServiceSettings(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readString(), new RateLimitSettings(in));
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("project_id", this.projectId);
        builder.field("location", this.location);
        builder.field("model_id", this.modelId);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public static GoogleVertexAiChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String projectId = ServiceUtils.extractRequiredString(map, "project_id", "service_settings", validationException);
        String location = ServiceUtils.extractRequiredString(map, "location", "service_settings", validationException);
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "googlevertexai", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiChatCompletionServiceSettings(projectId, location, modelId, rateLimitSettings);
    }

    public GoogleVertexAiChatCompletionServiceSettings(String projectId, String location, String modelId, @Nullable RateLimitSettings rateLimitSettings) {
        this.projectId = projectId;
        this.location = location;
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public String location() {
        return this.location;
    }

    public String modelId() {
        return this.modelId;
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_VERTEXAI_CHATCOMPLETION_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.projectId);
        out.writeString(this.location);
        out.writeString(this.modelId);
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleVertexAiChatCompletionServiceSettings that = (GoogleVertexAiChatCompletionServiceSettings)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.modelId, this.projectId, this.rateLimitSettings);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }
}

