/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public final class ServiceUtils {
    public static final EnumSet<InputType> VALID_INTERNAL_INPUT_TYPE_VALUES = EnumSet.of(InputType.INTERNAL_INGEST, InputType.INTERNAL_SEARCH);

    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type) {
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new ElasticsearchStatusException(ServiceUtils.invalidTypeErrorMsg(key, o, type.getSimpleName()), RestStatus.BAD_REQUEST, new Object[0]);
    }

    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type, ValidationException validationException) {
        if (sourceMap == null) {
            validationException.addValidationError(Strings.format((String)"Encountered a null input map while parsing field [%s]", (Object[])new Object[]{key}));
            return null;
        }
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        validationException.addValidationError(ServiceUtils.invalidTypeErrorMsg(key, o, type.getSimpleName()));
        return null;
    }

    public static Object removeAsOneOfTypes(Map<String, Object> sourceMap, String key, List<Class<?>> types, ValidationException validationException) {
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(o.getClass())) continue;
            return type.cast(o);
        }
        validationException.addValidationError(ServiceUtils.invalidTypesErrorMsg(key, o, types.stream().map(Class::getSimpleName).collect(Collectors.toList())));
        return null;
    }

    public static AdaptiveAllocationsSettings removeAsAdaptiveAllocationsSettings(Map<String, Object> sourceMap, String key, ValidationException validationException) {
        Map<String, Object> settingsMap = ServiceUtils.removeFromMap(sourceMap, key);
        if (settingsMap == null) {
            return null;
        }
        AdaptiveAllocationsSettings settings = new AdaptiveAllocationsSettings(ServiceUtils.removeAsType(settingsMap, AdaptiveAllocationsSettings.ENABLED.getPreferredName(), Boolean.class, validationException), ServiceUtils.removeAsType(settingsMap, AdaptiveAllocationsSettings.MIN_NUMBER_OF_ALLOCATIONS.getPreferredName(), Integer.class, validationException), ServiceUtils.removeAsType(settingsMap, AdaptiveAllocationsSettings.MAX_NUMBER_OF_ALLOCATIONS.getPreferredName(), Integer.class, validationException));
        for (String settingName : settingsMap.keySet()) {
            validationException.addValidationError(ServiceUtils.invalidSettingError(settingName, key));
        }
        ActionRequestValidationException exception = settings.validate();
        if (exception != null) {
            validationException.addValidationErrors((Iterable)exception.validationErrors());
        }
        return settings;
    }

    public static Map<String, Object> removeFromMap(Map<String, Object> sourceMap, String fieldName) {
        return (Map)sourceMap.remove(fieldName);
    }

    public static Map<String, Object> removeFromMapOrThrowIfNull(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{fieldName});
        }
        return value;
    }

    public static Map<String, Object> removeFromMapOrDefaultEmpty(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            return new HashMap<String, Object>();
        }
        return value;
    }

    public static String removeStringOrThrowIfNull(Map<String, Object> sourceMap, String key) {
        String value = ServiceUtils.removeAsType(sourceMap, key, String.class);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{key});
        }
        return value;
    }

    public static void throwIfNotEmptyMap(Map<String, Object> settingsMap, String serviceName) {
        if (settingsMap != null && !settingsMap.isEmpty()) {
            throw ServiceUtils.unknownSettingsError(settingsMap, serviceName);
        }
    }

    public static void throwIfNotEmptyMap(Map<String, Object> settingsMap, String field, String scope) {
        if (settingsMap != null && !settingsMap.isEmpty()) {
            throw ServiceUtils.unknownSettingsError(settingsMap, field, scope);
        }
    }

    public static ElasticsearchStatusException unknownSettingsError(Map<String, Object> config, String serviceName) {
        return new ElasticsearchStatusException("Configuration contains settings [{}] unknown to the [{}] service", RestStatus.BAD_REQUEST, new Object[]{config, serviceName});
    }

    public static ElasticsearchStatusException unknownSettingsError(Map<String, Object> config, String field, String scope) {
        return new ElasticsearchStatusException("Configuration contains unknown settings [{}] while parsing field [{}] for settings [{}]", RestStatus.BAD_REQUEST, new Object[]{config, field, scope});
    }

    public static ElasticsearchStatusException invalidModelTypeForUpdateModelWithEmbeddingDetails(Class<? extends Model> invalidModelType) {
        throw new ElasticsearchStatusException(Strings.format((String)"Can't update embedding details for model with unexpected type %s", (Object[])new Object[]{invalidModelType}), RestStatus.BAD_REQUEST, new Object[0]);
    }

    public static ElasticsearchStatusException invalidModelTypeForUpdateModelWithChatCompletionDetails(Class<? extends Model> invalidModelType) {
        throw new ElasticsearchStatusException(Strings.format((String)"Can't update chat completion details for model with unexpected type %s", (Object[])new Object[]{invalidModelType}), RestStatus.BAD_REQUEST, new Object[0]);
    }

    public static String missingSettingErrorMsg(String settingName, String scope) {
        return Strings.format((String)"[%s] does not contain the required setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static String missingOneOfSettingsErrorMsg(List<String> settingNames, String scope) {
        return Strings.format((String)"[%s] does not contain one of the required settings [%s]", (Object[])new Object[]{scope, String.join((CharSequence)", ", settingNames)});
    }

    public static String invalidTypeErrorMsg(String settingName, Object foundObject, String expectedType) {
        return Strings.format((String)"field [%s] is not of the expected type. The value [%s] cannot be converted to a [%s]", (Object[])new Object[]{settingName, foundObject, expectedType});
    }

    public static String invalidTypesErrorMsg(String settingName, Object foundObject, List<String> expectedTypes) {
        return Strings.format((String)"field [%s] is not of one of the expected types. The value [%s] cannot be converted to one of %s", (Object[])new Object[]{settingName, foundObject, expectedTypes});
    }

    public static String invalidUrlErrorMsg(String url, String settingName, String settingScope, String error) {
        return Strings.format((String)"[%s] Invalid url [%s] received for field [%s]. Error: %s", (Object[])new Object[]{settingScope, url, settingName, error});
    }

    public static String mustBeNonEmptyString(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty string. [%s] must be a non-empty string", (Object[])new Object[]{scope, settingName});
    }

    public static String mustBeNonEmptyMap(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty map. [%s] must be a non-empty map", (Object[])new Object[]{scope, settingName});
    }

    public static String invalidTimeValueMsg(String timeValueStr, String settingName, String scope, String exceptionMsg) {
        return Strings.format((String)"[%s] Invalid time value [%s]. [%s] must be a valid time value string: %s", (Object[])new Object[]{scope, timeValueStr, settingName, exceptionMsg});
    }

    public static String invalidValue(String settingName, String scope, String invalidType, String[] requiredValues) {
        Object[] copyOfRequiredValues = (String[])requiredValues.clone();
        Arrays.sort(copyOfRequiredValues);
        return Strings.format((String)"[%s] Invalid value [%s] received. [%s] must be one of [%s]", (Object[])new Object[]{scope, invalidType, settingName, String.join((CharSequence)", ", (CharSequence[])copyOfRequiredValues)});
    }

    public static String invalidSettingError(String settingName, String scope) {
        return Strings.format((String)"[%s] does not allow the setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static URI convertToUri(@Nullable String url, String settingName, String settingScope, ValidationException validationException) {
        try {
            return ServiceUtils.createOptionalUri(url);
        }
        catch (IllegalArgumentException cause) {
            validationException.addValidationError(ServiceUtils.invalidUrlErrorMsg(url, settingName, settingScope, cause.getMessage()));
            return null;
        }
    }

    public static URI createUri(String url) throws IllegalArgumentException {
        Objects.requireNonNull(url);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(Strings.format((String)"unable to parse url [%s]. Reason: %s", (Object[])new Object[]{url, e.getReason()}), e);
        }
    }

    public static URI createOptionalUri(String url) {
        if (url == null) {
            return null;
        }
        return ServiceUtils.createUri(url);
    }

    public static SecureString extractRequiredSecureString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String requiredField = ServiceUtils.extractRequiredString(map, settingName, scope, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return new SecureString(Objects.requireNonNull(requiredField).toCharArray());
    }

    public static SecureString extractOptionalSecureString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String optionalField = ServiceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (!validationException.validationErrors().isEmpty() || optionalField == null) {
            return null;
        }
        return new SecureString(optionalField.toCharArray());
    }

    public static SimilarityMeasure extractSimilarity(Map<String, Object> map, String scope, ValidationException validationException) {
        return ServiceUtils.extractOptionalEnum(map, "similarity", scope, SimilarityMeasure::fromString, EnumSet.allOf(SimilarityMeasure.class), validationException);
    }

    public static String extractRequiredString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        String requiredField = ServiceUtils.removeAsType(map, settingName, String.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (requiredField == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (requiredField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return requiredField;
    }

    public static String extractOptionalEmptyString(Map<String, Object> map, String settingName, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        String optionalField = ServiceUtils.removeAsType(map, settingName, String.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static String extractOptionalString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        String optionalField = ServiceUtils.removeAsType(map, settingName, String.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField != null && optionalField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static <T> List<T> extractOptionalList(Map<String, Object> map, String settingName, Class<T> type, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        List optionalField = ServiceUtils.removeAsType(map, settingName, List.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField != null) {
            for (Object o : optionalField) {
                if (o.getClass().equals(type)) continue;
                validationException.addValidationError(ServiceUtils.invalidTypeErrorMsg(settingName, o, "String"));
            }
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static Integer extractRequiredPositiveInteger(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Integer field = ServiceUtils.removeAsType(map, settingName, Integer.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (field == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (field <= 0) {
            validationException.addValidationError(ServiceUtils.mustBeAPositiveIntegerErrorMessage(settingName, scope, field));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return field;
    }

    public static Map<String, Object> extractRequiredMap(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Map requiredField = ServiceUtils.removeAsType(map, settingName, Map.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (requiredField == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (requiredField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyMap(settingName, scope));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return requiredField;
    }

    public static Map<String, Object> extractOptionalMap(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Map optionalField = ServiceUtils.removeAsType(map, settingName, Map.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return optionalField;
    }

    public static List<Tuple<String, String>> extractOptionalListOfStringTuples(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        List optionalField = ServiceUtils.removeAsType(map, settingName, List.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField == null) {
            return null;
        }
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>();
        for (int tuplesIndex = 0; tuplesIndex < optionalField.size(); ++tuplesIndex) {
            Object tupleEntry = optionalField.get(tuplesIndex);
            if (!(tupleEntry instanceof List)) {
                validationException.addValidationError(Strings.format((String)"[%s] failed to parse tuple list entry [%d] for setting [%s], expected a list but the entry is [%s]", (Object[])new Object[]{scope, tuplesIndex, settingName, tupleEntry.getClass().getSimpleName()}));
                throw validationException;
            }
            List listEntry = (List)tupleEntry;
            if (listEntry.size() != 2) {
                validationException.addValidationError(Strings.format((String)"[%s] failed to parse tuple list entry [%d] for setting [%s], the tuple list size must be two, but was [%d]", (Object[])new Object[]{scope, tuplesIndex, settingName, listEntry.size()}));
                throw validationException;
            }
            Object firstElement = listEntry.get(0);
            Object secondElement = listEntry.get(1);
            ServiceUtils.validateString(firstElement, settingName, scope, "the first element", tuplesIndex, validationException);
            ServiceUtils.validateString(secondElement, settingName, scope, "the second element", tuplesIndex, validationException);
            tuples.add((Tuple<String, String>)new Tuple((Object)((String)firstElement), (Object)((String)secondElement)));
        }
        return tuples;
    }

    private static void validateString(Object tupleValue, String settingName, String scope, String elementDescription, int index, ValidationException validationException) {
        if (!(tupleValue instanceof String)) {
            validationException.addValidationError(Strings.format((String)"[%s] failed to parse tuple list entry [%d] for setting [%s], %s must be a string but was [%s]", (Object[])new Object[]{scope, index, settingName, elementDescription, tupleValue.getClass().getSimpleName()}));
            throw validationException;
        }
    }

    public static Map<String, String> validateMapStringValues(Map<String, ?> map, String settingName, ValidationException validationException, boolean censorValue) {
        if (map == null) {
            return Map.of();
        }
        ServiceUtils.validateMapValues(map, List.of(String.class), settingName, validationException, censorValue);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
    }

    public static void validateMapValues(Map<String, ?> map, List<Class<?>> allowedTypes, String settingName, ValidationException validationException, boolean censorValue) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            boolean isAllowed = false;
            for (Class<?> allowedType : allowedTypes) {
                if (!allowedType.isInstance(entry.getValue())) continue;
                isAllowed = true;
                break;
            }
            Function<String[], String> errorMessage = validTypesAsStrings -> {
                if (censorValue) {
                    return Strings.format((String)"Map field [%s] has an entry that is not valid. Value type is not one of [%s].", (Object[])new Object[]{settingName, String.join((CharSequence)", ", validTypesAsStrings)});
                }
                return Strings.format((String)"Map field [%s] has an entry that is not valid, [%s => %s]. Value type of [%s] is not one of [%s].", (Object[])new Object[]{settingName, entry.getKey(), entry.getValue(), entry.getValue(), String.join((CharSequence)", ", validTypesAsStrings)});
            };
            if (isAllowed) continue;
            Object[] validTypesAsStrings2 = (String[])allowedTypes.stream().map(Class::getSimpleName).toArray(String[]::new);
            Arrays.sort(validTypesAsStrings2);
            validationException.addValidationError(errorMessage.apply((String[])validTypesAsStrings2));
            throw validationException;
        }
    }

    public static Map<String, SecureString> convertMapStringsToSecureString(Map<String, ?> map, String settingName, ValidationException validationException) {
        if (map == null) {
            return Map.of();
        }
        Map<String, String> validatedMap = ServiceUtils.validateMapStringValues(map, settingName, validationException, true);
        return validatedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SecureString(((String)e.getValue()).toCharArray())));
    }

    public static Map<String, Object> removeNullValues(Map<String, Object> map) {
        if (map == null) {
            return map;
        }
        map.values().removeIf(Objects::isNull);
        return map;
    }

    public static Integer extractRequiredPositiveIntegerLessThanOrEqualToMax(Map<String, Object> map, String settingName, int maxValue, String scope, ValidationException validationException) {
        Integer field = ServiceUtils.extractRequiredPositiveInteger(map, settingName, scope, validationException);
        if (field != null && field > maxValue) {
            validationException.addValidationError(ServiceUtils.mustBeLessThanOrEqualNumberErrorMessage(settingName, scope, field.intValue(), maxValue));
        }
        return field;
    }

    public static Integer extractRequiredPositiveIntegerBetween(Map<String, Object> map, String settingName, int minValue, int maxValue, String scope, ValidationException validationException) {
        Integer field = ServiceUtils.extractRequiredPositiveInteger(map, settingName, scope, validationException);
        if (field != null && field < minValue) {
            validationException.addValidationError(ServiceUtils.mustBeGreaterThanOrEqualNumberErrorMessage(settingName, scope, field.intValue(), minValue));
            return null;
        }
        if (field != null && field > maxValue) {
            validationException.addValidationError(ServiceUtils.mustBeLessThanOrEqualNumberErrorMessage(settingName, scope, field.intValue(), maxValue));
            return null;
        }
        return field;
    }

    public static Integer extractOptionalPositiveInteger(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Integer optionalField = ServiceUtils.removeAsType(map, settingName, Integer.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (optionalField != null && optionalField <= 0) {
            validationException.addValidationError(ServiceUtils.mustBeAPositiveIntegerErrorMessage(settingName, scope, optionalField));
            return null;
        }
        return optionalField;
    }

    public static Float extractOptionalFloat(Map<String, Object> map, String settingName) {
        return ServiceUtils.removeAsType(map, settingName, Float.class);
    }

    public static Double extractOptionalDoubleInRange(Map<String, Object> map, String settingName, @Nullable Double minValue, @Nullable Double maxValue, String scope, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        Double doubleReturn = ServiceUtils.removeAsType(map, settingName, Double.class, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (doubleReturn != null && minValue != null && doubleReturn < minValue) {
            validationException.addValidationError(ServiceUtils.mustBeGreaterThanOrEqualNumberErrorMessage(settingName, scope, doubleReturn, minValue));
        }
        if (doubleReturn != null && maxValue != null && doubleReturn > maxValue) {
            validationException.addValidationError(ServiceUtils.mustBeLessThanOrEqualNumberErrorMessage(settingName, scope, doubleReturn, maxValue));
        }
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        return doubleReturn;
    }

    public static <E extends Enum<E>> E extractRequiredEnum(Map<String, Object> map, String settingName, String scope, EnumConstructor<E> constructor, EnumSet<E> validValues, ValidationException validationException) {
        int initialValidationErrorCount = validationException.validationErrors().size();
        E enumReturn = ServiceUtils.extractOptionalEnum(map, settingName, scope, constructor, validValues, validationException);
        if (validationException.validationErrors().size() > initialValidationErrorCount) {
            return null;
        }
        if (enumReturn == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        }
        return enumReturn;
    }

    public static Long extractOptionalPositiveLong(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        List<Class<?>> types = List.of(Integer.class, Long.class);
        int initialValidationErrorCount = validationException.validationErrors().size();
        Object optionalField = ServiceUtils.removeAsOneOfTypes(map, settingName, types, validationException);
        if (optionalField != null) {
            try {
                Long longValue = Long.valueOf(String.valueOf(optionalField));
                if (longValue <= 0L) {
                    validationException.addValidationError(ServiceUtils.mustBeAPositiveLongErrorMessage(settingName, scope, longValue));
                }
                if (validationException.validationErrors().size() > initialValidationErrorCount) {
                    return null;
                }
                return longValue;
            }
            catch (NumberFormatException e) {
                validationException.addValidationError(Strings.format((String)"unable to parse long [%s]", (Object[])new Object[]{e}));
            }
        }
        return null;
    }

    public static <E extends Enum<E>> E extractOptionalEnum(Map<String, Object> map, String settingName, String scope, EnumConstructor<E> constructor, EnumSet<E> validValues, ValidationException validationException) {
        String enumString = ServiceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (enumString == null) {
            return null;
        }
        try {
            E createdEnum = constructor.apply(enumString);
            ServiceUtils.validateEnumValue(createdEnum, validValues);
            return createdEnum;
        }
        catch (IllegalArgumentException e) {
            String[] validValuesAsStrings = (String[])validValues.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            validationException.addValidationError(ServiceUtils.invalidValue(settingName, scope, enumString, validValuesAsStrings));
            return null;
        }
    }

    public static Boolean extractOptionalBoolean(Map<String, Object> map, String settingName, ValidationException validationException) {
        return ServiceUtils.removeAsType(map, settingName, Boolean.class, validationException);
    }

    public static TimeValue extractOptionalTimeValue(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String timeValueString = ServiceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (timeValueString == null) {
            return null;
        }
        try {
            return TimeValue.parseTimeValue((String)timeValueString, (String)settingName);
        }
        catch (Exception e) {
            validationException.addValidationError(ServiceUtils.invalidTimeValueMsg(timeValueString, settingName, scope, e.getMessage()));
            return null;
        }
    }

    private static <E extends Enum<E>> void validateEnumValue(E enumValue, EnumSet<E> validValues) {
        if (!validValues.contains(enumValue)) {
            throw new IllegalArgumentException(Strings.format((String)"Enum value [%s] is not one of the acceptable values", (Object[])new Object[]{enumValue.toString()}));
        }
    }

    public static String mustBeAPositiveIntegerErrorMessage(String settingName, String scope, int value) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a positive integer", (Object[])new Object[]{scope, value, settingName});
    }

    public static String mustBeLessThanOrEqualNumberErrorMessage(String settingName, String scope, double value, double maxValue) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a less than or equal to [%s]", (Object[])new Object[]{scope, value, settingName, maxValue});
    }

    public static String mustBeGreaterThanOrEqualNumberErrorMessage(String settingName, String scope, double value, double minValue) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a greater than or equal to [%s]", (Object[])new Object[]{scope, value, settingName, minValue});
    }

    public static String mustBeAFloatingPointNumberErrorMessage(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value. [%s] must be a floating point number", (Object[])new Object[]{scope, settingName});
    }

    public static String mustBeAPositiveLongErrorMessage(String settingName, String scope, Long value) {
        return Strings.format((String)"[%s] Invalid value [%s]. [%s] must be a positive long", (Object[])new Object[]{scope, value, settingName});
    }

    public static TaskType resolveTaskType(TaskType urlTaskType, String bodyTaskType) {
        if (bodyTaskType == null) {
            if (urlTaskType == TaskType.ANY) {
                throw new ElasticsearchStatusException("model is missing required setting [task_type]", RestStatus.BAD_REQUEST, new Object[0]);
            }
            return urlTaskType;
        }
        TaskType parsedBodyTask = TaskType.fromStringOrStatusException((String)bodyTaskType);
        if (parsedBodyTask == TaskType.ANY) {
            throw new ElasticsearchStatusException("task_type [any] is not valid type for inference", RestStatus.BAD_REQUEST, new Object[0]);
        }
        if (!parsedBodyTask.isAnyOrSame(urlTaskType)) {
            throw new ElasticsearchStatusException("Cannot resolve conflicting task_type parameter in the request URL [{}] and the request body [{}]", RestStatus.BAD_REQUEST, new Object[]{urlTaskType.toString(), bodyTaskType});
        }
        return parsedBodyTask;
    }

    public static String parsePersistedConfigErrorMsg(String inferenceEntityId, String serviceName) {
        return Strings.format((String)"Failed to parse stored model [%s] for [%s] service, please delete and add the service again", (Object[])new Object[]{inferenceEntityId, serviceName});
    }

    public static ElasticsearchStatusException createInvalidModelException(Model model) {
        return new ElasticsearchStatusException(Strings.format((String)"The internal model was invalid, please delete the service [%s] with id [%s] and add it again.", (Object[])new Object[]{model.getConfigurations().getService(), model.getConfigurations().getInferenceEntityId()}), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    public static SecureString apiKey(@Nullable ApiKeySecrets secrets) {
        return secrets == null ? new SecureString(new char[0]) : secrets.apiKey();
    }

    public static <T> T nonNullOrDefault(@Nullable T requestValue, @Nullable T originalSettingsValue) {
        return requestValue == null ? originalSettingsValue : requestValue;
    }

    public static void throwUnsupportedUnifiedCompletionOperation(String serviceName) {
        throw new UnsupportedOperationException(Strings.format((String)"The %s service does not support unified completion", (Object[])new Object[]{serviceName}));
    }

    public static String unsupportedTaskTypeForInference(Model model, EnumSet<TaskType> supportedTaskTypes) {
        return Strings.format((String)"Inference entity [%s] does not support task type [%s] for inference, the task type must be one of %s.", (Object[])new Object[]{model.getInferenceEntityId(), model.getTaskType(), supportedTaskTypes});
    }

    public static String useChatCompletionUrlMessage(Model model) {
        return org.elasticsearch.common.Strings.format((String)"The task type for the inference entity is %s, please use the _inference/%s/%s/%s URL.", (Object[])new Object[]{model.getTaskType(), model.getTaskType(), model.getInferenceEntityId(), "_stream"});
    }

    public static void validateInputTypeIsUnspecifiedOrInternal(InputType inputType, ValidationException validationException) {
        if (inputType != null && inputType != InputType.UNSPECIFIED && !VALID_INTERNAL_INPUT_TYPE_VALUES.contains(inputType)) {
            validationException.addValidationError(Strings.format((String)"Invalid input_type [%s]. The input_type option is not supported by this service", (Object[])new Object[]{inputType}));
        }
    }

    public static void validateInputTypeIsUnspecifiedOrInternal(InputType inputType, ValidationException validationException, String customErrorMessage) {
        if (inputType != null && inputType != InputType.UNSPECIFIED && !VALID_INTERNAL_INPUT_TYPE_VALUES.contains(inputType)) {
            validationException.addValidationError(customErrorMessage);
        }
    }

    public static void validateInputTypeAgainstAllowlist(InputType inputType, EnumSet<InputType> allowedInputTypes, String name, ValidationException validationException) {
        if (inputType != null && inputType != InputType.UNSPECIFIED && !allowedInputTypes.contains(inputType)) {
            validationException.addValidationError(org.elasticsearch.common.Strings.format((String)"Input type [%s] is not supported for [%s]", (Object[])new Object[]{inputType, name}));
        }
    }

    private ServiceUtils() {
    }

    @FunctionalInterface
    public static interface EnumConstructor<E extends Enum<E>> {
        public E apply(String var1) throws IllegalArgumentException;
    }
}

