/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Streams;
import org.elasticsearch.xpack.inference.common.SizeLimitInputStream;

public record HttpResult(HttpResponse response, byte[] body) {
    public HttpResult {
        Objects.requireNonNull(response);
        Objects.requireNonNull(body);
    }

    public static HttpResult create(ByteSizeValue maxResponseSize, HttpResponse response) throws IOException {
        return new HttpResult(response, HttpResult.limitBody(maxResponseSize, response));
    }

    private static byte[] limitBody(ByteSizeValue maxResponseSize, HttpResponse response) throws IOException {
        byte[] body;
        if (response.getEntity() == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (SizeLimitInputStream is = new SizeLimitInputStream(maxResponseSize, response.getEntity().getContent());){
                Streams.copy((InputStream)is, (OutputStream)outputStream);
            }
            body = outputStream.toByteArray();
        }
        return body;
    }

    public boolean isBodyEmpty() {
        return this.body().length == 0;
    }

    public boolean isSuccessfulResponse() {
        int code = this.response.getStatusLine().getStatusCode();
        return code >= 200 && code < 300;
    }
}

