/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;

public class SemanticTextInfoExtractor {
    public static Set<String> extractIndexesReferencingInferenceEndpoints(Metadata metadata, Set<String> endpointIds) {
        assert (Transports.assertNotTransportThread((String)"non-trivial nested loops over cluster state structures"));
        assert (!endpointIds.isEmpty());
        assert (metadata != null);
        HashSet<String> referenceIndices = new HashSet<String>();
        Map indices = metadata.indices();
        indices.forEach((indexName, indexMetadata) -> {
            Map inferenceFields = indexMetadata.getInferenceFields();
            if (inferenceFields.values().stream().anyMatch(im -> endpointIds.contains(im.getInferenceId()) || endpointIds.contains(im.getSearchInferenceId()))) {
                referenceIndices.add((String)indexName);
            }
        });
        return referenceIndices;
    }

    public static Map<String, MinimalServiceSettings> getModelSettingsForIndicesReferencingInferenceEndpoints(Metadata metadata, Set<String> endpointIds) {
        assert (Transports.assertNotTransportThread((String)"non-trivial nested loops over cluster state structures"));
        assert (!endpointIds.isEmpty());
        assert (metadata != null);
        HashMap<String, MinimalServiceSettings> serviceSettingsMap = new HashMap<String, MinimalServiceSettings>();
        metadata.indices().forEach((indexName, indexMetadata) -> indexMetadata.getInferenceFields().values().stream().filter(field -> endpointIds.contains(field.getInferenceId()) || endpointIds.contains(field.getSearchInferenceId())).findFirst().ifPresent(field -> {
            MappingMetadata mapping = indexMetadata.mapping();
            if (mapping != null) {
                String[] pathArray = new String[]{"properties", field.getName(), "model_settings"};
                Object modelSettings = ObjectPath.eval((String[])pathArray, (Object)mapping.sourceAsMap());
                serviceSettingsMap.put((String)indexName, SemanticTextField.parseModelSettingsFromMap(modelSettings));
            }
        }));
        return serviceSettingsMap;
    }
}

