/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.Language;
import org.sonarsource.slang.checks.utils.PropertyDefaultValue;
import org.sonarsource.slang.checks.utils.PropertyDefaultValues;

@Rule(key="S117")
public class VariableAndParameterNameCheck
implements SlangCheck {
    private static final String DEFAULT_FORMAT = "^[_a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names against.")
    @PropertyDefaultValues(value={@PropertyDefaultValue(language=Language.RUBY, defaultValue="^(@{0,2}[\\da-z_]+[!?=]?)|([*+-/%=!><~]+)|(\\[]=?)$"), @PropertyDefaultValue(language=Language.SCALA, defaultValue="^[_a-zA-Z][a-zA-Z0-9]*$"), @PropertyDefaultValue(language=Language.GO, defaultValue="^(_|[a-zA-Z0-9]+)$")})
    public String format = "^[_a-z][a-zA-Z0-9]*$";

    @Override
    public void initialize(InitContext init) {
        Pattern pattern = Pattern.compile(this.format);
        init.register(VariableDeclarationTree.class, (ctx, tree) -> {
            if (ctx.ancestors().stream().anyMatch(FunctionDeclarationTree.class::isInstance)) {
                this.check(pattern, (CheckContext)ctx, tree.identifier(), "local variable");
            }
        });
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> tree.formalParameters().stream().filter(ParameterTree.class::isInstance).map(ParameterTree.class::cast).forEach(param -> this.check(pattern, (CheckContext)ctx, param.identifier(), "parameter")));
    }

    private void check(Pattern pattern, CheckContext ctx, @Nullable IdentifierTree identifier, String variableKind) {
        if (identifier != null && !pattern.matcher(identifier.name()).matches()) {
            String message = String.format("Rename this %s to match the regular expression \"%s\".", variableKind, this.format);
            ctx.reportIssue(identifier, message);
        }
    }
}

