/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S101")
public class BadClassNameCheck
implements SlangCheck {
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the class names against.", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";

    @Override
    public void initialize(InitContext init) {
        Pattern pattern = Pattern.compile(this.format);
        init.register(ClassDeclarationTree.class, (ctx, tree) -> {
            IdentifierTree identifier = tree.identifier();
            if (identifier != null && !pattern.matcher(identifier.name()).matches()) {
                String message = String.format("Rename class \"%s\" to match the regular expression %s.", identifier.name(), this.format);
                ctx.reportIssue(identifier, message);
            }
        });
    }
}

