/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.checks;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.StringLiteralDuplicatedCheck;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;

@Rule(key="S1192")
public class StringLiteralDuplicatedScalaCheck
extends StringLiteralDuplicatedCheck {
    private static final int MINIMAL_LITERAL_LENGTH = 5;
    private static final Pattern NO_SEPARATOR_REGEXP = Pattern.compile("\\w++");
    private static final String ANNOTATION_QUALIFIED_NAME = "ScalaNativeKind(class scala.meta.Mod$Annot$ModAnnotImpl)";

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            HashMap<String, List<StringLiteralTree>> occurrences = new HashMap<String, List<StringLiteralTree>>();
            Set<StringLiteralTree> annotationsStringLiterals = StringLiteralDuplicatedScalaCheck.getStringLiteralsWithinAnnotation(tree);
            tree.descendants().filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).filter(literal -> !annotationsStringLiterals.contains(literal)).filter(literal -> literal.content().length() > 5 && !NO_SEPARATOR_REGEXP.matcher(literal.content()).matches()).forEach(literal -> occurrences.computeIfAbsent(literal.content(), key -> new LinkedList()).add(literal));
            StringLiteralDuplicatedScalaCheck.check(ctx, occurrences, this.threshold);
        });
    }

    private static Set<StringLiteralTree> getStringLiteralsWithinAnnotation(TopLevelTree tree) {
        return tree.descendants().filter(t -> {
            NativeTree nativeTree;
            return t instanceof NativeTree && (nativeTree = (NativeTree)t).nativeKind().toString().equals(ANNOTATION_QUALIFIED_NAME);
        }).flatMap(Tree::descendants).filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).collect(Collectors.toSet());
    }

    private static void check(CheckContext ctx, Map<String, List<StringLiteralTree>> occurrencesMap, int threshold) {
        for (Map.Entry<String, List<StringLiteralTree>> entry : occurrencesMap.entrySet()) {
            List<StringLiteralTree> occurrences = entry.getValue();
            int size = occurrences.size();
            if (size < threshold) continue;
            StringLiteralTree first2 = occurrences.get(0);
            String message = String.format("Define a constant instead of duplicating this literal \"%s\" %s times.", first2.content(), size);
            List<SecondaryLocation> secondaryLocations = occurrences.stream().skip(1L).map(stringLiteral -> new SecondaryLocation(stringLiteral.metaData().textRange(), "Duplication")).toList();
            double gap = (double)size - 1.0;
            ctx.reportIssue(first2, message, secondaryLocations, gap);
        }
    }
}

