/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scala.checks;

import java.util.Optional;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.Tree;

class PatternMatchHelper {
    private static final String PATTERN_VARIABLE = "ScalaNativeKind(class scala.meta.Pat$Var$PatVarImpl)";

    private PatternMatchHelper() {
    }

    static boolean hasPatternMatchedVariable(MatchCaseTree caseTree) {
        Tree caseCondition = caseTree.expression();
        Tree caseBody = caseTree.body();
        return caseCondition != null && caseBody != null && PatternMatchHelper.caseConditionContainsVariableDeclarationUsedInTheBody(caseCondition, caseBody);
    }

    static boolean caseConditionContainsVariableDeclarationUsedInTheBody(Tree caseCondition, Tree caseBody) {
        if (caseCondition instanceof NativeTree && PATTERN_VARIABLE.equals(((NativeTree)caseCondition).nativeKind().toString())) {
            Optional<IdentifierTree> variableDeclaration = caseCondition.descendants().filter(IdentifierTree.class::isInstance).map(IdentifierTree.class::cast).findFirst();
            return variableDeclaration.filter(variable -> PatternMatchHelper.variableIsUsedIn(variable, caseBody)).isPresent();
        }
        return caseCondition.children().stream().anyMatch(caseConditionChild -> PatternMatchHelper.caseConditionContainsVariableDeclarationUsedInTheBody(caseConditionChild, caseBody));
    }

    private static boolean variableIsUsedIn(IdentifierTree variableDeclaration, Tree caseBody) {
        if (caseBody instanceof IdentifierTree) {
            return ((IdentifierTree)caseBody).name().equals(variableDeclaration.name());
        }
        return caseBody.children().stream().anyMatch(caseBodyChild -> PatternMatchHelper.variableIsUsedIn(variableDeclaration, caseBodyChild));
    }
}

