/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

public class BranchTrackingVisitor
extends RegexBaseVisitor {
    private RegexTree branchingNode = null;

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        RegexTree previousBranchingNode = this.branchingNode;
        this.branchingNode = tree;
        super.visitDisjunction(tree);
        this.branchingNode = previousBranchingNode;
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        RegexTree previousBranchingNode = this.branchingNode;
        this.branchingNode = tree;
        super.visitRepetition(tree);
        this.branchingNode = previousBranchingNode;
    }

    private int getPredecessorsStartOf(RegexTree tree) {
        if (this.branchingNode == null) {
            return 0;
        }
        if (this.branchingNode.is(RegexTree.Kind.REPETITION)) {
            return ((RepetitionTree)this.branchingNode).getElement().getRange().getBeginningOffset();
        }
        return ((DisjunctionTree)this.branchingNode).getAlternatives().stream().filter(alternative -> alternative.getRange().contains(tree.getRange())).findFirst().map(alternative -> alternative.getRange().getBeginningOffset()).orElse(tree.getRange().getBeginningOffset());
    }

    public IndexRange getPredecessorsRangeOf(RegexTree tree) {
        int firstPredecessorIndex = this.getPredecessorsStartOf(tree);
        return new IndexRange(firstPredecessorIndex, tree.getRange().getEndingOffset());
    }
}

