/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;

public class SingleCharCharacterClassFinder
extends RegexBaseVisitor {
    private static final String MESSAGE = "Replace this character class by the character itself.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public SingleCharCharacterClassFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        CharacterClassElementTree charClass = tree.getContents();
        if (!tree.isNegated()) {
            this.checkElementTree(charClass);
        }
        super.visitCharacterClass(tree);
    }

    private void checkElementTree(CharacterClassElementTree elementTree) {
        if (elementTree.is(CharacterClassElementTree.Kind.PLAIN_CHARACTER, CharacterClassElementTree.Kind.UNICODE_CODE_POINT) && "\\^$*+?.|({[".indexOf(elementTree.getText()) < 0) {
            this.regexElementIssueReporter.report(elementTree, MESSAGE, null, Collections.emptyList());
        }
    }
}

