/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.ast;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.FlagSet;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexVisitor;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;

public class DisjunctionTree
extends RegexTree {
    private final List<RegexTree> alternatives;
    private final List<SourceCharacter> orOperators;

    public DisjunctionTree(RegexSource source, IndexRange range, List<RegexTree> alternatives, List<SourceCharacter> orOperators, FlagSet activeFlags) {
        super(source, range, activeFlags);
        this.alternatives = Collections.unmodifiableList(alternatives);
        this.orOperators = Collections.unmodifiableList(orOperators);
    }

    public List<RegexTree> getAlternatives() {
        return this.alternatives;
    }

    public List<SourceCharacter> getOrOperators() {
        return this.orOperators;
    }

    @Override
    public void accept(RegexVisitor visitor) {
        visitor.visitDisjunction(this);
    }

    @Override
    public RegexTree.Kind kind() {
        return RegexTree.Kind.DISJUNCTION;
    }

    @Override
    @Nonnull
    public AutomatonState.TransitionType incomingTransitionType() {
        return AutomatonState.TransitionType.EPSILON;
    }

    @Override
    @Nonnull
    public List<? extends AutomatonState> successors() {
        return this.alternatives;
    }

    @Override
    public void setContinuation(AutomatonState continuation) {
        super.setContinuation(continuation);
        for (RegexTree alternative : this.alternatives) {
            alternative.setContinuation(continuation);
        }
    }
}

