/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2.matchers;

import java.util.Set;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.types.v2.TypeUtils;
import org.sonar.python.types.v2.matchers.IsObjectSatisfyingPredicate;
import org.sonar.python.types.v2.matchers.TypePredicate;

public class IsObjectSubtypeOfPredicate
implements TypePredicate {
    private final IsObjectSatisfyingPredicate isObjectSatisfyingPredicate;

    public IsObjectSubtypeOfPredicate(String fullyQualifiedName) {
        this.isObjectSatisfyingPredicate = new IsObjectSatisfyingPredicate(new IsSubtypeOfPredicate(fullyQualifiedName));
    }

    @Override
    public TriBool check(PythonType type, SubscriptionContext ctx) {
        return this.isObjectSatisfyingPredicate.check(type, ctx);
    }

    private static class IsSubtypeOfPredicate
    implements TypePredicate {
        String fullyQualifiedName;

        public IsSubtypeOfPredicate(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public TriBool check(PythonType type, SubscriptionContext ctx) {
            PythonType expectedType = ctx.typeTable().getType(this.fullyQualifiedName);
            Set<PythonType> types = TypeUtils.collectTypes(type);
            if (types.stream().anyMatch(t -> t.equals(expectedType))) {
                return TriBool.TRUE;
            }
            return TriBool.FALSE;
        }
    }
}

