/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.types.v2.ResolvableType;

public class TypeUtils {
    private TypeUtils() {
    }

    public static PythonType resolved(PythonType pythonType) {
        if (pythonType instanceof ResolvableType) {
            ResolvableType resolvableType = (ResolvableType)((Object)pythonType);
            return resolvableType.resolve();
        }
        return pythonType;
    }

    public static PythonType ensureWrappedObjectType(PythonType pythonType) {
        if (!(pythonType instanceof ObjectType)) {
            return new ObjectType(pythonType);
        }
        return pythonType;
    }

    public static PythonType map(PythonType type, UnaryOperator<PythonType> mapper) {
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return unionType.candidates().stream().map(mapper).collect(TypeUtils.toUnionType());
        }
        return (PythonType)mapper.apply(type);
    }

    public static Collector<PythonType, ?, PythonType> toUnionType() {
        return Collectors.collectingAndThen(Collectors.toSet(), UnionType::or);
    }

    public static Set<PythonType> collectTypes(PythonType type) {
        HashSet<PythonType> result = new HashSet<PythonType>();
        ArrayDeque<PythonType> queue = new ArrayDeque<PythonType>();
        queue.add(type);
        while (!queue.isEmpty()) {
            PythonType currentType = (PythonType)queue.pop();
            if (result.contains(currentType)) continue;
            result.add(currentType);
            if (currentType instanceof UnionType) {
                result.clear();
                result.add(PythonType.UNKNOWN);
                queue.clear();
                continue;
            }
            if (!(currentType instanceof ClassType)) continue;
            ClassType classType = (ClassType)currentType;
            queue.addAll(classType.superClasses().stream().map(TypeWrapper::type).toList());
        }
        return result;
    }
}

