/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.types.v2.TypeCheckBuilder;

public class TypeCheckMap<V> {
    private final Map<TypeCheckBuilder, V> map;

    public TypeCheckMap() {
        this(new HashMap());
    }

    public TypeCheckMap(Map<TypeCheckBuilder, V> map) {
        this.map = map;
    }

    @SafeVarargs
    public static <V> TypeCheckMap<V> ofEntries(Map.Entry<TypeCheckBuilder, V> ... entries) {
        TypeCheckMap<V> typeCheckMap = new TypeCheckMap<V>();
        for (Map.Entry<TypeCheckBuilder, V> entry : entries) {
            typeCheckMap.put(entry.getKey(), entry.getValue());
        }
        return typeCheckMap;
    }

    public V put(TypeCheckBuilder key, V value) {
        return this.map.put(key, value);
    }

    @CheckForNull
    public V getForType(PythonType type) {
        return this.getOptionalForType(type).orElse(null);
    }

    public Optional<V> getOptionalForType(PythonType type) {
        return this.map.entrySet().stream().filter(entry -> ((TypeCheckBuilder)entry.getKey()).check(type).isTrue()).findFirst().map(Map.Entry::getValue);
    }

    public boolean containsForType(PythonType type) {
        return this.getOptionalForType(type).isPresent();
    }
}

