/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.types.v2.SpecialFormType;
import org.sonar.python.types.v2.TypeUtils;

public class TypeCheckBuilder {
    TypeTable projectLevelTypeTable;
    List<TypePredicate> predicates = new ArrayList<TypePredicate>();

    public TypeCheckBuilder(TypeTable projectLevelTypeTable) {
        this.projectLevelTypeTable = projectLevelTypeTable;
    }

    public TypeCheckBuilder hasMember(String memberName) {
        this.predicates.add(new HasMemberTypePredicate(memberName));
        return this;
    }

    public TypeCheckBuilder instancesHaveMember(String memberName) {
        this.predicates.add(new InstancesHaveMemberTypePredicate(memberName));
        return this;
    }

    public TypeCheckBuilder isTypeHintTypeSource() {
        this.predicates.add(new TypeSourceMatcherTypePredicate(TypeSource.TYPE_HINT));
        return this;
    }

    public TypeCheckBuilder isExactTypeSource() {
        this.predicates.add(new TypeSourceMatcherTypePredicate(TypeSource.EXACT));
        return this;
    }

    public TypeCheckBuilder isBuiltinWithName(String name) {
        PythonType builtinType = this.projectLevelTypeTable.getBuiltinsModule().resolveMember(name).orElse(PythonType.UNKNOWN);
        this.predicates.add(new IsSameAsTypePredicate(builtinType));
        return this;
    }

    public TypeCheckBuilder isSubtypeOf(String fqn) {
        PythonType type = this.projectLevelTypeTable.getType(fqn);
        this.predicates.add(new IsSubtypeOfPredicate(type, fqn));
        return this;
    }

    public TypeCheckBuilder isInstance() {
        this.predicates.add(new IsInstancePredicate());
        return this;
    }

    public TypeCheckBuilder isGeneric() {
        this.predicates.add(new IsGenericPredicate());
        return this;
    }

    public TriBool check(PythonType pythonType) {
        TriBool result = TriBool.TRUE;
        for (TypePredicate predicate : this.predicates) {
            TriBool partialResult = predicate.test(pythonType);
            if ((result = result.conservativeAnd(partialResult)) != TriBool.UNKNOWN) continue;
            return TriBool.UNKNOWN;
        }
        return result;
    }

    public TypeCheckBuilder isInstanceOf(String fqn) {
        PythonType expected = this.projectLevelTypeTable.getType(fqn);
        this.predicates.add(new IsInstanceOfPredicate(expected));
        return this;
    }

    public TypeCheckBuilder isTypeOrInstanceWithName(String expectedName) {
        PythonType expected = this.projectLevelTypeTable.getType(expectedName);
        this.predicates.add(new IsSameAsTypePredicate(expected, false));
        return this;
    }

    public TypeCheckBuilder isTypeWithName(String expectedName) {
        PythonType expected = this.projectLevelTypeTable.getType(expectedName);
        this.predicates.add(new IsSameAsTypePredicate(expected, true));
        return this;
    }

    public TypeCheckBuilder isTypeWithFqn(String expectedFqn) {
        this.predicates.add(new IsTypeWithFullyQualifiedNamePredicate(expectedFqn));
        return this;
    }

    private static TriBool isClassInheritedFrom(PythonType classType, ClassType expectedParentClassType) {
        if (classType == expectedParentClassType) {
            return TriBool.TRUE;
        }
        Set<PythonType> types = TypeUtils.collectTypes(classType);
        if (types.contains(expectedParentClassType)) {
            return TriBool.TRUE;
        }
        if (TypeCheckBuilder.containsUnknown(types)) {
            return TriBool.UNKNOWN;
        }
        return TriBool.FALSE;
    }

    private static boolean containsUnknown(Set<PythonType> types) {
        return types.stream().anyMatch(UnknownType.class::isInstance);
    }

    static class HasMemberTypePredicate
    implements TypePredicate {
        String memberName;

        public HasMemberTypePredicate(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public TriBool test(PythonType pythonType) {
            return pythonType.hasMember(this.memberName);
        }
    }

    static class InstancesHaveMemberTypePredicate
    implements TypePredicate {
        String memberName;

        public InstancesHaveMemberTypePredicate(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public TriBool test(PythonType pythonType) {
            if (pythonType instanceof ClassType) {
                ClassType classType = (ClassType)pythonType;
                return classType.instancesHaveMember(this.memberName);
            }
            return TriBool.FALSE;
        }
    }

    record TypeSourceMatcherTypePredicate(TypeSource typeSource) implements TypePredicate
    {
        @Override
        public TriBool test(PythonType pythonType) {
            return pythonType.typeSource() == this.typeSource ? TriBool.TRUE : TriBool.FALSE;
        }
    }

    static class IsSameAsTypePredicate
    implements TypePredicate {
        PythonType expectedType;
        boolean isStrictCheck;

        public IsSameAsTypePredicate(PythonType expectedType) {
            this(expectedType, false);
        }

        public IsSameAsTypePredicate(PythonType expectedType, boolean isStrictCheck) {
            this.expectedType = expectedType;
            this.isStrictCheck = isStrictCheck;
        }

        @Override
        public TriBool test(PythonType pythonType) {
            if (pythonType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)pythonType;
                if (!this.isStrictCheck) {
                    pythonType = objectType.unwrappedType();
                }
            }
            if (pythonType instanceof UnknownType.UnresolvedImportType) {
                UnknownType.UnresolvedImportType unresolvedPythonType = (UnknownType.UnresolvedImportType)pythonType;
                PythonType pythonType2 = this.expectedType;
                if (pythonType2 instanceof UnknownType.UnresolvedImportType) {
                    UnknownType.UnresolvedImportType unresolvedExpectedType = (UnknownType.UnresolvedImportType)pythonType2;
                    return unresolvedPythonType.importPath().equals(unresolvedExpectedType.importPath()) ? TriBool.TRUE : TriBool.UNKNOWN;
                }
            }
            if (pythonType instanceof UnknownType || this.expectedType instanceof UnknownType) {
                return TriBool.UNKNOWN;
            }
            return pythonType.equals(this.expectedType) ? TriBool.TRUE : TriBool.FALSE;
        }
    }

    record IsSubtypeOfPredicate(PythonType expectedType, String expectedFqnName) implements TypePredicate
    {
        @Override
        public TriBool test(PythonType pythonType) {
            PythonType pythonType2;
            if (pythonType instanceof ClassType) {
                ClassType testedClassType = (ClassType)pythonType;
                Set<PythonType> types = TypeUtils.collectTypes(testedClassType);
                if (types.stream().anyMatch(t -> {
                    ClassType ct;
                    return t instanceof ClassType && (ct = (ClassType)t).fullyQualifiedName().equals(this.expectedFqnName);
                })) {
                    return TriBool.TRUE;
                }
                if (this.expectedType instanceof UnknownType && types.stream().anyMatch(t -> new IsTypeWithFullyQualifiedNamePredicate(this.expectedFqnName).test((PythonType)t).isTrue())) {
                    return TriBool.TRUE;
                }
            }
            if ((pythonType2 = this.expectedType) instanceof ClassType) {
                ClassType expectedClassType = (ClassType)pythonType2;
                return TypeCheckBuilder.isClassInheritedFrom(pythonType, expectedClassType);
            }
            return TriBool.UNKNOWN;
        }
    }

    record IsInstancePredicate() implements TypePredicate
    {
        @Override
        public TriBool test(PythonType pythonType) {
            Set<PythonType> candiates = Set.of(pythonType);
            if (pythonType instanceof UnionType) {
                UnionType unionType = (UnionType)pythonType;
                candiates = unionType.candidates();
            }
            if (candiates.stream().allMatch(ObjectType.class::isInstance)) {
                return TriBool.TRUE;
            }
            return TriBool.FALSE;
        }
    }

    record IsGenericPredicate() implements TypePredicate
    {
        @Override
        public TriBool test(PythonType pythonType) {
            return IsGenericPredicate.isGeneric(pythonType);
        }

        private static TriBool isGeneric(PythonType pythonType) {
            UnknownType.UnresolvedImportType unresolvedImportType;
            ClassType classType;
            if (pythonType instanceof ClassType && (classType = (ClassType)pythonType).isGeneric()) {
                return TriBool.TRUE;
            }
            if (pythonType instanceof SpecialFormType) {
                SpecialFormType specialFormType = (SpecialFormType)pythonType;
                return "typing.Generic".equals(specialFormType.fullyQualifiedName()) ? TriBool.TRUE : TriBool.UNKNOWN;
            }
            if (pythonType instanceof UnknownType.UnresolvedImportType && "typing.Generic".equals((unresolvedImportType = (UnknownType.UnresolvedImportType)pythonType).importPath())) {
                return TriBool.TRUE;
            }
            return TriBool.UNKNOWN;
        }
    }

    static interface TypePredicate {
        public TriBool test(PythonType var1);
    }

    record IsInstanceOfPredicate(PythonType expectedType) implements TypePredicate
    {
        @Override
        public TriBool test(PythonType pythonType) {
            PythonType pythonType2 = this.expectedType;
            if (pythonType2 instanceof ClassType) {
                ClassType expectedClassType = (ClassType)pythonType2;
                if (pythonType instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)pythonType;
                    PythonType pythonType3 = objectType.type();
                    if (pythonType3 instanceof ClassType) {
                        ClassType classType = (ClassType)pythonType3;
                        return TypeCheckBuilder.isClassInheritedFrom(classType, expectedClassType);
                    }
                    pythonType3 = objectType.type();
                    if (pythonType3 instanceof UnionType) {
                        UnionType unionType = (UnionType)pythonType3;
                        return IsInstanceOfPredicate.isObjectOfUnionTypeInstanceOf(expectedClassType, unionType);
                    }
                } else if (pythonType instanceof UnionType) {
                    UnionType unionType = (UnionType)pythonType;
                    return this.isUnionTypeInstanceOf(unionType);
                }
            }
            return TriBool.UNKNOWN;
        }

        private static TriBool isObjectOfUnionTypeInstanceOf(ClassType expectedClassType, UnionType unionType) {
            List<TriBool> results = unionType.candidates().stream().map(classType -> TypeCheckBuilder.isClassInheritedFrom(classType, expectedClassType)).distinct().toList();
            if (results.size() > 1) {
                return TriBool.UNKNOWN;
            }
            return results.get(0);
        }

        private TriBool isUnionTypeInstanceOf(UnionType unionType) {
            List<TriBool> candidatesResults = unionType.candidates().stream().map(this::test).distinct().toList();
            if (candidatesResults.size() != 1) {
                return TriBool.UNKNOWN;
            }
            return candidatesResults.get(0);
        }
    }

    static class IsTypeWithFullyQualifiedNamePredicate
    implements TypePredicate {
        String expectedFullyQualifiedName;

        public IsTypeWithFullyQualifiedNamePredicate(String expectedFullyQualifiedName) {
            this.expectedFullyQualifiedName = expectedFullyQualifiedName;
        }

        @Override
        public TriBool test(PythonType pythonType) {
            return Optional.of(pythonType).map(IsTypeWithFullyQualifiedNamePredicate::getFullyQualifiedName).map(typeFqn -> Objects.equals(this.expectedFullyQualifiedName, typeFqn) ? TriBool.TRUE : TriBool.FALSE).orElse(TriBool.UNKNOWN);
        }

        @CheckForNull
        private static String getFullyQualifiedName(PythonType type) {
            if (type instanceof FunctionType) {
                FunctionType functionType = (FunctionType)type;
                return functionType.fullyQualifiedName();
            }
            if (type instanceof ClassType) {
                ClassType classType = (ClassType)type;
                return classType.fullyQualifiedName();
            }
            if (type instanceof UnknownType.UnresolvedImportType) {
                UnknownType.UnresolvedImportType unresolvedImportType = (UnknownType.UnresolvedImportType)type;
                return unresolvedImportType.importPath();
            }
            return null;
        }
    }
}

