/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnionType;
import org.sonar.python.types.v2.LazyType;
import org.sonar.python.types.v2.ResolvableType;

public class LazyUnionType
implements PythonType,
ResolvableType {
    private final Set<PythonType> candidates;

    public LazyUnionType(Set<PythonType> candidates) {
        this.candidates = candidates.stream().flatMap(LazyUnionType::flattenLazyUnionTypes).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public PythonType resolve() {
        HashSet<PythonType> resolvedCandidates = new HashSet<PythonType>();
        for (PythonType candidate : this.candidates) {
            if (candidate instanceof LazyType) {
                LazyType lazyType = (LazyType)candidate;
                candidate = lazyType.resolve();
            }
            resolvedCandidates.add(candidate);
        }
        return UnionType.or(resolvedCandidates);
    }

    private static Stream<PythonType> flattenLazyUnionTypes(PythonType type) {
        if (type instanceof LazyUnionType) {
            LazyUnionType lazyUnionType = (LazyUnionType)type;
            return lazyUnionType.candidates.stream();
        }
        return Stream.of(type);
    }

    @VisibleForTesting
    protected Set<PythonType> candidates() {
        return Collections.unmodifiableSet(this.candidates);
    }
}

