/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import java.util.Objects;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.python.types.v2.LazyType;
import org.sonar.python.types.v2.TypeUtils;

public class LazyTypeWrapper
implements TypeWrapper {
    private PythonType type;
    private String importPath;

    public LazyTypeWrapper(PythonType type) {
        this.type = type;
        if (type instanceof LazyType) {
            LazyType lazyType = (LazyType)type;
            this.importPath = lazyType.importPath();
            lazyType.addConsumer(this::resolveLazyType);
        }
    }

    @Override
    public PythonType type() {
        return TypeUtils.resolved(this.type);
    }

    public void resolveLazyType(PythonType pythonType) {
        if (!(this.type instanceof LazyType)) {
            throw new IllegalStateException("Trying to resolve an already resolved lazy type.");
        }
        this.type = pythonType;
    }

    public boolean isResolved() {
        return !(this.type instanceof LazyType);
    }

    public boolean hasImportPath(String importPath) {
        return this.importPath != null && this.importPath.equals(importPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyTypeWrapper that = (LazyTypeWrapper)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }

    public String toString() {
        return "LazyTypeWrapper{type=" + this.type + "}";
    }
}

