/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types.v2;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeSource;
import org.sonar.python.semantic.v2.LazyTypesContext;
import org.sonar.python.types.v2.ResolvableType;

public class LazyType
implements PythonType,
ResolvableType {
    String importPath;
    private final BlockingQueue<Consumer<PythonType>> consumers;
    private final LazyTypesContext lazyTypesContext;
    private static final String INTERACTION_MESSAGE = "Lazy types should not be interacted with.";

    public LazyType(String importPath, LazyTypesContext lazyTypesContext) {
        this.importPath = importPath;
        this.lazyTypesContext = lazyTypesContext;
        this.consumers = new LinkedBlockingQueue<Consumer<PythonType>>();
    }

    public String importPath() {
        return this.importPath;
    }

    public LazyType addConsumer(Consumer<PythonType> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    public LazyType resolve(PythonType type) {
        this.notifyConsumers(type);
        return this;
    }

    @Override
    public synchronized PythonType resolve() {
        PythonType resolvedType = this.lazyTypesContext.resolveLazyType(this);
        this.notifyConsumers(resolvedType);
        return resolvedType;
    }

    private void notifyConsumers(PythonType type) {
        ArrayList<Consumer> toNotify = new ArrayList<Consumer>();
        this.consumers.drainTo(toNotify);
        toNotify.forEach(c -> c.accept(type));
    }

    @Override
    public PythonType unwrappedType() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public String name() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public Optional<String> displayName() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public Optional<String> instanceDisplayName() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public boolean isCompatibleWith(PythonType another) {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public String key() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public Optional<PythonType> resolveMember(String memberName) {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public TriBool hasMember(String memberName) {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public Optional<LocationInFile> definitionLocation() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }

    @Override
    public TypeSource typeSource() {
        throw new IllegalStateException(INTERACTION_MESSAGE);
    }
}

