/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;

public class UnknownClassType
implements InferredType {
    private final Symbol typeSymbol;
    private final Map<String, Symbol> members;

    public UnknownClassType(Symbol typeSymbol) {
        this.typeSymbol = typeSymbol;
        this.members = new HashMap<String, Symbol>();
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        return true;
    }

    @Override
    public boolean canHaveMember(String memberName) {
        return true;
    }

    @Override
    public boolean declaresMember(String memberName) {
        return true;
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        Symbol member = this.members.computeIfAbsent(memberName, n -> Optional.of(this.typeSymbol).map(Symbol::fullyQualifiedName).map(fqn -> new SymbolImpl(memberName, fqn + "." + memberName)).orElse(null));
        return Optional.ofNullable(member);
    }

    @Override
    public Optional<Symbol> resolveDeclaredMember(String memberName) {
        return this.resolveMember(memberName);
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return false;
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return true;
    }

    @Override
    public boolean isCompatibleWith(InferredType other) {
        return true;
    }

    @Override
    public boolean mustBeOrExtend(String typeName) {
        return false;
    }

    public Symbol typeSymbol() {
        return this.typeSymbol;
    }
}

