/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.RuntimeType;

class UnionType
implements InferredType {
    private final Set<InferredType> types;

    private UnionType(Set<InferredType> types) {
        this.types = types;
    }

    public static InferredType or(InferredType type1, InferredType type2) {
        if (type1.equals(InferredTypes.anyType()) || type2.equals(InferredTypes.anyType())) {
            return InferredTypes.anyType();
        }
        if (type1.equals(type2)) {
            return type1;
        }
        HashSet<InferredType> types = new HashSet<InferredType>();
        UnionType.addTypes(type1, types);
        UnionType.addTypes(type2, types);
        return new UnionType(types);
    }

    private static void addTypes(InferredType type, Set<InferredType> types) {
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            types.addAll(unionType.types);
        } else {
            types.add(type);
        }
    }

    @Override
    public boolean isIdentityComparableWith(InferredType other) {
        return this.types.stream().anyMatch(t -> t.isIdentityComparableWith(other));
    }

    @Override
    public boolean canHaveMember(String memberName) {
        return this.types.stream().anyMatch(t -> t.canHaveMember(memberName));
    }

    @Override
    public boolean declaresMember(String memberName) {
        return this.types.stream().anyMatch(t -> t.declaresMember(memberName));
    }

    @Override
    public Optional<Symbol> resolveMember(String memberName) {
        if (this.hasUnresolvedHierarchy()) {
            return Optional.empty();
        }
        Set resolved = this.types.stream().map(t -> t.resolveMember(memberName)).filter(Optional::isPresent).collect(Collectors.toSet());
        return resolved.size() == 1 ? (Optional)resolved.iterator().next() : Optional.empty();
    }

    @Override
    public Optional<Symbol> resolveDeclaredMember(String memberName) {
        if (this.hasUnresolvedHierarchy()) {
            return Optional.empty();
        }
        Set resolved = this.types.stream().map(t -> t.resolveDeclaredMember(memberName)).filter(Optional::isPresent).collect(Collectors.toSet());
        return resolved.size() == 1 ? (Optional)resolved.iterator().next() : Optional.empty();
    }

    private boolean hasUnresolvedHierarchy() {
        for (InferredType type : this.types) {
            DeclaredType declaredType;
            RuntimeType runtimeType;
            if (type instanceof RuntimeType && (runtimeType = (RuntimeType)type).hasUnresolvedHierarchy()) {
                return true;
            }
            if (!(type instanceof DeclaredType) || !(declaredType = (DeclaredType)type).hasUnresolvedHierarchy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canOnlyBe(String typeName) {
        return this.types.stream().allMatch(t -> t.canOnlyBe(typeName));
    }

    @Override
    public boolean canBeOrExtend(String typeName) {
        return this.types.stream().anyMatch(t -> t.canBeOrExtend(typeName));
    }

    @Override
    public boolean isCompatibleWith(InferredType other) {
        return this.types.stream().anyMatch(t -> t.isCompatibleWith(other));
    }

    @Override
    public boolean mustBeOrExtend(String fullyQualifiedName) {
        return this.types.stream().allMatch(t -> t.mustBeOrExtend(fullyQualifiedName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionType unionType = (UnionType)o;
        return Objects.equals(this.types, unionType.types);
    }

    public int hashCode() {
        return Objects.hash(this.types);
    }

    public String toString() {
        return "UnionType" + this.types;
    }

    Set<InferredType> types() {
        return Collections.unmodifiableSet(this.types);
    }
}

