/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.RuntimeType;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.UnionType;
import org.sonar.python.types.UnknownClassType;
import org.sonar.python.types.protobuf.SymbolsProtos;

public class InferredTypes {
    private static final Map<String, String> ALIASED_ANNOTATIONS = new HashMap<String, String>();
    public static final InferredType INT;
    public static final InferredType DECL_INT;
    public static final InferredType FLOAT;
    public static final InferredType DECL_FLOAT;
    public static final InferredType COMPLEX;
    public static final InferredType DECL_COMPLEX;
    public static final InferredType STR;
    public static final InferredType DECL_STR;
    public static final InferredType SET;
    public static final InferredType DECL_SET;
    public static final InferredType DICT;
    public static final InferredType DECL_DICT;
    public static final InferredType LIST;
    public static final InferredType DECL_LIST;
    public static final InferredType TUPLE;
    public static final InferredType DECL_TUPLE;
    public static final InferredType NONE;
    public static final InferredType DECL_NONE;
    public static final InferredType BOOL;
    public static final InferredType DECL_BOOL;
    public static final InferredType TYPE;
    public static final InferredType DECL_TYPE;
    private static final String UNICODE = "unicode";
    private static final String BYTES = "bytes";
    private static final Map<String, Set<String>> HARDCODED_COMPATIBLE_TYPES;
    private static final Set<Set<String>> HARDCODED_INCOMPATIBLE_TYPES;
    protected static final Map<String, String> BUILTINS_TYPE_CATEGORY;
    private static final String NUMBER = "number";
    private static final SymbolImpl OPTIONAL_SYMBOL;
    private static final Set<String> EXCLUDING_TYPE_VAR_FQN_PATTERNS;

    private InferredTypes() {
    }

    public static InferredType anyType() {
        return AnyType.ANY;
    }

    static InferredType runtimeBuiltinType(String fullyQualifiedName) {
        return new RuntimeType(fullyQualifiedName);
    }

    private static InferredType declaredBuiltinType(String fullyQualifiedName) {
        return new DeclaredType(fullyQualifiedName);
    }

    public static InferredType runtimeType(@Nullable Symbol typeClass) {
        if (typeClass instanceof ClassSymbol) {
            ClassSymbol classSymbol = (ClassSymbol)typeClass;
            return new RuntimeType(classSymbol);
        }
        if (typeClass instanceof AmbiguousSymbol) {
            AmbiguousSymbol ambiguousSymbol = (AmbiguousSymbol)typeClass;
            return InferredTypes.union(ambiguousSymbol.alternatives().stream().map(InferredTypes::runtimeType));
        }
        return InferredTypes.anyType();
    }

    public static InferredType anyOrUnknownClassType(Symbol symbol) {
        return Optional.of(symbol).filter(s -> Character.isUpperCase(s.name().charAt(0))).filter(s -> {
            Set usageKinds = s.usages().stream().map(Usage::kind).collect(Collectors.toSet());
            return usageKinds.contains((Object)Usage.Kind.IMPORT) && !usageKinds.contains((Object)Usage.Kind.ASSIGNMENT_LHS);
        }).filter(SymbolImpl.class::isInstance).map(SymbolImpl.class::cast).map(unknownClassSymbol -> {
            if (InferredTypes.anyType().equals(unknownClassSymbol.inferredType())) {
                unknownClassSymbol.setInferredType(new UnknownClassType((Symbol)unknownClassSymbol));
            }
            return unknownClassSymbol.inferredType();
        }).orElseGet(InferredTypes::anyType);
    }

    public static InferredType or(InferredType t1, InferredType t2) {
        return UnionType.or(t1, t2);
    }

    public static InferredType union(Stream<InferredType> types) {
        return types.reduce(InferredTypes::or).orElse(InferredTypes.anyType());
    }

    public static InferredType fromTypeAnnotation(TypeAnnotation typeAnnotation) {
        Map<String, Symbol> builtins = TypeShed.builtinSymbols();
        DeclaredType declaredType = InferredTypes.declaredTypeFromTypeAnnotation(typeAnnotation.expression(), builtins);
        if (declaredType == null) {
            return InferredTypes.anyType();
        }
        return declaredType;
    }

    public static InferredType fromTypeshedTypeAnnotation(TypeAnnotation typeAnnotation) {
        Map<String, Symbol> builtins = TypeShed.builtinSymbols();
        return InferredTypes.runtimeTypefromTypeAnnotation(typeAnnotation.expression(), builtins);
    }

    public static InferredType fromTypeshedProtobuf(SymbolsProtos.Type type) {
        switch (type.getKind()) {
            case INSTANCE: {
                String typeName = type.getFullyQualifiedName();
                if ("typing._SpecialForm".equals(typeName)) {
                    return InferredTypes.anyType();
                }
                return typeName.isEmpty() ? InferredTypes.anyType() : InferredTypes.runtimeType(TypeShed.symbolWithFQN(typeName));
            }
            case TYPE: {
                return TYPE;
            }
            case TYPE_ALIAS: {
                return InferredTypes.fromTypeshedProtobuf(type.getArgs(0));
            }
            case CALLABLE: {
                return InferredTypes.anyType();
            }
            case UNION: {
                return InferredTypes.union(type.getArgsList().stream().map(InferredTypes::fromTypeshedProtobuf));
            }
            case TUPLE: {
                return TUPLE;
            }
            case NONE: {
                return NONE;
            }
            case TYPED_DICT: {
                return DICT;
            }
            case TYPE_VAR: {
                return Optional.of(type).filter(InferredTypes::filterTypeVar).map(SymbolsProtos.Type::getFullyQualifiedName).map(TypeShed::symbolWithFQN).map(InferredTypes::runtimeType).orElseGet(InferredTypes::anyType);
            }
        }
        return InferredTypes.anyType();
    }

    public static boolean filterTypeVar(SymbolsProtos.Type type) {
        return Optional.of(type).filter(Predicate.not(t -> t.getPrettyPrintedName().endsWith(".Self"))).map(SymbolsProtos.Type::getFullyQualifiedName).filter(Predicate.not(String::isEmpty)).filter(fqn -> EXCLUDING_TYPE_VAR_FQN_PATTERNS.stream().noneMatch(fqn::matches)).isPresent();
    }

    @CheckForNull
    private static DeclaredType declaredTypeFromTypeAnnotation(Expression expression, Map<String, Symbol> builtinSymbols) {
        Symbol symbol;
        if (expression.is(Tree.Kind.NAME) && !"Any".equals(((Name)expression).name()) && (symbol = ((Name)expression).symbol()) != null) {
            String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
            return builtinFqn != null ? new DeclaredType(builtinSymbols.get(builtinFqn)) : new DeclaredType(symbol);
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            return InferredTypes.declaredTypeFromTypeAnnotationSubscription((SubscriptionExpression)expression, builtinSymbols);
        }
        if (expression.is(Tree.Kind.NONE)) {
            return new DeclaredType(builtinSymbols.get("NoneType"));
        }
        if (expression.is(Tree.Kind.BITWISE_OR)) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            return InferredTypes.declaredUnionType(binaryExpression.leftOperand(), binaryExpression.rightOperand(), builtinSymbols);
        }
        return null;
    }

    @CheckForNull
    public static DeclaredType declaredUnionType(Expression leftOperand, Expression rightOperand, Map<String, Symbol> builtinSymbols) {
        DeclaredType leftType = InferredTypes.declaredTypeFromTypeAnnotation(leftOperand, builtinSymbols);
        DeclaredType rightType = InferredTypes.declaredTypeFromTypeAnnotation(rightOperand, builtinSymbols);
        if (leftType == null || rightType == null) {
            return null;
        }
        if (leftType.mustBeOrExtend("NoneType")) {
            return new DeclaredType(OPTIONAL_SYMBOL, Arrays.asList(rightType));
        }
        if (rightType.mustBeOrExtend("NoneType")) {
            return new DeclaredType(OPTIONAL_SYMBOL, Arrays.asList(leftType));
        }
        return new DeclaredType(new SymbolImpl("Union", "typing.Union"), Arrays.asList(leftType, rightType));
    }

    @CheckForNull
    private static DeclaredType declaredTypeFromTypeAnnotationSubscription(SubscriptionExpression subscription, Map<String, Symbol> builtinSymbols) {
        if (InferredTypes.isAnnotatedSubscription(subscription)) {
            return InferredTypes.declaredTypeFromTypeAnnotation(subscription.subscripts().expressions().get(0), builtinSymbols);
        }
        return TreeUtils.getSymbolFromTree(subscription.object()).map(symbol -> {
            List<DeclaredType> args = subscription.subscripts().expressions().stream().map(exp -> InferredTypes.declaredTypeFromTypeAnnotation(exp, builtinSymbols)).toList();
            if (args.stream().anyMatch(Objects::isNull)) {
                return null;
            }
            String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
            return builtinFqn != null ? new DeclaredType((Symbol)builtinSymbols.get(builtinFqn), args) : new DeclaredType((Symbol)symbol, args);
        }).orElse(null);
    }

    private static InferredType runtimeTypefromTypeAnnotation(Expression expression, Map<String, Symbol> builtinSymbols) {
        if (expression.is(Tree.Kind.NAME) && !"Any".equals(((Name)expression).name())) {
            Symbol symbol2 = ((Name)expression).symbol();
            if (symbol2 != null) {
                if ("typing.Text".equals(symbol2.fullyQualifiedName())) {
                    return InferredTypes.runtimeType(builtinSymbols.get("str"));
                }
                return InferredTypes.genericType(symbol2, Collections.emptyList(), builtinSymbols);
            }
            return InferredTypes.anyType();
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            SubscriptionExpression subscription = (SubscriptionExpression)expression;
            if (InferredTypes.isAnnotatedSubscription(subscription)) {
                return InferredTypes.runtimeTypefromTypeAnnotation(subscription.subscripts().expressions().get(0), builtinSymbols);
            }
            return TreeUtils.getSymbolFromTree(subscription.object()).map(symbol -> InferredTypes.genericType(symbol, subscription.subscripts().expressions(), builtinSymbols)).orElse(InferredTypes.anyType());
        }
        if (expression.is(Tree.Kind.NONE)) {
            return InferredTypes.runtimeType(builtinSymbols.get("NoneType"));
        }
        return InferredTypes.anyType();
    }

    private static boolean isAnnotatedSubscription(SubscriptionExpression subscription) {
        Optional<Symbol> objectSymbol = TreeUtils.getSymbolFromTree(subscription.object());
        return objectSymbol.isPresent() && "typing.Annotated".equals(objectSymbol.get().fullyQualifiedName());
    }

    private static InferredType genericType(Symbol symbol, List<Expression> subscripts, Map<String, Symbol> builtinSymbols) {
        String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
        if (builtinFqn == null) {
            if ("typing.Optional".equals(symbol.fullyQualifiedName()) && subscripts.size() == 1) {
                InferredType noneType = InferredTypes.runtimeType(builtinSymbols.get("NoneType"));
                return InferredTypes.or(InferredTypes.runtimeTypefromTypeAnnotation(subscripts.get(0), builtinSymbols), noneType);
            }
            if ("typing.Union".equals(symbol.fullyQualifiedName())) {
                return InferredTypes.union(subscripts.stream().map(s -> InferredTypes.runtimeTypefromTypeAnnotation(s, builtinSymbols)));
            }
            return InferredTypes.runtimeType(symbol);
        }
        return InferredTypes.runtimeType(builtinSymbols.get(builtinFqn));
    }

    public static Collection<ClassSymbol> typeSymbols(InferredType inferredType) {
        if (inferredType instanceof RuntimeType) {
            return Collections.singleton(inferredType.runtimeTypeSymbol());
        }
        if (inferredType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)inferredType;
            Symbol typeClass = declaredType.getTypeClass();
            return typeClass.is(Symbol.Kind.CLASS) ? Collections.singleton((ClassSymbol)typeClass) : Collections.emptySet();
        }
        if (inferredType instanceof UnionType) {
            UnionType unionType = (UnionType)inferredType;
            HashSet<ClassSymbol> typeClasses = new HashSet<ClassSymbol>();
            unionType.types().forEach(type -> typeClasses.addAll(InferredTypes.typeSymbols(type)));
            return typeClasses;
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public static String typeName(InferredType inferredType) {
        if (inferredType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)inferredType;
            return declaredType.typeName();
        }
        Collection<ClassSymbol> typeClasses = InferredTypes.typeSymbols(inferredType);
        if (typeClasses.size() == 1) {
            return typeClasses.iterator().next().name();
        }
        return null;
    }

    @CheckForNull
    public static String fullyQualifiedTypeName(InferredType inferredType) {
        if (inferredType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)inferredType;
            return declaredType.getTypeClass().fullyQualifiedName();
        }
        Collection<ClassSymbol> typeClasses = InferredTypes.typeSymbols(inferredType);
        if (typeClasses.size() == 1) {
            return typeClasses.iterator().next().fullyQualifiedName();
        }
        return null;
    }

    @CheckForNull
    public static LocationInFile typeClassLocation(InferredType inferredType) {
        Collection<ClassSymbol> typeClasses = InferredTypes.typeSymbols(inferredType);
        if (typeClasses.size() == 1) {
            return typeClasses.iterator().next().definitionLocation();
        }
        return null;
    }

    public static boolean isDeclaredTypeWithTypeClass(InferredType type, String typeName) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            Symbol typeClass = declaredType.getTypeClass();
            return typeName.equals(typeClass.fullyQualifiedName());
        }
        return false;
    }

    static boolean isTypeClassCompatibleWith(Symbol typeClass, InferredType other) {
        if (other instanceof RuntimeType) {
            RuntimeType runtimeType = (RuntimeType)other;
            return InferredTypes.areSymbolsCompatible(typeClass, runtimeType.getTypeClass());
        }
        if (other instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)other;
            if (declaredType.alternativeTypeSymbols().isEmpty()) {
                return true;
            }
            return declaredType.alternativeTypeSymbols().stream().anyMatch(a -> InferredTypes.areSymbolsCompatible(typeClass, a));
        }
        if (other instanceof UnionType) {
            UnionType unionType = (UnionType)other;
            return unionType.types().stream().anyMatch(t -> InferredTypes.isTypeClassCompatibleWith(typeClass, t));
        }
        return true;
    }

    static boolean areSymbolsCompatible(Symbol actual, Symbol expected) {
        if (!expected.is(Symbol.Kind.CLASS) || !actual.is(Symbol.Kind.CLASS)) {
            return true;
        }
        ClassSymbol actualTypeClass = (ClassSymbol)actual;
        ClassSymbol expectedTypeClass = (ClassSymbol)expected;
        String otherFullyQualifiedName = expectedTypeClass.fullyQualifiedName();
        boolean areHardcodedCompatible = InferredTypes.areHardcodedCompatible(actualTypeClass, expectedTypeClass);
        boolean isDuckTypeCompatible = !"NoneType".equals(otherFullyQualifiedName) && expectedTypeClass.declaredMembers().stream().allMatch(m -> actualTypeClass.resolveMember(m.name()).isPresent());
        boolean canBeOrExtend = otherFullyQualifiedName == null || actualTypeClass.canBeOrExtend(otherFullyQualifiedName);
        boolean areHardcodedIncompatible = InferredTypes.areHardCodedIncompatible(actualTypeClass, expectedTypeClass);
        boolean areTupleClasses = actualTypeClass.isOrExtends("tuple") && expectedTypeClass.isOrExtends("tuple");
        return (areHardcodedCompatible || isDuckTypeCompatible || canBeOrExtend || areTupleClasses) && !areHardcodedIncompatible;
    }

    private static boolean areHardcodedCompatible(ClassSymbol actual, ClassSymbol expected) {
        Set compatibleTypes = HARDCODED_COMPATIBLE_TYPES.getOrDefault(actual.fullyQualifiedName(), Collections.emptySet());
        return compatibleTypes.stream().anyMatch(expected::canBeOrExtend);
    }

    private static boolean areHardCodedIncompatible(ClassSymbol actual, ClassSymbol expected) {
        return HARDCODED_INCOMPATIBLE_TYPES.contains(Stream.of(actual, expected).map(Symbol::fullyQualifiedName).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static boolean containsDeclaredType(InferredType type) {
        if (type instanceof DeclaredType) {
            return true;
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return unionType.types().stream().anyMatch(InferredTypes::containsDeclaredType);
        }
        return false;
    }

    public static String getBuiltinCategory(InferredType inferredType) {
        List<String> list = BUILTINS_TYPE_CATEGORY.keySet().stream().filter(inferredType::canOnlyBe).map(BUILTINS_TYPE_CATEGORY::get).toList();
        return list.size() == 1 ? list.get(0) : null;
    }

    public static Map<String, String> getBuiltinsTypeCategory() {
        return Collections.unmodifiableMap(BUILTINS_TYPE_CATEGORY);
    }

    static {
        ALIASED_ANNOTATIONS.put("typing.List", "list");
        ALIASED_ANNOTATIONS.put("typing.Tuple", "tuple");
        ALIASED_ANNOTATIONS.put("typing.Dict", "dict");
        ALIASED_ANNOTATIONS.put("typing.Set", "set");
        ALIASED_ANNOTATIONS.put("typing.FrozenSet", "frozenset");
        ALIASED_ANNOTATIONS.put("typing.Type", "type");
        INT = InferredTypes.runtimeBuiltinType("int");
        DECL_INT = InferredTypes.declaredBuiltinType("int");
        FLOAT = InferredTypes.runtimeBuiltinType("float");
        DECL_FLOAT = InferredTypes.declaredBuiltinType("float");
        COMPLEX = InferredTypes.runtimeBuiltinType("complex");
        DECL_COMPLEX = InferredTypes.declaredBuiltinType("complex");
        STR = InferredTypes.runtimeBuiltinType("str");
        DECL_STR = InferredTypes.declaredBuiltinType("str");
        SET = InferredTypes.runtimeBuiltinType("set");
        DECL_SET = InferredTypes.declaredBuiltinType("set");
        DICT = InferredTypes.runtimeBuiltinType("dict");
        DECL_DICT = InferredTypes.declaredBuiltinType("dict");
        LIST = InferredTypes.runtimeBuiltinType("list");
        DECL_LIST = InferredTypes.declaredBuiltinType("list");
        TUPLE = InferredTypes.runtimeBuiltinType("tuple");
        DECL_TUPLE = InferredTypes.declaredBuiltinType("tuple");
        NONE = InferredTypes.runtimeBuiltinType("NoneType");
        DECL_NONE = InferredTypes.declaredBuiltinType("NoneType");
        BOOL = InferredTypes.runtimeBuiltinType("bool");
        DECL_BOOL = InferredTypes.declaredBuiltinType("bool");
        TYPE = InferredTypes.runtimeBuiltinType("type");
        DECL_TYPE = InferredTypes.declaredBuiltinType("type");
        HARDCODED_COMPATIBLE_TYPES = new HashMap<String, Set<String>>();
        HARDCODED_INCOMPATIBLE_TYPES = Set.of(Set.of("tuple", "list"));
        HARDCODED_COMPATIBLE_TYPES.put("int", new HashSet<String>(Arrays.asList("float", "complex")));
        HARDCODED_COMPATIBLE_TYPES.put("float", new HashSet<String>(List.of("complex")));
        HARDCODED_COMPATIBLE_TYPES.put("bool", new HashSet<String>(List.of("float")));
        HARDCODED_COMPATIBLE_TYPES.put("bytearray", new HashSet<String>(Arrays.asList(BYTES, "str", UNICODE)));
        HARDCODED_COMPATIBLE_TYPES.put("memoryview", new HashSet<String>(Arrays.asList(BYTES, "str", UNICODE)));
        HARDCODED_COMPATIBLE_TYPES.put("str", new HashSet<String>(Arrays.asList(UNICODE, BYTES)));
        HARDCODED_COMPATIBLE_TYPES.put(BYTES, new HashSet<String>(Collections.singletonList("str")));
        HARDCODED_COMPATIBLE_TYPES.put("dict", Set.of("typing.TypedDict"));
        BUILTINS_TYPE_CATEGORY = new HashMap<String, String>();
        BUILTINS_TYPE_CATEGORY.put("str", "str");
        BUILTINS_TYPE_CATEGORY.put("int", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("float", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("complex", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("bool", NUMBER);
        BUILTINS_TYPE_CATEGORY.put("list", "list");
        BUILTINS_TYPE_CATEGORY.put("set", "set");
        BUILTINS_TYPE_CATEGORY.put("frozenset", "set");
        BUILTINS_TYPE_CATEGORY.put("dict", "dict");
        BUILTINS_TYPE_CATEGORY.put("tuple", "tuple");
        OPTIONAL_SYMBOL = new SymbolImpl("Optional", "typing.Optional");
        EXCLUDING_TYPE_VAR_FQN_PATTERNS = Set.of("^builtins\\.object$", "^_ctypes\\._CanCastTo$");
    }
}

