/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.cfg.fixpoint.ForwardAnalysis;
import org.sonar.python.cfg.fixpoint.ProgramState;
import org.sonar.python.tree.NameImpl;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeInference;
import org.sonar.python.types.TypeInferenceProgramState;

class FlowSensitiveTypeInference
extends ForwardAnalysis {
    private final Set<Symbol> trackedVars;
    private final Map<QualifiedExpression, TypeInference.MemberAccess> memberAccessesByQualifiedExpr;
    private final Map<Statement, TypeInference.Assignment> assignmentsByAssignmentStatement;
    private final Map<String, InferredType> parameterTypesByName;

    public FlowSensitiveTypeInference(Set<Symbol> trackedVars, Map<QualifiedExpression, TypeInference.MemberAccess> memberAccessesByQualifiedExpr, Map<Statement, TypeInference.Assignment> assignmentsByAssignmentStatement, Map<String, InferredType> parameterTypesByName) {
        this.trackedVars = trackedVars;
        this.memberAccessesByQualifiedExpr = memberAccessesByQualifiedExpr;
        this.assignmentsByAssignmentStatement = assignmentsByAssignmentStatement;
        this.parameterTypesByName = parameterTypesByName;
    }

    @Override
    public ProgramState initialState() {
        TypeInferenceProgramState initialState = new TypeInferenceProgramState();
        Iterator<Symbol> iterator = this.trackedVars.iterator();
        while (iterator.hasNext()) {
            Symbol variable;
            InferredType inferredType = this.parameterTypesByName.get((variable = iterator.next()).name());
            initialState.setTypes(variable, inferredType != null ? Collections.singleton(inferredType) : Collections.emptySet());
        }
        return initialState;
    }

    @Override
    public void updateProgramState(Tree element, ProgramState programState) {
        TypeInferenceProgramState state = (TypeInferenceProgramState)programState;
        if (element.is(Tree.Kind.ASSIGNMENT_STMT)) {
            AssignmentStatement assignment = (AssignmentStatement)element;
            this.updateTree(assignment.assignedValue(), state);
            this.handleAssignment(assignment, state);
            assignment.lhsExpressions().forEach(lhs -> this.updateTree((Tree)lhs, state));
        } else if (element.is(Tree.Kind.COMPOUND_ASSIGNMENT)) {
            this.updateTree(element, state);
        } else if (element.is(Tree.Kind.ANNOTATED_ASSIGNMENT)) {
            AnnotatedAssignment assignment = (AnnotatedAssignment)element;
            Expression assignedValue = assignment.assignedValue();
            if (assignedValue != null) {
                this.updateTree(assignedValue, state);
                this.handleAssignment(assignment, state);
                this.updateTree(assignment.variable(), state);
            }
        } else {
            element.accept(new IsInstanceVisitor(state));
            this.updateTree(element, state);
        }
    }

    private void updateTree(Tree tree, final TypeInferenceProgramState state) {
        tree.accept(new BaseTreeVisitor(){

            @Override
            public void visitName(Name name) {
                Optional.ofNullable(name.symbol()).ifPresent(symbol -> {
                    Set<InferredType> inferredTypes = state.getTypes((Symbol)symbol);
                    if (!inferredTypes.isEmpty()) {
                        ((NameImpl)name).setInferredType(InferredTypes.union(inferredTypes.stream()));
                    }
                });
                super.visitName(name);
            }

            @Override
            public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            }

            @Override
            public void visitQualifiedExpression(QualifiedExpression qualifiedExpression) {
                super.visitQualifiedExpression(qualifiedExpression);
                Optional.ofNullable(FlowSensitiveTypeInference.this.memberAccessesByQualifiedExpr.get(qualifiedExpression)).ifPresent(memberAccess -> memberAccess.propagate(Collections.emptySet()));
            }
        });
    }

    private void handleAssignment(Statement assignmentStatement, TypeInferenceProgramState programState) {
        Optional.ofNullable(this.assignmentsByAssignmentStatement.get(assignmentStatement)).ifPresent(assignment -> {
            if (this.trackedVars.contains(assignment.lhs)) {
                Expression rhs = assignment.rhs;
                if (rhs.is(Tree.Kind.NAME) && this.trackedVars.contains(((Name)rhs).symbol())) {
                    Symbol rhsSymbol = ((Name)rhs).symbol();
                    programState.setTypes(assignment.lhs, programState.getTypes(rhsSymbol));
                } else {
                    programState.setTypes(assignment.lhs, Collections.singleton(rhs.type()));
                }
            }
        });
    }

    private static class IsInstanceVisitor
    extends BaseTreeVisitor {
        private final TypeInferenceProgramState state;

        public IsInstanceVisitor(TypeInferenceProgramState state) {
            this.state = state;
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            Symbol firstArgumentSymbol;
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol != null && "isinstance".equals(calleeSymbol.fullyQualifiedName()) && callExpression.arguments().size() == 2 && (firstArgumentSymbol = this.getFirstArgumentSymbol(callExpression)) != null) {
                this.state.setTypes(firstArgumentSymbol, Collections.singleton(InferredTypes.anyType()));
            }
            super.visitCallExpression(callExpression);
        }

        @CheckForNull
        private Symbol getFirstArgumentSymbol(CallExpression callExpression) {
            Name variableName;
            Argument argument = callExpression.arguments().get(0);
            if (argument.is(Tree.Kind.REGULAR_ARGUMENT) && ((RegularArgument)argument).expression().is(Tree.Kind.NAME) && this.state.getTypes((variableName = (Name)((RegularArgument)argument).expression()).symbol()).stream().anyMatch(InferredTypes::containsDeclaredType)) {
                return variableName.symbol();
            }
            return null;
        }
    }
}

