/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.tree.PyTree;

public class WithStatementImpl
extends PyTree
implements WithStatement {
    private final Token withKeyword;
    @Nullable
    private final Token openParens;
    private final List<WithItem> withItems;
    private final List<Token> commas;
    private final Token newLine;
    private final Token indent;
    private final StatementList statements;
    private final Token dedent;
    private final Token asyncKeyword;
    private final boolean isAsync;
    private final Token colon;
    @Nullable
    private final Token closeParens;

    public WithStatementImpl(Token withKeyword, @Nullable Token openParens, List<WithItem> withItems, List<Token> commas, @Nullable Token closeParens, Token colon, @Nullable Token newLine, @Nullable Token indent, StatementList statements, @Nullable Token dedent, @Nullable Token asyncKeyword) {
        this.withKeyword = withKeyword;
        this.openParens = openParens;
        this.withItems = withItems;
        this.commas = commas;
        this.closeParens = closeParens;
        this.colon = colon;
        this.newLine = newLine;
        this.indent = indent;
        this.statements = statements;
        this.dedent = dedent;
        this.asyncKeyword = asyncKeyword;
        this.isAsync = asyncKeyword != null;
    }

    @Override
    public Token withKeyword() {
        return this.withKeyword;
    }

    @Override
    public List<WithItem> withItems() {
        return this.withItems;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList statements() {
        return this.statements;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WITH_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWithStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Token> children = new ArrayList<Token>(Arrays.asList(this.asyncKeyword, this.withKeyword, this.openParens));
        int i = 0;
        for (Tree tree : this.withItems) {
            children.add((Token)tree);
            if (i < this.commas.size()) {
                children.add((Token)((Tree)this.commas.get(i)));
            }
            ++i;
        }
        children.addAll(Arrays.asList(this.closeParens, this.colon, this.newLine, this.indent, this.statements, this.dedent));
        return children.stream().filter(Objects::nonNull).toList();
    }

    public static class WithItemImpl
    extends PyTree
    implements WithItem {
        private final Expression test;
        private final Token as;
        private final Expression expr;

        public WithItemImpl(Expression test, @Nullable Token as, @Nullable Expression expr) {
            this.test = test;
            this.as = as;
            this.expr = expr;
        }

        @Override
        public Expression test() {
            return this.test;
        }

        @Override
        @CheckForNull
        public Token as() {
            return this.as;
        }

        @Override
        @CheckForNull
        public Expression expression() {
            return this.expr;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.WITH_ITEM;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWithItem(this);
        }

        @Override
        public List<Tree> computeChildren() {
            return Stream.of(this.test, this.as, this.expr).filter(Objects::nonNull).toList();
        }
    }
}

