/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeParam;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.python.tree.PyTree;

public class TypeParamsImpl
extends PyTree
implements TypeParams {
    private final Token leftPar;
    private final List<TypeParam> typeParamsList;
    private final List<Token> commas;
    private final Token rightPar;

    public TypeParamsImpl(Token leftPar, List<TypeParam> typeParamsList, List<Token> commas, Token rightPar) {
        this.leftPar = leftPar;
        this.typeParamsList = typeParamsList;
        this.commas = commas;
        this.rightPar = rightPar;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParams(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_PARAMS;
    }

    @Override
    public Token leftBracket() {
        return this.leftPar;
    }

    @Override
    public List<TypeParam> typeParamsList() {
        return this.typeParamsList;
    }

    @Override
    public Token rightBracket() {
        return this.rightPar;
    }

    @Override
    List<Tree> computeChildren() {
        Stream.Builder<Token> builder = Stream.builder();
        builder.add(this.leftPar);
        this.typeParamsList.forEach(builder::add);
        this.commas.forEach(builder::add);
        builder.add(this.rightPar);
        return builder.build().filter(Objects::nonNull).sorted(Comparator.comparing(t -> t.firstToken().line()).thenComparing(t -> t.firstToken().column())).toList();
    }
}

