/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.TypeParam;
import org.sonar.python.tree.PyTree;

public class TypeParamImpl
extends PyTree
implements TypeParam {
    private final Token starToken;
    private final Name name;
    private final TypeAnnotation annotation;

    public TypeParamImpl(@Nullable Token starToken, Name name, @Nullable TypeAnnotation annotation) {
        this.starToken = starToken;
        this.name = name;
        this.annotation = annotation;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParam(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_PARAM;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.starToken;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public TypeAnnotation typeAnnotation() {
        return this.annotation;
    }

    @Override
    List<Tree> computeChildren() {
        return Stream.of(this.starToken, this.name, this.annotation).filter(Objects::nonNull).toList();
    }
}

