/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.python.tree.PyTree;

public class TypeAnnotationImpl
extends PyTree
implements TypeAnnotation {
    private final Token dash;
    private final Token gt;
    private final Token colonToken;
    private final Token starToken;
    private final Expression expression;
    private final Tree.Kind kind;

    public TypeAnnotationImpl(Token colonToken, @Nullable Token starToken, Expression expression, Tree.Kind kind) {
        this.colonToken = colonToken;
        this.dash = null;
        this.gt = null;
        this.starToken = starToken;
        this.expression = expression;
        this.kind = kind;
    }

    public TypeAnnotationImpl(Token dash, Token gt, Expression expression) {
        this.colonToken = null;
        this.dash = dash;
        this.gt = gt;
        this.starToken = null;
        this.expression = expression;
        this.kind = Tree.Kind.RETURN_TYPE_ANNOTATION;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeAnnotation(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.dash, this.gt, this.colonToken, this.starToken, this.expression).filter(Objects::nonNull).toList();
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }
}

