/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAliasStatement;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class TypeAliasStatementImpl
extends SimpleStatement
implements TypeAliasStatement {
    private final Token typeKeyword;
    private final Name name;
    private final TypeParams typeParams;
    private final Token equalToken;
    private final Expression expression;
    private final Separators separator;

    public TypeAliasStatementImpl(Token typeKeyword, Name name, @Nullable TypeParams typeParams, Token equalToken, Expression expression, Separators separator) {
        this.typeKeyword = typeKeyword;
        this.name = name;
        this.typeParams = typeParams;
        this.equalToken = equalToken;
        this.expression = expression;
        this.separator = separator;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeAliasStatement(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_ALIAS_STMT;
    }

    @Override
    public Token typeKeyword() {
        return this.typeKeyword;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public TypeParams typeParams() {
        return this.typeParams;
    }

    @Override
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    List<Tree> computeChildren() {
        Stream.Builder<Token> builder = Stream.builder().add(this.typeKeyword()).add((Token)((Object)this.name())).add((Token)((Object)this.typeParams())).add(this.equalToken()).add((Token)((Object)this.expression()));
        this.separator.elements().forEach(builder::add);
        return builder.build().filter(Objects::nonNull).toList();
    }

    @Override
    public Token separator() {
        return this.separator.last();
    }
}

