/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.TokenLocation;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;

public class TreeUtils {
    private static final Set<PythonTokenType> WHITESPACE_TOKEN_TYPES = EnumSet.of(PythonTokenType.NEWLINE, PythonTokenType.INDENT, PythonTokenType.DEDENT);

    private TreeUtils() {
    }

    @CheckForNull
    public static Tree firstAncestor(Tree tree, Predicate<Tree> predicate) {
        for (Tree currentParent = tree.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (!predicate.test(currentParent)) continue;
            return currentParent;
        }
        return null;
    }

    @CheckForNull
    public static Tree firstAncestorOfKind(Tree tree, Tree.Kind ... kinds) {
        return TreeUtils.firstAncestor(tree, t -> t.is(kinds));
    }

    @CheckForNull
    public static <T extends Tree> T firstAncestorOfClass(Tree tree, Class<T> clazz) {
        return (T)TreeUtils.firstAncestor(tree, clazz::isInstance);
    }

    public static Collector<Tree, ?, Map<Tree, Tree>> groupAssignmentByParentStatementList() {
        return Collectors.toMap(tree -> TreeUtils.firstAncestor(tree, parent -> parent.is(Tree.Kind.STATEMENT_LIST)), Function.identity(), (t1, t2) -> Stream.of(t1, t2).min(TreeUtils.getTreeByPositionComparator()).get());
    }

    public static Comparator<Tree> getTreeByPositionComparator() {
        return Comparator.comparing(t -> t.firstToken().pythonLine().line()).thenComparing(t -> t.firstToken().pythonColumn());
    }

    public static List<Token> tokens(Tree tree) {
        if (tree.is(Tree.Kind.TOKEN)) {
            return Collections.singletonList((Token)tree);
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Tree child : tree.children()) {
            if (child.is(Tree.Kind.TOKEN)) {
                tokens.add((Token)child);
                continue;
            }
            tokens.addAll(TreeUtils.tokens(child));
        }
        return tokens;
    }

    public static List<Token> nonWhitespaceTokens(Tree tree) {
        return TreeUtils.tokens(tree).stream().filter(t -> !WHITESPACE_TOKEN_TYPES.contains(t.type())).toList();
    }

    public static boolean hasDescendant(Tree tree, Predicate<Tree> predicate) {
        return tree.children().stream().anyMatch(child -> predicate.test((Tree)child) || TreeUtils.hasDescendant(child, predicate));
    }

    public static Stream<Expression> flattenTuples(Expression expression) {
        if (expression.is(Tree.Kind.TUPLE)) {
            Tuple tuple = (Tuple)expression;
            return tuple.elements().stream().flatMap(TreeUtils::flattenTuples);
        }
        return Stream.of(expression);
    }

    public static Optional<Symbol> getSymbolFromTree(@Nullable Tree tree) {
        if (tree instanceof HasSymbol) {
            HasSymbol hasSymbol = (HasSymbol)((Object)tree);
            return Optional.ofNullable(hasSymbol.symbol());
        }
        return Optional.empty();
    }

    @CheckForNull
    public static ClassSymbol getClassSymbolFromDef(@Nullable ClassDef classDef) {
        if (classDef == null) {
            return null;
        }
        Symbol classNameSymbol = classDef.name().symbol();
        if (classNameSymbol == null) {
            throw new IllegalStateException("A ClassDef should always have a non-null symbol!");
        }
        if (classNameSymbol.kind() == Symbol.Kind.CLASS) {
            return (ClassSymbol)classNameSymbol;
        }
        return null;
    }

    @CheckForNull
    public static ClassDef getEnclosingClassDef(Tree tree) {
        Tree enclosingClass = TreeUtils.firstAncestorOfKind(tree, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF);
        if (enclosingClass instanceof ClassDef) {
            ClassDef classDef = (ClassDef)enclosingClass;
            return classDef;
        }
        return null;
    }

    public static List<String> getParentClassesFQN(ClassDef classDef) {
        return TreeUtils.getParentClasses(TreeUtils.getClassSymbolFromDef(classDef), new HashSet<ClassSymbol>()).stream().map(Symbol::fullyQualifiedName).filter(Objects::nonNull).toList();
    }

    private static List<Symbol> getParentClasses(@Nullable ClassSymbol classSymbol, Set<ClassSymbol> visitedSymbols) {
        ArrayList<Symbol> superClasses = new ArrayList<Symbol>();
        if (classSymbol == null || visitedSymbols.contains(classSymbol)) {
            return superClasses;
        }
        visitedSymbols.add(classSymbol);
        for (Symbol symbol : classSymbol.superClasses()) {
            superClasses.add(symbol);
            if (!(symbol instanceof ClassSymbol)) continue;
            ClassSymbol superClassSymbol = (ClassSymbol)symbol;
            superClasses.addAll(TreeUtils.getParentClasses(superClassSymbol, visitedSymbols));
        }
        return superClasses;
    }

    @CheckForNull
    public static FunctionSymbol getFunctionSymbolFromDef(@Nullable FunctionDef functionDef) {
        if (functionDef == null) {
            return null;
        }
        Symbol functionNameSymbol = functionDef.name().symbol();
        if (functionNameSymbol == null) {
            throw new IllegalStateException("A FunctionDef should always have a non-null symbol!");
        }
        if (functionNameSymbol.kind() == Symbol.Kind.FUNCTION) {
            return (FunctionSymbol)functionNameSymbol;
        }
        return null;
    }

    public static List<Parameter> nonTupleParameters(FunctionDef functionDef) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        return parameterList.nonTuple();
    }

    public static List<Parameter> positionalParameters(FunctionDef functionDef) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (AnyParameter anyParameter : parameterList.all()) {
            if (!(anyParameter instanceof Parameter)) continue;
            Parameter parameter = (Parameter)anyParameter;
            Token starToken = parameter.starToken();
            if (parameter.name() == null && starToken != null) {
                if (!"*".equals(starToken.value())) continue;
                return result;
            }
            result.add(parameter);
        }
        return result;
    }

    public static List<FunctionDef> topLevelFunctionDefs(ClassDef classDef) {
        CollectFunctionDefsVisitor visitor = new CollectFunctionDefsVisitor();
        classDef.body().accept(visitor);
        return visitor.functionDefs;
    }

    public static int findIndentationSize(Tree tree) {
        Tree parent = tree.parent();
        if (parent == null) {
            return TreeUtils.findIndentDownTree(tree);
        }
        Token treeToken = tree.firstToken();
        Token parentToken = parent.firstToken();
        if (treeToken.pythonLine().line() != parentToken.pythonLine().line()) {
            return treeToken.pythonColumn() - parentToken.pythonColumn();
        }
        return TreeUtils.findIndentationSize(parent);
    }

    private static int findIndentDownTree(Tree parent) {
        Token parentToken = parent.firstToken();
        return parent.children().stream().map(child -> {
            Token childToken = child.firstToken();
            if (childToken.pythonLine().line() > parentToken.pythonLine().line() && childToken.pythonColumn() > parentToken.pythonColumn()) {
                return childToken.pythonColumn() - parentToken.pythonColumn();
            }
            return TreeUtils.findIndentDownTree(child);
        }).filter(i -> i > 0).findFirst().orElse(0);
    }

    @CheckForNull
    public static RegularArgument argumentByKeyword(String keyword, List<Argument> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argument = arguments.get(i);
            if (!TreeUtils.hasKeyword(argument, keyword)) continue;
            return (RegularArgument)argument;
        }
        return null;
    }

    @CheckForNull
    public static RegularArgument nthArgumentOrKeyword(int argPosition, String keyword, List<Argument> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            RegularArgument regularArgument;
            Argument argument = arguments.get(i);
            if (TreeUtils.hasKeyword(argument, keyword)) {
                return (RegularArgument)argument;
            }
            if (!argument.is(Tree.Kind.REGULAR_ARGUMENT) || (regularArgument = (RegularArgument)argument).keywordArgument() != null || argPosition != i) continue;
            return regularArgument;
        }
        return null;
    }

    public static Optional<RegularArgument> nthArgumentOrKeywordOptional(int argPosition, String keyword, List<Argument> arguments) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword(argPosition, keyword, arguments));
    }

    private static boolean hasKeyword(Argument argument, String keyword) {
        if (argument.is(Tree.Kind.REGULAR_ARGUMENT)) {
            Name keywordArgument = ((RegularArgument)argument).keywordArgument();
            return keywordArgument != null && keywordArgument.name().equals(keyword);
        }
        return false;
    }

    public static boolean isBooleanLiteral(Tree tree) {
        if (tree.is(Tree.Kind.NAME)) {
            String name = ((Name)tree).name();
            return "True".equals(name) || "False".equals(name);
        }
        return false;
    }

    public static String nameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return ((Name)expression).name();
        }
        return null;
    }

    public static Optional<String> nameFromQualifiedOrCallExpression(Expression expression) {
        return Optional.ofNullable(TreeUtils.nameFromExpression(expression)).or(() -> TreeUtils.toOptionalInstanceOf(QualifiedExpression.class, expression).map(TreeUtils::nameFromQualifiedExpression)).or(() -> TreeUtils.toOptionalInstanceOf(CallExpression.class, expression).map(CallExpression::callee).flatMap(TreeUtils::nameFromExpressionOrQualifiedExpression));
    }

    public static Optional<String> nameFromExpressionOrQualifiedExpression(Expression expression) {
        return TreeUtils.toOptionalInstanceOf(QualifiedExpression.class, expression).map(TreeUtils::nameFromQualifiedExpression).or(() -> Optional.ofNullable(TreeUtils.nameFromExpression(expression)));
    }

    public static String nameFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        Object exprName = qualifiedExpression.name().name();
        Expression qualifier = qualifiedExpression.qualifier();
        String nameOfQualifier = TreeUtils.decoratorNameFromExpression(qualifier);
        exprName = nameOfQualifier != null ? nameOfQualifier + "." + (String)exprName : null;
        return exprName;
    }

    @CheckForNull
    public static String decoratorNameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return ((Name)expression).name();
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.nameFromQualifiedExpression((QualifiedExpression)expression);
        }
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            return TreeUtils.decoratorNameFromExpression(((CallExpression)expression).callee());
        }
        return null;
    }

    public static Optional<Token> asyncTokenOfEnclosingFunction(Tree tree) {
        Tree enclosingFunction = TreeUtils.firstAncestorOfKind(tree, Tree.Kind.FUNCDEF);
        return Optional.ofNullable(enclosingFunction).flatMap(TreeUtils.toOptionalInstanceOfMapper(FunctionDef.class)).map(FunctionDef::asyncKeyword);
    }

    public static boolean isFunctionWithGivenDecoratorFQN(Tree tree, String decoratorFQN) {
        if (!tree.is(Tree.Kind.FUNCDEF)) {
            return false;
        }
        return ((FunctionDef)tree).decorators().stream().anyMatch(d -> TreeUtils.isDecoratorWithFQN(d, decoratorFQN));
    }

    public static boolean isDecoratorWithFQN(Decorator decorator, String fullyQualifiedName) {
        return Optional.of(decorator.expression()).flatMap(TreeUtils::getSymbolFromTree).map(Symbol::fullyQualifiedName).filter(fullyQualifiedName::equals).isPresent();
    }

    public static Optional<String> fullyQualifiedNameFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        String exprName = qualifiedExpression.name().name();
        Expression qualifier = qualifiedExpression.qualifier();
        return TreeUtils.fullyQualifiedNameFromExpression(qualifier).map(nameOfQualifier -> nameOfQualifier + "." + exprName);
    }

    public static Optional<String> fullyQualifiedNameFromExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            Symbol symbol = ((Name)expression).symbol();
            return Optional.of(Optional.ofNullable(symbol).map(Symbol::fullyQualifiedName).orElse(((Name)expression).name()));
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.fullyQualifiedNameFromQualifiedExpression((QualifiedExpression)expression);
        }
        if (expression.is(Tree.Kind.CALL_EXPR)) {
            return TreeUtils.fullyQualifiedNameFromExpression(((CallExpression)expression).callee());
        }
        return Optional.empty();
    }

    @CheckForNull
    public static LocationInFile locationInFile(Tree tree, @Nullable String fileId) {
        if (fileId == null) {
            return null;
        }
        TokenLocation firstToken = new TokenLocation(tree.firstToken());
        TokenLocation lastToken = new TokenLocation(tree.lastToken());
        return new LocationInFile(fileId, firstToken.startLine(), firstToken.startLineOffset(), lastToken.endLine(), lastToken.endLineOffset());
    }

    public static Token getTreeSeparatorOrLastToken(Tree tree) {
        Statement statement;
        Token separator;
        if (tree instanceof Statement && (separator = (statement = (Statement)tree).separator()) != null) {
            return separator;
        }
        return tree.lastToken();
    }

    public static <T extends Tree> Function<Tree, T> toInstanceOfMapper(Class<T> castToClass) {
        return TreeUtils.toOptionalInstanceOfMapper(castToClass).andThen(t -> t.orElse(null));
    }

    public static <T extends Tree> Function<Tree, Optional<T>> toOptionalInstanceOfMapper(Class<T> castToClass) {
        return tree -> TreeUtils.toOptionalInstanceOf(castToClass, tree);
    }

    public static <T extends Tree> Optional<T> toOptionalInstanceOf(Class<T> castToClass, @Nullable Tree tree) {
        return Optional.ofNullable(tree).filter(castToClass::isInstance).map(castToClass::cast);
    }

    public static <T extends Tree> Function<Tree, Stream<T>> toStreamInstanceOfMapper(Class<T> castToClass) {
        return tree -> TreeUtils.toOptionalInstanceOf(castToClass, tree).map(Stream::of).orElse(Stream.empty());
    }

    public static Optional<Tree> firstChild(Tree tree, Predicate<Tree> filter) {
        if (filter.test(tree)) {
            return Optional.of(tree);
        }
        return tree.children().stream().map(c -> TreeUtils.firstChild(c, filter)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    public static String treeToString(Tree tree, boolean renderMultiline) {
        int lastLine;
        int firstLine;
        if (!renderMultiline && (firstLine = tree.firstToken().pythonLine().line()) != (lastLine = tree.lastToken().pythonLine().line())) {
            return null;
        }
        List<Token> tokens = TreeUtils.tokens(tree);
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (i > 0) {
                Token previous = tokens.get(i - 1);
                int spaceBetween = token.column() - previous.column() - previous.value().length();
                if (spaceBetween < 0) {
                    spaceBetween = token.column();
                }
                valueBuilder.append(" ".repeat(spaceBetween));
            }
            valueBuilder.append(token.value());
        }
        return valueBuilder.toString();
    }

    public static List<String> dottedNameToPartFqn(DottedName dottedName) {
        return dottedName.names().stream().map(Name::name).toList();
    }

    public static Optional<String> stringValueFromNameOrQualifiedExpression(Expression expression) {
        if (expression.is(Tree.Kind.NAME)) {
            return Optional.of(((Name)expression).name());
        }
        if (expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.extractStringValueFromQualifiedExpression((QualifiedExpression)expression);
        }
        return Optional.empty();
    }

    private static Optional<String> extractStringValueFromQualifiedExpression(QualifiedExpression qualifiedExpression) {
        String memberName = qualifiedExpression.name().name();
        Expression qualifier = qualifiedExpression.qualifier();
        if (qualifier.is(Tree.Kind.NAME)) {
            return Optional.of(((Name)qualifier).name() + "." + memberName);
        }
        if (qualifier.is(Tree.Kind.QUALIFIED_EXPR)) {
            return TreeUtils.extractStringValueFromQualifiedExpression((QualifiedExpression)qualifier).map(qualifiedName -> qualifiedName + "." + memberName);
        }
        return Optional.empty();
    }

    public static PythonType inferSingleAssignedExpressionType(Expression expr) {
        if (expr.typeV2() != PythonType.UNKNOWN) {
            return expr.typeV2();
        }
        if (expr instanceof Name) {
            Name name = (Name)expr;
            return TreeUtils.inferSingleAssignedNameType(name);
        }
        if (expr instanceof QualifiedExpression) {
            QualifiedExpression qualifiedExpr = (QualifiedExpression)expr;
            PythonType qualifierType = TreeUtils.inferSingleAssignedExpressionType(qualifiedExpr.qualifier());
            return qualifierType.resolveMember(qualifiedExpr.name().name()).orElse(PythonType.UNKNOWN);
        }
        return PythonType.UNKNOWN;
    }

    private static PythonType inferSingleAssignedNameType(Name name) {
        Optional<Name> bindingName = Optional.ofNullable(name.symbolV2()).flatMap(SymbolV2::getSingleBindingUsage).map(UsageV2::tree).flatMap(TreeUtils.toOptionalInstanceOfMapper(Name.class));
        return bindingName.map(Expression::typeV2).orElse(PythonType.UNKNOWN);
    }

    public static Set<SymbolV2> getLocalVariableSymbols(FunctionDef functionDef) {
        return functionDef.localVariables().stream().flatMap(symbol -> symbol.usages().stream()).map(Usage::tree).flatMap(TreeUtils.toStreamInstanceOfMapper(Name.class)).map(Name::symbolV2).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static class CollectFunctionDefsVisitor
    extends BaseTreeVisitor {
        private List<FunctionDef> functionDefs = new ArrayList<FunctionDef>();

        private CollectFunctionDefsVisitor() {
        }

        @Override
        public void visitClassDef(ClassDef pyClassDefTree) {
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.functionDefs.add(pyFunctionDefTree);
        }
    }
}

