/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.PythonLine;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TriviaImpl;

public class TokenImpl
extends PyTree
implements org.sonar.plugins.python.api.tree.Token {
    private Token token;
    private List<Trivia> trivia;
    private Integer line;
    private Integer column;
    private int includedEscapeChars;
    private boolean isCompressed = false;

    public TokenImpl(Token token) {
        this.token = token;
        this.trivia = token.getTrivia().stream().map(tr -> new TriviaImpl(new TokenImpl(tr.getToken()))).collect(Collectors.toList());
    }

    public TokenImpl(Token token, int line, int column, int includedEscapeChars, List<Trivia> trivia, boolean isCompressed) {
        this.token = token;
        this.line = line;
        this.column = column;
        this.includedEscapeChars = includedEscapeChars;
        this.trivia = trivia;
        this.isCompressed = isCompressed;
    }

    @Override
    public String value() {
        return this.token.getValue();
    }

    @Override
    public int line() {
        return this.line != null ? this.line.intValue() : this.pythonLine().line();
    }

    @Override
    public int column() {
        return this.column != null ? this.column.intValue() : this.pythonColumn();
    }

    @Override
    public PythonLine pythonLine() {
        return new PythonLine(this.token.getLine());
    }

    @Override
    public int includedEscapeChars() {
        return this.includedEscapeChars;
    }

    @Override
    public int pythonColumn() {
        return this.token.getColumn();
    }

    @Override
    public List<Trivia> trivia() {
        return this.trivia;
    }

    @Override
    public TokenType type() {
        return this.token.getType();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitToken(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.emptyList();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TOKEN;
    }

    @Override
    public org.sonar.plugins.python.api.tree.Token firstToken() {
        return this;
    }

    @Override
    public org.sonar.plugins.python.api.tree.Token lastToken() {
        return this;
    }

    @Override
    public int valueLength() {
        return this.value().length() + this.includedEscapeChars();
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }
}

