/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.python.tree.PyTree;

public class SubscriptionExpressionImpl
extends PyTree
implements SubscriptionExpression {
    private final Expression object;
    private final Token lBracket;
    private final ExpressionList subscripts;
    private final Token rBracket;
    private PythonType pythonType = PythonType.UNKNOWN;

    public SubscriptionExpressionImpl(Expression object, Token lBracket, ExpressionList subscripts, Token rBracket) {
        this.object = object;
        this.lBracket = lBracket;
        this.subscripts = subscripts;
        this.rBracket = rBracket;
    }

    @Override
    public Expression object() {
        return this.object;
    }

    @Override
    public Token leftBracket() {
        return this.lBracket;
    }

    @Override
    public ExpressionList subscripts() {
        return this.subscripts;
    }

    @Override
    public Token rightBracket() {
        return this.rBracket;
    }

    @Override
    public PythonType typeV2() {
        return this.pythonType;
    }

    public SubscriptionExpression typeV2(PythonType pythonType) {
        this.pythonType = pythonType;
        return this;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitSubscriptionExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.object, this.lBracket, this.subscripts, this.rBracket).filter(Objects::nonNull).toList();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.SUBSCRIPTION;
    }
}

