/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.FormattedExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.tree.TreeUtils;

public class StringElementImpl
extends PyTree
implements StringElement {
    private final String value;
    private final Token token;
    private List<Tree> fStringMiddles = new ArrayList<Tree>();
    private final Token fstringEnd;

    public StringElementImpl(Token token, List<Tree> fStringMiddles, @Nullable Token fstringEnd) {
        this.token = token;
        this.fstringEnd = fstringEnd;
        this.fStringMiddles = fStringMiddles;
        this.value = StringElementImpl.computeValue(token, fstringEnd, fStringMiddles);
    }

    @Override
    public Token firstToken() {
        return this.token;
    }

    @Override
    public Token lastToken() {
        return this.fstringEnd != null ? this.fstringEnd : this.token;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.STRING_ELEMENT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitStringElement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.token);
        children.addAll(this.fStringMiddles);
        children.add(this.fstringEnd);
        return children.stream().filter(Objects::nonNull).toList();
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String trimmedQuotesValue() {
        if (this.token.type() == PythonTokenType.FSTRING_MIDDLE) {
            return this.value;
        }
        String trimmed = this.removePrefix(this.value);
        int startIndex = 1;
        if (StringElementImpl.isTripleQuote(trimmed)) {
            startIndex = 3;
        }
        return trimmed.substring(startIndex, trimmed.length() - startIndex);
    }

    @Override
    public String prefix() {
        return this.value.substring(0, this.prefixLength(this.value));
    }

    @Override
    public boolean isTripleQuoted() {
        return StringElementImpl.isTripleQuote(this.removePrefix(this.value));
    }

    @Override
    public boolean isInterpolated() {
        String prefix = this.prefix();
        return prefix.indexOf(102) >= 0 || prefix.indexOf(70) >= 0;
    }

    @Override
    public boolean isTemplate() {
        String prefix = this.prefix();
        return prefix.indexOf(116) >= 0 || prefix.indexOf(84) >= 0;
    }

    @Override
    public List<FormattedExpression> formattedExpressions() {
        return this.fStringMiddles.stream().filter(FormattedExpression.class::isInstance).map(FormattedExpression.class::cast).toList();
    }

    private static boolean isTripleQuote(String trimmed) {
        if (trimmed.length() >= 6) {
            char startChar = trimmed.charAt(0);
            return startChar == trimmed.charAt(1) && startChar == trimmed.charAt(2);
        }
        return false;
    }

    private String removePrefix(String value) {
        return value.substring(this.prefixLength(value));
    }

    private static boolean isCharQuote(char character) {
        return character == '\'' || character == '\"';
    }

    private int prefixLength(String value) {
        int prefixLength = 0;
        if (this.token.type() == PythonTokenType.FSTRING_MIDDLE) {
            return 0;
        }
        while (!StringElementImpl.isCharQuote(value.charAt(prefixLength))) {
            ++prefixLength;
        }
        return prefixLength;
    }

    public int contentStartIndex() {
        int prefixLength = this.prefixLength(this.value);
        if (this.token.type() == PythonTokenType.FSTRING_MIDDLE) {
            return 0;
        }
        if (StringElementImpl.isTripleQuote(this.value.substring(prefixLength))) {
            return prefixLength + 3;
        }
        return prefixLength + 1;
    }

    private static final String computeValue(Token token, @Nullable Token fstringEnd, List<Tree> fStringMiddles) {
        String stringContent = fStringMiddles.stream().map(exp -> TreeUtils.treeToString(exp, false)).filter(Objects::nonNull).collect(Collectors.joining());
        String end = fstringEnd == null ? "" : fstringEnd.value();
        return String.join((CharSequence)"", token.value(), stringContent, end);
    }
}

