/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class QualifiedExpressionImpl
extends PyTree
implements QualifiedExpression {
    private final Name name;
    private final Expression qualifier;
    private final Token dotToken;

    public QualifiedExpressionImpl(Name name, Expression qualifier, Token dotToken) {
        this.name = name;
        this.qualifier = qualifier;
        this.dotToken = dotToken;
    }

    @Override
    public Expression qualifier() {
        return this.qualifier;
    }

    @Override
    public Token dotToken() {
        return this.dotToken;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.QUALIFIED_EXPR;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitQualifiedExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.qualifier, this.dotToken, this.name).toList();
    }

    @Override
    public InferredType type() {
        Symbol symbol = this.name.symbol();
        if (symbol == null) {
            return InferredTypes.anyType();
        }
        return ((SymbolImpl)symbol).inferredType();
    }
}

