/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.PyTree;

public class ParameterListImpl
extends PyTree
implements ParameterList {
    private final List<AnyParameter> parameters;
    private final List<Token> commas;

    public ParameterListImpl(List<AnyParameter> parameters, List<Token> commas) {
        this.parameters = parameters;
        this.commas = commas;
    }

    @Override
    public List<Parameter> nonTuple() {
        return this.parameters.stream().filter(Parameter.class::isInstance).map(Parameter.class::cast).toList();
    }

    @Override
    public List<AnyParameter> all() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParameterList(this);
    }

    @Override
    public List<Tree> computeChildren() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        int i = 0;
        for (Tree tree : this.parameters) {
            children.add(tree);
            if (i < this.commas.size()) {
                children.add(this.commas.get(i));
            }
            ++i;
        }
        return children;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARAMETER_LIST;
    }
}

